/**
 * Copyright n0wri ( http://wonderfl.net/user/n0wri )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3m7s
 */

// forked from quqjp's Progression Command用 MultiListenコマンド
/**
* Progression Command Listeは１つのイベントの監視しかできないので、
* 複数のイベント監視ができるMultiListenをつくった
* @update completeの関数にEventを渡すようにした
*/
package {

    /**
     * インポート
     */
    import flash.events.*;
    import flash.display.Sprite;
	import flash.text.TextField;
    import jp.progression.commands.lists.*;
    import jp.progression.commands.managers.*;
    import jp.progression.commands.media.*;
    import jp.progression.commands.net.*;
    import jp.progression.commands.tweens.*;
    import jp.progression.commands.*;

    /**
     * テストクラス
     */
    public class FlashTest extends Sprite {

        //結果ケース１
        static public const EVENT_CASE_1:String = "__eventcase1__";
            
        //結果ケース２
        static public const EVENT_CASE_2:String = "__eventcase2__";
        
        //ログ出力用
        public var console:TextField = new TextField();


        /**
         * コンストラクタ
         */
        public function FlashTest() {
            this.console.textColor = 0x000000;
			this.console.width = 400;
			this.console.height = 400;
			this.addChild(console);
			this.run();
        }
        
		/**
		 * 実行
		 */
        public function run():void{
            
			var s:FlashTest = this;
			
			//
			//	メインのコマンドリスト
			//
			///////////////////////////////////////////////////////////////
			new SerialList(null,
				new MultiListen([this, EVENT_CASE_1, this, EVENT_CASE_2, this, Event.FULLSCREEN], {
					commandComplete:function(e:Event) {
						var cthis:MultiListen = MultiListen(this);
						if (cthis.type == EVENT_CASE_1) {
							//ケース１用コマンドを挿入
							cthis.parent.insertCommand(case1cl);
						}else if (cthis.type == EVENT_CASE_2) {
							//ケース２用コマンドを挿入
							cthis.parent.insertCommand(case2cl);
			        	}
					}
				})
			).execute();
				
            //
			//	イベントタイプ EVENT_CASE_1 だった際の処理を準備
			//
			///////////////////////////////////////////////////////////////
			var case1cl:SerialList = new SerialList(null,
				"ケース１です。",
				new Prop(this.console,{text:"ケース１です。"})
			);
				
			//
			//	イベントタイプ EVENT_CASE_2 だった際の処理を準備
			//
			///////////////////////////////////////////////////////////////
			var case2cl:SerialList = new SerialList(null,
				"ケース２です。",
				new Prop(this.console,{text:"ケース２です。"})
			);
				
				
				
				
			//イベント発行テスト
			new SerialList(null,
				new Wait(1),
				function() {
					s.dispatchEvent(new Event(EVENT_CASE_1))
					//s.dispatchEvent(new Event(EVENT_CASE_2))
				}
			).execute();
					
        }
		
		/**
		 * 
		 * @param	value
		 */
		protected function log(value:String):void{
			this.console.appendText(value + "\n");
		}
    }
}

import flash.events.Event;		
import flash.events.IEventDispatcher;
import jp.progression.commands.*;

/**
 * Command Listen を複数のListenに対応したようなもの
 * @author @quqjp
 */
class MultiListen extends Command {

	//dispatcherリスト
	protected var dispatchers:Vector.<IEventDispatcher> = new Vector.<IEventDispatcher>();
	
	//イベントタイプリスト
	protected var types:Vector.<String> = new Vector.<String>();
		
	//受信したイベントのDispatcher
	protected var _dispatcher:IEventDispatcher;
	public function get dispatcher():IEventDispatcher {
		return _dispatcher;
	}
	
	//受信したイベントのType
	protected var _type:String;
	public function get type():String {
		return _type;
	}
		
	//結果
	protected var _success:Boolean = false;
	public function get success():Boolean{
		return _success;
	}
		
	//完了時にCallするファンクション
	public var commandComplete:Function;
	
	public function MultiListen(eventSetList:Array,initObject:Object = null) {	
		// 親クラスを初期化します。
		super( _execute, _interrupt, initObject );
			
		if (eventSetList) {
			var list:Array = eventSetList as Array;
			if (list.length % 2 != 0) {
				throw new Error('引数が対になっていません。');
			}
			var l:uint = list.length;
			var f:Boolean = true;
			for (var i:uint = 0; i < l; i++) {
				if (f) {
					dispatchers.push(IEventDispatcher(list[i]));
				}else {
					types.push(String(list[i]));
				}
				f = !f;
			}
		}
				
	}
	
	/**
	 * 実行されるコマンドの実装です。
	 */
	private function _execute():void {
		var l:uint = dispatchers.length;
		for (var i:uint = 0; i < l; i++) {
			dispatchers[i].addEventListener(types[i],eventHandler);
		}
	}
	//
	private function eventHandler(e:Event):void {
		var l:uint = dispatchers.length;
		for (var i:uint = 0; i < l; i++) {
			if (dispatchers[i] == e.target && types[i] == e.type) {
				this._dispatcher = dispatchers[i];
				this._type = types[i];
				this._success = true;
			}
		}
		if (!this._success) {
			throw new Error('対象のeventDispatcher、typeがみつかりません');
		}
		destroy();
		if(Boolean(this.commandComplete)) this.commandComplete(e);
		executeComplete();
	}
	
	/**
	 * 中断されるコマンドの実装です。
	 */
	private function _interrupt():void {
		destroy();
	}
	
	/**
	 * 破壊
	 */
	protected function destroy():void{
		if(dispatchers){
			var l:uint = dispatchers.length;
			for (var i:uint = 0; i < l; i++) {
				dispatchers[i].removeEventListener(types[i],eventHandler);
			}
		}
	}
		
}
