/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3m5G
 */

package
{
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import frocessing.math.Random;
    
    public class Main extends Sprite
    {
        private const WIDTH:int = 5;            // 横のマス数
        private const HEIGHT:int = 5;            // 縦のマス数
        private const MASUSIZE_W:int = 30;        // 横のマスサイズ
        private const MASUSIZE_H:int = 30;        // 縦のマスサイズ
        private const NUM_BOMB:int = 4;            // 爆弾の数
        private var blocks:Array;                // クリックするブロックを入れる二次元配列
        private var map:Array;                    // 爆弾の位置が入っている二次元配列
        private var clickable:Boolean = false;    // clickableがfalseだとクリックしても反応しないようにする
        
        public function Main()
        {
            var bombMap:Array = [];
            var bombIndex:int = 0;
            for (var i:int = 0; i < WIDTH * HEIGHT; i++)
            {
                if (bombIndex++ < NUM_BOMB) bombMap[i] = Status.BOMB;
                else bombMap[i] = Status.FIELD;
            }
            bombMap = Random.shake(bombMap);
            
            map = [];
            for (var y:int = 0; y < HEIGHT; y++)
            {
                map[y] = [];
                for (var x:int = 0; x < WIDTH; x++)
                {
                    map[y][x] = bombMap[y * WIDTH + x];
                }
            }
            
            for (y = 0; y < HEIGHT; y++)
            {
                for (x = 0; x < WIDTH; x++)
                {
                    if (map[y][x] != Status.BOMB) continue;
                    for (var yy:int = -1; yy <= 1; yy++)
                    {
                        for (var xx:int = -1; xx <= 1; xx++)
                        {
                            if (yy == 0 && xx == 0) continue;
                            if (y + yy < 0 || HEIGHT <= y + yy || x + xx < 0 || WIDTH <= x + xx) continue;
                            if (map[y + yy][x + xx] != Status.BOMB) map[y + yy][x + xx]++;
                        }
                    }
                }
            }
            
            for (y = 0; y < HEIGHT; y++)
            {
                for (x = 0; x < WIDTH; x++)
                {
                    graphics.lineStyle(2.0);
                    graphics.drawRect(x * MASUSIZE_W, y * MASUSIZE_H, MASUSIZE_W, MASUSIZE_H);
                    var char:String = "*";
                    if (map[y][x] >= 1) char = map[y][x].toString();
                    
                    if (map[y][x] != 0)
                    {
                        var tf:TextField = new TextField();
                        tf.defaultTextFormat = new TextFormat("Consolas,メイリオ,_typeWriter", 20, 0x0, true);
                        tf.autoSize = "left";
                        tf.text = char;
                        tf.selectable = false;
                        tf.y = y * MASUSIZE_H;
                        tf.x = x * MASUSIZE_W + 7;
                        addChild(tf);
                    }
                }
            }
            
            blocks = [];
            for (y = 0; y < HEIGHT; y++)
            {
                blocks[y] = [];
                for (x = 0; x < WIDTH; x++)
                {
                    var block:Block = new Block(MASUSIZE_W, MASUSIZE_H);
                    block.y = y * MASUSIZE_H;
                    block.x = x * MASUSIZE_W;
                    addChild(block);
                    blocks[y][x] = block;
                }
            }
            
            clickable = true;
            stage.addEventListener(MouseEvent.CLICK, onMouseClick);
        }
        
        private function onMouseClick(event:MouseEvent):void 
        {
            if (!clickable) return;
            
            var ty:int = mouseY / MASUSIZE_H;
            var tx:int = mouseX / MASUSIZE_W;
            
            if (ty < 0 || HEIGHT <= ty || tx < 0 || WIDTH <= tx) return;
            
            var block:Sprite = blocks[ty][tx];
            if (block != null)
            {
                removeChild(block);
                blocks[ty][tx] = null;
            }
            
            if (map[ty][tx] == Status.BOMB)
            {
                trace("GAME OVER");
                clickable = false;
            }
        }
    }
}

import flash.display.Sprite;

class Block extends Sprite
{
    public function Block(width:Number, height:Number)
    {
        graphics.lineStyle(2.0);
        graphics.beginFill(0x888888);
        graphics.drawRect(0, 0, width, height);
        graphics.endFill();
    }
}

class Status
{
    public static const FIELD:int = 0;
    public static const BOMB:int = -1;
}