/**
 * Copyright kjkmr ( http://wonderfl.net/user/kjkmr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3led
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.Timer;
    import caurina.transitions.Tweener;
    import flash.events.TimerEvent;
    import flash.system.System;
    import flash.display.BitmapData;
    
    public class GarbageCollectionTest extends Sprite {
        
            private var _text:TextField = new TextField();
            private var _timer:Timer = new Timer( 2000 );
        
        public function GarbageCollectionTest() {
            // write as3 code here..
            GCChecker.init( this );
            GCChecker.addEventListener( GCEvent.GC, _onGC );
            //
            _timer.addEventListener( TimerEvent.TIMER, _onTimer );
            _timer.start();
            
            //
            _text.width = stage.stageWidth;
            _text.height = stage.stageHeight;
            _text.text = "Start!!\n";
            addChild( _text );
        }
        
        /*--------------------------------------------------
        メモリを無駄遣いする
        --------------------------------------------------*/
        private function _wasteMemory():void {
                //メモリをたくさんつかう。maxを100に設定すると毎回GCが走る
                var max:uint = 10;
                var b:BitmapData;
                for ( var i:uint; i<max; i++ ){
                    b = new BitmapData( stage.stageWidth, stage.stageHeight );
                    b.draw(this);
                }
        }
        
        /*--------------------------------------------------
        定期的にメモリを無駄遣いするためのTimerのハンドラ
        --------------------------------------------------*/
        private function _onTimer( i_event:TimerEvent ):void {
                _text.appendText( "Timer\n");
                _wasteMemory();
                //System.gc();//System.gcはDebugPlayerのみで有効らしい
        }
        
        /*--------------------------------------------------
        ガベージコレクション発生時のハンドラ
        --------------------------------------------------*/
        private function _onGC( i_event:GCEvent ):void {
                _text.appendText( "Garbages where collected!\n" );
        }
    }
}


import flash.utils.Dictionary;
import flash.display.Sprite;
import flash.events.EventDispatcher;
import flash.events.Event;
import flash.display.DisplayObject;
 
class GCChecker {
    private static var _dummyDic:Dictionary = new Dictionary( true );
    private static var _dispatcher:EventDispatcher = new EventDispatcher();
    private static var _displayObject:DisplayObject;
    private static function _onEnterFrame( i_event:Event ):void {
        var cnt:uint = 0;
        var item:*;
        for each ( item in _dummyDic ) cnt++;
        if ( cnt ) return;
        _dispatcher.dispatchEvent( new GCEvent( GCEvent.GC ) );
        _dummyDic[new Sprite()] = "dummy";
    }
            
    public static function init( i_displayObject:DisplayObject ):void {
        _displayObject = i_displayObject;
        _displayObject.addEventListener( Event.ENTER_FRAME, _onEnterFrame );
        _dummyDic[new Sprite()] = "dummy";
    }
    
    public static function addEventListener( i_type:String, i_handler:Function ):void {
        _dispatcher.addEventListener( i_type, i_handler );
    }
    
    public static function removeEventListener( i_type:String, i_handler:Function ):void {
        _dispatcher.removeEventListener( i_type, i_handler );
    }
            
}
    
class GCEvent extends Event {
    public static const GC:String = "gc";
    public function GCEvent( i_type:String, i_bubble:Boolean = false, i_cancelable:Boolean = false ) {
        super( i_type, i_bubble, i_cancelable );
    }
}
    
