/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3lZs
 */

package {
  import flash.display.*;
  import flash.events.Event;
  import flash.geom.*;
  import flash.utils.getTimer;
  public class ch40ex3 extends Sprite {
    protected var viewMatrix:Matrix3D;
    protected var modelMatrix:Matrix3D;
    protected var model:Plane3D;
    protected var projectedPoints:Vector.<Number> = new Vector.<Number>();
    protected var texturePoints:Vector.<Number> = new Vector.<Number>();
    public function ch40ex3() {
      this.x = stage.stageWidth/2;
      this.y = stage.stageHeight/2;
      var perspective:PerspectiveProjection = new PerspectiveProjection();
      perspective.fieldOfView = 50;
      perspective.projectionCenter = new Point(0, 0); 
      viewMatrix = new Matrix3D();
      viewMatrix.appendTranslation(0, 0, 20);
      viewMatrix.append(perspective.toMatrix3D());
      modelMatrix = new Matrix3D();
      model = new Plane3D(new Rectangle(-8, -4.5, 16, 9));
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    protected function onEnterFrame(event:Event):void {
      modelMatrix.identity();
      modelMatrix.appendRotation(getTimer()/30, Vector3D.Y_AXIS);
      modelMatrix.appendRotation(45*Math.sin(getTimer()/900), Vector3D.X_AXIS);
      var concatenatedMatrix:Matrix3D = modelMatrix.clone();
      concatenatedMatrix.append(viewMatrix);
      Utils3D.projectVectors(
        concatenatedMatrix, model.vertices, projectedPoints, texturePoints);
      graphics.clear();
      graphics.lineStyle(0, 1, 0.5);
      graphics.beginFill(0x808080, 1);
      graphics.drawTriangles(projectedPoints, model.indices);
    }
  }
}
import flash.geom.Rectangle;
import flash.geom.Vector3D;
class Plane3D {
  public var rect:Rectangle;
  public var vertices:Vector.<Number>;
  public var indices:Vector.<int>;
  public function Plane3D(r:Rectangle):void {
    rect = r;
    vertices = new Vector.<Number>();
    indices = new Vector.<int>();
    vertices.push(
      r.left, r.bottom, 0, //bottom left = 0
      r.left, r.top, 0,  //top left = 1
      r.right, r.top, 0, //top right = 2
      r.right, r.bottom, 0 //bottom right = 3
    );
    indices.push(
      0, 2, 1, //left-side triangle BL->TR->TL
      0, 3, 2 //right-side triangle BL->BR->TR
    );
  }
}