/**
 * Copyright djakarta_trap ( http://wonderfl.net/user/djakarta_trap )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3lIE
 */

package {
    import flash.display.Sprite;
    import flash.display.LineScaleMode;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize;
    import flash.events.MouseEvent;
    public class LineAnimation extends Sprite {
        private var _line:Sprite;
        private var _restartBtn:Sprite;
        
        public function LineAnimation() {
            _line = new Sprite();
            _line.graphics.lineStyle(1, 0x434343, 1, true, LineScaleMode.HORIZONTAL);
            _line.graphics.moveTo(0, 0);
            _line.graphics.lineTo(100, 0);
            _line.graphics.endFill();
            addChild(_line);
            _line.width = 0;
            _line.y = stage.stageHeight/2;
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            _restartBtn= new Sprite();
            
            var tf:TextField = new TextField();
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.selectable = false;
            tf.text = "restart"
            tf.setTextFormat(new TextFormat("_sans",12,0x0));
            _restartBtn.addChild(tf);
            _restartBtn.graphics.beginFill(0x999999);
            _restartBtn.graphics.drawRect(-(tf.textWidth+10)/2,-(tf.textHeight+10)/2,tf.textWidth+10,tf.textHeight+10);
            _restartBtn.graphics.endFill();
            tf.x = -tf.width/2;
            tf.y = -tf.height/2;
            tf.mouseEnabled = false;
            _restartBtn.addEventListener(MouseEvent.CLICK,_onCLICK)
            _restartBtn.useHandCursor = true;
            _restartBtn.buttonMode = true;
            
        }
        
        private function onEnterFrame(e:Event):void
        {
            _line.width += 0.5
            if(_line.width >= stage.stageWidth)
            {
                this.removeEventListener(Event.ENTER_FRAME,onEnterFrame);
                this.removeChild(_line);
                this.addChild(_restartBtn);
                _restartBtn.x = stage.stageWidth/2;
                _restartBtn.y = stage.stageHeight/2;
                
            }
        }
        
        private function _onCLICK(e:MouseEvent):void
        {
            _line.width = 0;
            this.addChild(_line);
            this.removeChild(_restartBtn);
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
    }
}