/**
 * Copyright h6k ( http://wonderfl.net/user/h6k )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3jxN
 */

package {
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
    import flash.utils.escapeMultiByte;
    import flash.net.URLRequest;
    import flash.net.navigateToURL;
    
    public class FlashTest extends Sprite {
		private const _sw:int = stage.stageWidth;		// ステージサイズ
		private const _sh:int = stage.stageHeight;
		private const _r:int = 25;					// 半径
		private const _2r:int = 50;					// 直径
		private const _limit:int = 30;				// 制限時間
		private const _col:Array = [0xFF0000, 0x00FF00, 0x0000FF, 0xFFFF00, 0xFF00FF, 0x00FFFF, 0xFFFFFF, 0x666666];	// カラーリスト
		
		private var _wait:int;	// 次の移動までのウェイト
		private var _level:int;	// レベル
		private var _nIdx:int;	// クリックすべきオブジェクト番号
		private var _miss:uint;	// ミスカウンタ
		private var _frame:uint;	// フレームカウンタ
		private var _dframe:int;	// 移動にかけるフレーム
		private var _fr:int;		// カウント用
		private var _click:uint;	// 総クリック数
		private var _timer:int;	// 残り時間用
		private var _gocnt:int;	// ゲームオーバー用
		
		private var _ttl:Title;
		private var _stat:TextField;
		private var _stfld:TextField = new TextField();
		private var _obj:Array = new Array(8);
		private var _tw:Sprite = new Sprite();
		private var _re:Sprite = new Sprite();
		
        public function FlashTest() {
            // write as3 code here..
			// 背景
			this.graphics.beginFill(0x000000, 1);
			this.graphics.drawRect(0, 0, _sw, _sh);
			this.graphics.endFill();
			stage.addEventListener(MouseEvent.CLICK, onStart);
			
			// wonderflをばらまく
			var col:Array = new Array(_col.length);
			var i:int;
			for (i = 0; i < _col.length; i++) {
				col[i] = _col[i];
			}
			col = shuffle(col);
			var index:int;
			for (i = _obj.length - 1; i >= 0; i--) {
				index = Math.random() * col.length;
				_obj[i] = new WONDERFL(i, Math.random() * (_sw - _2r), Math.random() * (_sh - _2r - 20) + 20, _r, col[index]);
				stage.addChild(_obj[i]);
				col.splice(index, 1);
			}
			
			// タイトル
			_ttl = new Title(_sw, _sh);
			stage.addChild(_ttl);
			
			// ステータス
			_stat = new TextField();
			_stat.textColor = 0xFFFFFF;
			_stat.mouseEnabled = false;
			_stat.width = _sw / 2;
			_stat.height = 20;
			stage.addChild(_stat);
        }
        
		private function onStart(e:MouseEvent):void {
			stage.removeEventListener(MouseEvent.CLICK, onStart);
			for (var i:int = 0; i < _obj.length; i++) {
				stage.removeChild(_obj[i]);
			}
			stage.removeChild(_ttl);
			
			_level = 1;
			_miss = 0;
			_click = 0;
			onReady();
		}
		
		private function onReady():void {
			_timer = _limit;
			_frame = 0;
			_stfld.text = "LEVEL " + _level;
			_stfld.autoSize = TextFieldAutoSize.LEFT;
			_stfld.textColor = 0xFFFFFF;
			_stfld.mouseEnabled = false;
			_stfld.x = _sw / 2 - (_stfld.width / 2);
			_stfld.y = _sh / 2 - (_stfld.height / 2);
			stage.addChild(_stfld);
			stage.addEventListener(Event.ENTER_FRAME, blink);
		}
		
		private function blink(e:Event):void {
			_frame++;
			if (_frame % 100 == 0) {
				stage.removeEventListener(Event.ENTER_FRAME, blink);
				stage.removeChild(_stfld);
				onGameStart();
			} else if (_frame % 40 == 0) {
				stage.addChild(_stfld);
			} else if(_frame % 20 == 0) {
				stage.removeChild(_stfld);
			}
		}
		
		private function onGameStart():void {
			var col:Array = new Array(_col.length);
			var i:int;
			for (i = 0; i < _col.length; i++) {
				col[i] = _col[i];
			}
			col = shuffle(col);
			var index:int;
			for (i = _obj.length - 1; i >= 0; i--) {
				index = Math.random() * col.length;
				_obj[i] = new WONDERFL(i, Math.random() * (_sw - _2r), Math.random() * (_sh - _2r - 20) + 20, _r, col[index]);
				_obj[i].addEventListener(MouseEvent.CLICK, onClick(i));
				stage.addChild(_obj[i]);
				col.splice(index, 1);
			}
			
			_wait = 60 - (_level * 5);
			if (_wait <= 0) { _wait = 2; }
			_dframe = _wait / 2;
			_frame = 0;
			_nIdx = 0;
			stage.addEventListener(MouseEvent.CLICK, clickCount);
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function clickCount(e:MouseEvent):void {
			if (_nIdx == _obj.length || _timer <= 0) {
				// クリアまたはゲームオーバー
				stage.removeEventListener(MouseEvent.CLICK, clickCount);
			} else {
				_click++;
			}
		}
		
		private function shuffle(arr:Array):Array {
			var tmp:Array = [];
			var index:int;
			while (arr.length > 0) {
				index = Math.random() * arr.length;
				tmp.push(arr[index]);
				arr.splice(index, 1);
			}
			return tmp;
		}
		
		private function onClick(i:int):Function {
			return function(e:MouseEvent):void {
				if (i == _nIdx) {
					// OK
					_obj[i].removeEventListener(MouseEvent.CLICK, arguments.callee);
					stage.removeChild(_obj[i]);
					_nIdx++;
				} else {
					// ミス
					_miss++;
				}
			}
		}
		
		private function onEnterFrame(e:Event):void {
			var tar:Object;
			_stat.text = "残り時間：" + _timer + "sec  ミス：" + _miss + "  総クリック数：" + _click;
			
			if (_nIdx == _obj.length) {
				// クリア
				stage.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
				_level++;
				onReady();
			} else if (_timer <= 0) {
				// ゲームオーバー
				stage.removeEventListener(Event.ENTER_FRAME, onEnterFrame);
				_gocnt = 0;
				stage.addEventListener(Event.ENTER_FRAME, onGameOver);
				addButton();
			} else {
				_frame++;
				if (_fr < _dframe) { _fr++; }
				_timer = Math.ceil(_limit - (_frame / stage.frameRate));
				for (var i:int = 0; i < _obj.length; i++) {
					tar = _obj[i];
					if (_frame % _wait == 0) {
						tar.tox = Math.random() * (_sw - _2r);
						tar.toy = Math.random() * (_sh - _2r - 20) + 20;
						_fr = 0;
					}
					if (tar.x != tar.tox || tar.y != tar.toy) {
						tar.x = (tar.tox - tar.x) * _fr / _dframe + tar.x;
						tar.y = (tar.toy - tar.y) * _fr / _dframe + tar.y;
					}
				}
			}
		}
		
		// 残りのオブジェクトを消去
		private function onGameOver(e:Event):void {
			_frame++;
			if (_nIdx + _gocnt == _obj.length) {
				stage.removeEventListener(Event.ENTER_FRAME, onGameOver);
			} else if (_frame % 10 == 0) {
				stage.removeChild(_obj[_nIdx + _gocnt]);
				_gocnt++;
			}
		}
		
		private function addButton():void {
			var refld:TextField = new TextField();
			refld.text = "もう一度やる";
			refld.textColor = 0xFFFFFF;
			refld.autoSize = TextFieldAutoSize.LEFT;
			refld.mouseEnabled = false;
			refld.x = _sw / 2 - (refld.width / 2);
			refld.y = _sh / 2 - (refld.height / 2);
			_re.buttonMode = true;
			_re.addChild(refld);
			_re.addEventListener(MouseEvent.CLICK, onRestart);
			stage.addChild(_re);
			
			var twfld:TextField;
			if (!(_level == 1 && _nIdx == 0)) {
				twfld = new TextField();
				twfld.text = "結果をツイート";
				twfld.textColor = 0xFFFFFF;
				twfld.autoSize = TextFieldAutoSize.LEFT;
				twfld.mouseEnabled = false;
				twfld.x = _sw / 2 - (twfld.width / 2);
				twfld.y = _sh / 2 - (twfld.height / 2) + 40;
				_tw.buttonMode = true;
				_tw.addEventListener(MouseEvent.CLICK, onTweet);
				_tw.addChild(twfld);
				stage.addChild(_tw);
			}
		}
		
		private function onTweet(e:MouseEvent):void {
			if (--_nIdx < 0) {
				_level--;
				_nIdx = _obj.length - 1;
			}
			var result:String = "「Wonderflを追え！」の結果:レベル" + _level + "の[" + _obj[_nIdx].text + "]、ミス" + _miss + "回、総クリック数" + _click + "回でした。";
			var url:String = "http://twitter.com/home?status=" + escapeMultiByte(result) + " http://wonderfl.net/c/3jxN %23wonderfl";
			var req:URLRequest = new URLRequest(url);
			navigateToURL(req);
		}
		
		private function onRestart(e:MouseEvent):void {
			_re.removeEventListener(MouseEvent.CLICK, onRestart);
			stage.removeChild(_re);
			if (stage.contains(_tw)) { stage.removeChild(_tw); }
			_level = 1;
			_miss = 0;
			_click = 0;
			onReady();
		}
    }
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.geom.Matrix;
class WONDERFL extends Sprite
{
	public var tox:int, toy:int;
	public var text:String;
	
	public function WONDERFL(_idx:int, _x:int, _y:int, _r:int, _col:uint):void {
		var word:Array = ["W", "O", "N", "D", "E", "R", "F", "L"];
		
		var fmt:TextFormat = new TextFormat();
		fmt.bold = true;
		fmt.size = _r;
		
		var fld:TextField = new TextField();
		fld.defaultTextFormat = TextFormat(fmt);
		fld.text = this.text = word[_idx];
		fld.textColor = 0xFFFFFF - _col;
		fld.autoSize = TextFieldAutoSize.LEFT;
		fld.mouseEnabled = false;
		fld.x = _r - (fld.width / 2);
		fld.y = _r - (fld.height / 2);
		
		var matrix:Matrix = new Matrix();
		matrix.createGradientBox(_r * 2, _r * 2, Math.PI);
		this.graphics.beginGradientFill("radial", [_col, 0x000000], [100, 100], [32, 255], matrix);
		this.graphics.drawCircle(_r, _r, _r);
		this.graphics.endFill();
		this.x = this.tox = _x;
		this.y = this.toy = _y;
		this.buttonMode = true;
		this.addChild(fld);
	}
}

class Title extends Sprite
{
	public function Title(_sw:int, _sh:int):void {
		var ttl:TextField = new TextField();
		ttl.text = "WONDERFLを追え！";
		ttl.autoSize = TextFieldAutoSize.LEFT;
		ttl.x = _sw / 2 - (ttl.width / 2);
		ttl.y = _sh / 2 - (ttl.height / 2) - 40;
		ttl.mouseEnabled = false;
		ttl.textColor = 0xFFFFFF;
		this.addChild(ttl);
		
		var desc:TextField = new TextField();
		desc.text = "[W][O][N][D][E][R][F][L]の順にクリック";
		desc.autoSize = TextFieldAutoSize.LEFT;
		desc.x = _sw / 2 - (desc.width / 2);
		desc.y = _sh / 2 - (desc.height / 2);
		desc.mouseEnabled = false;
		desc.textColor = 0xFFFFFF;
		this.addChild(desc);
		
		var cts:TextField = new TextField();
		cts.text = "クリックでスタート";
		cts.autoSize = TextFieldAutoSize.LEFT;
		cts.x = _sw / 2 - (cts.width / 2);
		cts.y = _sh / 2 - (cts.height / 2) + 40;
		cts.mouseEnabled = false;
		cts.textColor = 0xFFFFFF;
		this.addChild(cts);
	}
}