/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3jbp
 */

/*顔認識API「detectFace();」の実験。
環境光によっては著しく認識精度が落ちて
しまうようです。*/
package {
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.display.DisplayObject;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.net.URLRequest;
    import flash.net.URLLoader;
    import flash.utils.ByteArray;
    import flash.system.Security;
    import flash.system.ApplicationDomain;
    import flash.system.LoaderContext;
    import com.adobe.images.JPGEncoder;
    
    [SWF(width="465", height="465", backgroundColor="#000000", frameRate="30")]

    public class Main extends MovieClip {
        
        private var _loader:Loader = new Loader();
        private var _BtnSet:Class;
        private var _Wait:Class;
        private var _btnSet:MovieClip;
        private var _bt0:*;
        private var _bt1:*;
        private var _wait:Sprite;
        private var _video:Video = new Video();
        private var _videoContainer:Sprite = new Sprite();
        private var _camera:Camera;
        private var _ba:ByteArray;
        private var _mcList:Array;
        private var _len:int;
        private var _faceList:Array = new Array();
        private var _sendData:SendAndLoadData;
        private var _bmpd:BitmapData;
        private var _jpgEncoder:JPGEncoder;
        private var _quality:Number = 70;
        
        public function Main() {
            Security.loadPolicyFile("http://www.digifie.jp/crossdomain.xml");
            Security.allowDomain("www.digifie.jp");
            //
            _jpgEncoder = new JPGEncoder(_quality);
            _sendData = new SendAndLoadData();
            addChild(_videoContainer);
            _videoContainer.addChild(_video);
            _video.width = 465;
            _video.height = 349;
            //
            swfLoad();
        }
        
        private function swfLoad():void{
            var context:LoaderContext = new LoaderContext(); 
            context.checkPolicyFile = true;
            context.applicationDomain = ApplicationDomain.currentDomain;   
            var req:URLRequest = new URLRequest("http://www.digifie.jp/files/detectface_parts.swf");
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, swfLoadComplete);
            _loader.load(req, context);
        }
        
        private function swfLoadComplete(e:Event):void {
            for(var i:int=1;i<9;i++){
                var cls:Class = _loader.contentLoaderInfo.applicationDomain.getDefinition("face"+i) as Class;
                _faceList.push(cls);
            }
            _BtnSet = _loader.contentLoaderInfo.applicationDomain.getDefinition("btnSet") as Class;
            _btnSet = new _BtnSet();
            this.addChild(_btnSet);
            _bt0 = _btnSet.bt;
            _bt1 = _btnSet.bt2;
            _Wait = _loader.contentLoaderInfo.applicationDomain.getDefinition("wait") as Class;
            _wait = new _Wait();
            this.addChild(_wait);
            _wait.visible = false;
            //
            init();
        }
        
        
        private function init():void{
            setupCamera(_video, 465, 349, 24);
            _bt0.enabled = true;
            _bt1.enabled = false;
            _bt0.addEventListener(MouseEvent.CLICK, btnPress);
        }
        
        //カメラ
        private function setupCamera(video:Video, cX:int = 465, cY:int = 349, fps:Number = 24):void{
            var camX:int = cX;
            var camY:int = cY;
            _camera = new Camera();
            _camera = Camera.getCamera();
            _camera.setMode(camX,camY,fps);
            video.attachCamera(_camera);
        }
        private function removeCamera(video:Video):void{
            video.attachCamera(null);
            _camera = null;
        }
        
        //JPGEncoder
        private function JPGEncord(traget_mc:Sprite):void {
            if (_bmpd != null) {
                _bmpd.dispose();
            }
            _bmpd = new BitmapData(465,349,false,0xFFFFFF);
            var bmp:Bitmap = new Bitmap(_bmpd);
            _bmpd.draw(traget_mc,null,null,null,null,true);
            //
            _ba = _jpgEncoder.encode(_bmpd);
        }
        
        //画像を生成して送信
        private function faceDetect():void{
            JPGEncord(_videoContainer);
            _sendData.SendAndLoad("http://detectface.com/api/detect", _ba);
            _sendData.addEventListener(SendAndLoadData.LOAD_SUCCESS,successFunc);
            _sendData.addEventListener(SendAndLoadData.LOAD_ERROR,loadErrorFunc);
            _sendData.addEventListener(SendAndLoadData.CONNECT_ERROR,IOErrorFunc);
            //
            _wait.visible = true;
        }
        
        private function successFunc(e:Event):void {
            _sendData.removeEventListener(SendAndLoadData.LOAD_SUCCESS,successFunc);
            _sendData.removeEventListener(SendAndLoadData.LOAD_ERROR,loadErrorFunc);
            _sendData.removeEventListener(SendAndLoadData.CONNECT_ERROR,IOErrorFunc);
            //
            faceDetectComplete();
        }
        private function loadErrorFunc(e:Event):void {
            _sendData.removeEventListener(SendAndLoadData.LOAD_SUCCESS,successFunc);
            _sendData.removeEventListener(SendAndLoadData.LOAD_ERROR,loadErrorFunc);
            _sendData.removeEventListener(SendAndLoadData.CONNECT_ERROR,IOErrorFunc);
            //
            _wait.visible = false;
        }
        private function IOErrorFunc(e:Event):void {
            _sendData.removeEventListener(SendAndLoadData.LOAD_SUCCESS,successFunc);
            _sendData.removeEventListener(SendAndLoadData.LOAD_ERROR,loadErrorFunc);
            _sendData.removeEventListener(SendAndLoadData.CONNECT_ERROR,IOErrorFunc);
            //
            _wait.visible = false;
        }
        
        //ボタン
        private function btnPress(e:MouseEvent):void{
            switch(e.currentTarget){
                case _bt0:
                    faceDetect();
                    removeCamera(_video);
                    break;
                case _bt1:
                    retry();
                    break;
            }
        }
        
        //処理完了
        private function faceDetectComplete():void{
            _wait.visible = false    ;        
            //xml解析
            var xml:XML = XML(_sendData.resData);
            var len:int = xml.face.length();
            _len = len;
            //
            _mcList = new Array();
            for(var i:int=0; i<len; i++){
                var mc:MovieClip;
                var ran:int = Math.floor(Math.random()*_faceList.length);
                mc = new(_faceList[ran]);
                stage.addChild(mc);
                mc.x = Number(xml.face[i].bounds.attributes()[0]);
                mc.y = Number(xml.face[i].bounds.attributes()[1]);
                mc.width = Number(xml.face[i].bounds.attributes()[2])*1.5;
                mc.height = Number(xml.face[i].bounds.attributes()[3])*2;
                //
                _mcList.push(mc);
            }
            //
            _bt0.enabled = false;
            _bt1.enabled = true;
            _bt0.removeEventListener(MouseEvent.CLICK, btnPress);
            _bt1.addEventListener(MouseEvent.CLICK, btnPress);
        }
        
        //
        private function retry():void{
            for(var i:int=0; i<_len; i++){
                stage.removeChild(_mcList[i]);
            }
            _bt1.removeEventListener(MouseEvent.CLICK, btnPress);
            init();
        }

    }
}
import flash.utils.ByteArray;


//
import flash.events.EventDispatcher;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.SecurityErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.net.URLRequest;
import flash.net.URLLoader;
import flash.net.URLRequestMethod;

class SendAndLoadData extends EventDispatcher {

    private var _loader:URLLoader = new URLLoader();

    public static const LOAD_SUCCESS:String = "load_success";
    public static const LOAD_ERROR:String = "load_error";
    public static const CONNECT_ERROR:String = "connect_error";

    public function SendAndLoadData() {
    }
    
    public function SendAndLoad(url:String, sendData:ByteArray):void {
        var req:URLRequest = new URLRequest();
        req.data = sendData;
        req.url = url;
        req.method = URLRequestMethod.POST;
        req.contentType = "image/jpeg";
        //
        _loader.addEventListener(Event.COMPLETE,onComplete);
        _loader.addEventListener(IOErrorEvent.IO_ERROR,ioErrorFunc);
        _loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR,securityErrorFunc);
        _loader.addEventListener(HTTPStatusEvent.HTTP_STATUS,httpStatusFunc);
        //
        _loader.load(req);
    }

    private function onComplete(e:Event):void {
        e.target.removeEventListener(Event.COMPLETE,onComplete);
        e.target.addEventListener(IOErrorEvent.IO_ERROR,ioErrorFunc);
        e.target.addEventListener(SecurityErrorEvent.SECURITY_ERROR,securityErrorFunc);
        e.target.addEventListener(HTTPStatusEvent.HTTP_STATUS,httpStatusFunc);
        if (_loader.data == "error") {
            dispatchEvent(new Event(SendAndLoadData.LOAD_ERROR));
        } else {
            dispatchEvent(new Event(SendAndLoadData.LOAD_SUCCESS));
        }
    }
    private function ioErrorFunc(e:IOErrorEvent):void {
        dispatchEvent(new Event(SendAndLoadData.CONNECT_ERROR));
        e.target.removeEventListener(Event.COMPLETE,onComplete);
        e.target.addEventListener(IOErrorEvent.IO_ERROR,ioErrorFunc);
        e.target.addEventListener(SecurityErrorEvent.SECURITY_ERROR,securityErrorFunc);
    }
    private function securityErrorFunc(e:SecurityErrorEvent):void {
        dispatchEvent(new Event(SendAndLoadData.CONNECT_ERROR));
        e.target.removeEventListener(Event.COMPLETE,onComplete);
        e.target.addEventListener(IOErrorEvent.IO_ERROR,ioErrorFunc);
        e.target.addEventListener(SecurityErrorEvent.SECURITY_ERROR,securityErrorFunc);
    }
    private function httpStatusFunc(e:HTTPStatusEvent):void {
        e.target.addEventListener(HTTPStatusEvent.HTTP_STATUS,httpStatusFunc);
    }

    public function get resData():String {
        return _loader.data;
    }
}