/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3jTa
 */

// forked from Event's Simple MediaRSS Viewer

/*
サムネイルをクリックすると、モザイクエフェクトで大きな画像を表示し、
開いた画像を閉じる時は画像をクリック。

それにしても、もっとスマートにコーディングしたかったのに、
結局カオスでスパゲティなぐちゃぐちゃコードになってしまった。。。
で、結局出来たものは概ねフツーの画像ビューワーだったという…

ぅ〜ん、残念！
また出直してきます。
*/

package {
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter
    import flash.filters.DropShadowFilter
    import flash.filters.GlowFilter;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.net.URLLoader;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import flash.utils.ByteArray;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import fl.motion.easing.*;
    import com.flashdynamix.motion.*;
    
    [SWF(width=465, height=465, backgroundColor=0xF6F6F6, frameRate=30)]
    
    public class Main extends Sprite {
        private static const W:Number = 465;
        private static const H:Number = 465;
        private static const MOSAIC_RANGE:int = 16;
        private static const SPEED:Number = 0.2;
        private static const FEED:String = "http://api.flickr.com/services/feeds/photos_public.gne?tags=skimboard&format=rss_200";        private static const MEDIA:Namespace = new Namespace("http://search.yahoo.com/mrss/");  
        private var _blackScreen:Sprite = new Sprite();
        private var _msg:TextField = new TextField();
        private var _caption:TextField = new TextField();
        private var _fmt:TextFormat = new TextFormat("_typewriter", 14, 0xFFFFFF, true, false, false, null, null, "center", null, null, null, 2);
        //
        private var _thumbList:Vector.<Thumbnail> = new Vector.<Thumbnail>();
        private var _contentURL_List:Array;
        private var _contentType_List:Array;
        private var _contentTitle_List:Array = new Array();
        private var _tween:TweensyGroup;
        //
        private var _bmd:BitmapData;
        private var _bm:Bitmap;
        private var _copyBmd:BitmapData;
        private var _drawBmd:BitmapData;
        private var _mosaicCount:Number;
                
        public function Main() {
            var ldr:URLLoader = new URLLoader;
            ldr.addEventListener(Event.COMPLETE, feedLoad);
            ldr.load(new URLRequest(FEED));
            //
            Security.loadPolicyFile("http://api.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm1.static.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm2.static.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm3.static.flickr.com/crossdomain.xml");
            Security.loadPolicyFile("http://farm4.static.flickr.com/crossdomain.xml");
            //
            function feedLoad(e:Event):void{
                ldr.removeEventListener(Event.COMPLETE, feedLoad);
                _contentURL_List = XML(ldr.data)..MEDIA::content.@url.toXMLString().split('\n');
                _contentType_List = XML(ldr.data)..MEDIA::content.@type.toXMLString().split('\n');
                for each(var item:String in XML(ldr.data)..MEDIA::title){
                    _contentTitle_List.push(item)
                }
                onImageLoaded(XML(ldr.data)..MEDIA::thumbnail.@url.toXMLString().split('\n'));
            }
            //
            _blackScreen.graphics.beginFill(0, 0.8)
            _blackScreen.graphics.drawRect(0, 0, W, H)
            _blackScreen.graphics.endFill()
            _blackScreen.visible = false
            _blackScreen.alpha = 0
            _msg.defaultTextFormat = _fmt
            _msg.selectable = false
            _msg.width = W
            _msg.y = H/2
            _caption.defaultTextFormat = _fmt
            _caption.selectable = false
            _caption.width = W
            _caption.y = H-30
            _caption.filters = [new GlowFilter(0x072B53, 1, 6, 6, 5)]
            _blackScreen.addChild(_msg)
            _blackScreen.addChild(_caption)
        }
        
        private function onImageLoaded($images:Array):void {
            var container:Sprite = new Sprite;
            var ldr:Loader;
            for (var i:int = 0; i < $images.length; ++i) {
                ldr = new Loader;
                ldr.load(new URLRequest($images[i]));
                //
                var thumb:Thumbnail = new Thumbnail(i, _contentType_List[i])
                ldr.x -= 42
                ldr.y -= 42
                thumb.x = (i % 5) * 85;
                thumb.y = Math.floor(i / 5) * 100;
                thumb.addChild(ldr);
                container.filters = [new DropShadowFilter(3, 90, 0, 0.6, 5, 5, 1, 2)]
                container.addChild(thumb);
                _thumbList.push(thumb)
                //
                thumb.addEventListener(MouseEvent.CLICK, onClick)
            }
            container.x = 25 + 42
            container.y = 85
            addChild(container);
            addChild(_blackScreen)
        }
        
        // thumbnail click
        private function onClick(e:MouseEvent):void{
            for(var i:int = 0; i < _thumbList.length; ++i){
                _thumbList[i].removeEventListener(MouseEvent.CLICK, onClick)
            }
            var thumb:Thumbnail = e.currentTarget as Thumbnail ;
            btnAnimation(thumb, 0.7);
            //
            if(_bm){
                _blackScreen.removeChild(_bm)
                _drawBmd.dispose()
                _bm = null
            }
            _caption.text = _contentTitle_List[thumb.thumbID]
            if(thumb.contentType == "image/jpeg"){
                addImage(_contentURL_List[thumb.thumbID])
            }else{
                _blackScreen.addEventListener(MouseEvent.CLICK, closed)
                _msg.text = "sorry...\n not load image"
            }
        }
        
        // image close
        private function closed(e:MouseEvent):void{
            _blackScreen.removeEventListener(MouseEvent.CLICK, closed)
            hideTween(_blackScreen, 1)
        }
        
        // click animation
        public function btnAnimation(sp:Sprite, time:Number, delay:Number=0, minScale:Number=0.8, blureVal:Number=8):void{
            _tween = new TweensyGroup();
            var blure:BlurFilter = new BlurFilter(0,0,1)
            sp.visible = true
            _tween.to(sp, {scaleX:minScale, scaleY:minScale},time, Bounce.easeOut, delay);
            _tween.filterTo(sp, blure, { blurX:blureVal , blurY:blureVal },time, Bounce.easeOut, delay) 
            _tween.to(sp, {scaleX:1, scaleY:1},time, Bounce.easeOut, delay+time);
            _tween.filterTo(sp, blure, { blurX:0 , blurY:0 },time, Bounce.easeOut, delay+time) 
            //
            _tween.onComplete = memoryClear;
            function memoryClear():void{
                _tween.dispose();
                _tween = null;
                blure = null;
                showTween(_blackScreen, 1)
            }
        }
        
        // show
        public function showTween(sp:Sprite, time:Number, delay:Number=0):void{
            _tween = new TweensyGroup();
            sp.visible = true
            _tween.to(sp, {alpha:1}, time, null, delay);
            _tween.onComplete = memoryClear;
            function memoryClear():void{
                _tween.dispose();
                _tween = null;
            }
        }
        
        // hide
        public function hideTween(sp:Sprite, time:Number, delay:Number=0):void{
            _tween = new TweensyGroup();
            _tween.to(sp, {alpha:0}, time, null, delay);
            _tween.onComplete = memoryClear;
            function memoryClear():void{
                sp.visible = false
                _tween.dispose();
                _tween = null;
                for(var i:int = 0; i < _thumbList.length; ++i){
                    _thumbList[i].addEventListener(MouseEvent.CLICK, onClick)
                }
                _caption.text = ""
            }
        }
        
        // added image
        private function addImage(url:String):void{
            var ran:uint = uint(new Date())
            var loader:Loader = new Loader();
            loader.load(new URLRequest(url+"?="+ran), new LoaderContext(true))
            loader.contentLoaderInfo.addEventListener(Event.INIT, init);
            _msg.text = "loading image..."
            //
            function init(e:Event):void{
                _msg.text = ""
                var r:Number = loader.width / loader.height
                _mosaicCount = MOSAIC_RANGE
                //
                if(r >= 1){
                    var m:Number = W / loader.width
                    _bmd = new BitmapData(W, H / r , true, 0)
                }else{
                    m = H / loader.height
                    _bmd = new BitmapData(W * r, H , true, 0)
                }
                _drawBmd = new BitmapData(_bmd.width, _bmd.height, true, 0)
                _bm = new Bitmap(_drawBmd, "auto", false)
                _bm.x = (W / 2 - _bmd.width / 2)
                _bm.y = (H / 2 - _bmd.height / 2)
                _blackScreen.addChildAt(_bm, 0)
                //
                _bmd.draw(loader.content, new Matrix(m, 0, 0, m))
                addEventListener(Event.ENTER_FRAME, update)
                loader.unload()
            }
        }
        
        private function update(e:Event):void{
            if(_mosaicCount >= 1){
                _copyBmd = new BitmapData(_bmd.width / _mosaicCount , _bmd.height / _mosaicCount , true, 0)
                _copyBmd.draw(_bmd, new Matrix(1 / _mosaicCount, 0, 0, 1 / _mosaicCount))
                _drawBmd.draw(_copyBmd)
                _bm.scaleX = _bm.scaleY = _mosaicCount
                _mosaicCount -= SPEED
            }else{
                removeEventListener(Event.ENTER_FRAME, update);
                _blackScreen.addEventListener(MouseEvent.CLICK, closed)
                _mosaicCount = MOSAIC_RANGE
                _bmd.dispose()
                _copyBmd.dispose()
            }
        }
        
        /*private function addSwf(url:String):void{
            var loader:URLLoader = new URLLoader();
            loader.dataFormat = "binary" //URLLoaderDataFormat.BINARY;
            loader.load(new URLRequest(url))
            loader.addEventListener(Event.COMPLETE, swfLoadComplete);
            //
            function swfLoadComplete(e:Event):void{
                var ba:ByteArray = e.target.data
                var baLoader:Loader =  new Loader();
                baLoader.loadBytes(ba);
                baLoader.contentLoaderInfo.addEventListener(Event.INIT, init);
                //
                function init(e:Event):void{
                    addChild(baLoader.content)
                }
            }
        }*/
        
        private function bmdResized(src:BitmapData, hRatio:Number, vRatio:Number):BitmapData{
          var res:BitmapData = new BitmapData(Math.ceil(src.width * hRatio), Math.ceil(src.height * vRatio));
          res.draw(src, new Matrix(hRatio, 0, 0, vRatio), null, null, null, true);
          return res;
        }
    }
}

// class Thumbnail
import flash.display.Sprite;
class Thumbnail extends Sprite{
    public var thumbID:int
    public var contentType:String
    
    public function Thumbnail(id:int, type:String = ""){
        thumbID = id
        contentType = type
    }
}