/**
 * Copyright adamh ( http://wonderfl.net/user/adamh )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3jLI
 */

// forked from adamh's flash on 2012-6-18
package {
    import flash.system.Security;
    import flash.net.NetConnection;
    import flash.net.NetStream;
    import flash.net.navigateToURL;
    import flash.net.URLRequest;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.media.Video;
    import flash.media.SoundTransform;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.NetStatusEvent;
    import flash.external.ExternalInterface;

    public class FlashTest extends Sprite {

        private var nc:NetConnection;
        private var ns:NetStream;
        private var vid:Video;
        private var client:Object;

        private var firstStart:Boolean = true;
        private var isPlaying:Boolean = false;
        private var isBuffering:Boolean = true;
        private var isMuted:Boolean = false;
        private var isComplete:Boolean = false;
        private var isVideoAttached:Boolean = false;

        private var vidAspect:Number = 16/9;

        private var flashvars:Object;
        
        private var clickoutBtn:Sprite;
        private var bufferAnim:LoadAnim;

        public function FlashTest() {
            Security.allowDomain("*");
            Security.allowInsecureDomain("*");
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;

            flashvars = LoaderInfo(this.root.loaderInfo).parameters;

            //Sort out the video
            nc = new NetConnection();
            nc.connect (null); // Not using a media server.
            ns = new NetStream(nc);

            vid = new Video();
            vid.x = 0;
            vid.y = 0;
            vid.attachNetStream( ns );
            
            ns.client = {
                onPlayStatus: function(info:Object):void {
                    if(info.code == 'NetStream.Play.Complete') {
                        isComplete = true;
                        track('stop', 'videoplay');
                        track('start', 'videoend');
                        try { ExternalInterface.call(flashvars.fn_cntrl, "complete"); } catch(e:Object){}
                    }
                },
                onMetaData: function(info:Object):void {
                    vidAspect = info.width / info.height;
                    layout();
                }
            };
            //Manage buffering
            ns.bufferTime = 5;
            ns.addEventListener(NetStatusEvent.NET_STATUS, function(event:NetStatusEvent):void {
                if(isComplete) return;
                try {    
                    if(event.info.code == "NetStream.Buffer.Empty") {
                        isBuffering = true;
                        addChild(bufferAnim);
                        if(isPlaying) track('stop', 'videoplay');
                    }
                    if(event.info.code == "NetStream.Buffer.Full") {
                        isBuffering = false;
                        removeChild(bufferAnim);
                        if(isPlaying) track('start', 'videoplay');
                        if(firstStart) {
                            firstStart = false;
                            try { ExternalInterface.call(flashvars.fn_cntrl, "ready"); } catch(e:Object){}
                            playVid();
                            track('', 'videostart');
                        }
                    }
                } catch(e:Object){}
            });
            
            //Mute video and set it off loading
            setMuted(true);
            ns.play ( flashvars.video || 'http://fileserver.glam.com/adamh/dior_underlay/Dior_Addict_v2.mp4' );

            //Manage clickout
            if(flashvars.clickout) {
                clickoutBtn = new Sprite();
                clickoutBtn.graphics.beginFill(0x000000, 0);
                clickoutBtn.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
                clickoutBtn.graphics.endFill();
                clickoutBtn.buttonMode = true;
                clickoutBtn.addEventListener(MouseEvent.CLICK, function():void {
                    track('', 'exit', 'video');
                    navigateToURL(new URLRequest(flashvars.clickout), "_blank");
                });
                addChild(clickoutBtn);
            }

            //Add function for JS to call
            try {
                ExternalInterface.addCallback("notify", function(act:String):void {
                    if(act == "play") playVid();
                    else if(act == "pause") pauseVid();
                    else if(act == "mute") setMuted(true);
                    else if(act == "unmute") setMuted(false);
                    else if(act == "restart") ns.seek(0);
                    else if(act == "close") {
                        pauseVid();
                        try{removeChild(vid);}catch(e:Object){}
                        isVideoAttached = false;
                    }
                });
            } catch(e:Object) {}

            //Create buffering animation
            bufferAnim = new LoadAnim(0x333333);
            addChild(bufferAnim);
            
            stage.addEventListener(Event.RESIZE, layout);
        }

        private function track(type:String, name:String, code:String = ""):void {
            var method:String = type == 'start' ? 'startTimer' : type == 'stop' ? 'stopTimer' : 'track';
            try { ExternalInterface.call(flashvars.tracker+'.'+method, name, code); } catch(e:Object){}
            trace("tracker."+method+"("+name+", "+code+")");
        }

        private function pauseVid():void {
            isPlaying = false;
            ns.pause();
            track('stop', 'videoplay');
        }

        private function playVid():void {
            if(isBuffering) return;
            if(!isVideoAttached) addChild(vid);
            if(isComplete) {
                ns.seek(0);
                isComplete = false;
                track('', 'videorestart')
            }
            isPlaying = true;
            ns.resume();
            track('start', 'videoplay');
        }

        private function setMuted(shouldMute:Boolean):void {
            var st:SoundTransform = new SoundTransform();
            st.volume = shouldMute ? 0 : 1;
            ns.soundTransform = st;
            isMuted = shouldMute;
        }

        private function layout(e:Event = null):void {
            var dWidth:Number, dHeight:Number,
                stageAspect:Number = stage.stageWidth / stage.stageHeight,
                heightLimited:Boolean = stageAspect > vidAspect;

            if(flashvars.display == 'cover') {
                //Size to cover container (crop)
                if(heightLimited) {
                    dWidth = stage.stageWidth;
                    dHeight = stage.stageWidth / vidAspect;
                } else {
                    dWidth = stage.stageHeight * vidAspect;
                    dHeight = stage.stageHeight;
                }
            } else if(flashvars.display == 'contain') {
                //Size to fit within container
                if(heightLimited) {
                    dWidth = stage.stageHeight * vidAspect;
                    dHeight = stage.stageHeight;
                } else {
                    dWidth = stage.stageWidth;
                    dHeight = stage.stageWidth / vidAspect;
                }
            } else { //fill
                dWidth = stage.stageWidth;
                dHeight = stage.stageHeight;
            }

            vid.x = (stage.stageWidth - dWidth) / 2;
            vid.width = dWidth;
            vid.height = dHeight;
            
            if(clickoutBtn) {
                clickoutBtn.width = stage.stageWidth;
                clickoutBtn.height = stage.stageHeight;                
            }
            if(bufferAnim) {
                bufferAnim.x = stage.stageWidth / 2;
                bufferAnim.y = 25;
            }
        }
    }
}

import flash.display.Sprite;
import flash.utils.Timer;
import flash.events.Event;
import flash.events.TimerEvent;

class LoadAnim extends Sprite{

    private var _anim:Sprite;
    private var _rotate:Number = 0;
    private var _animTimer:Timer;
    private var _animColor:Number;

    public function LoadAnim(color:Number = 0xFFFFFF) {
        _animColor = color;
        _anim = new Sprite();
        addChild(_anim);
        makeAnim();
    }

    public function stopAnim():void{
        removeChild(_anim);
        _animTimer.removeEventListener(TimerEvent.TIMER, rotateMe);
        _animTimer.stop();
    }

    private function makeAnim():void {
        renderAnime();
        _animTimer = new Timer(70);
        _animTimer.addEventListener(TimerEvent.TIMER, rotateMe);
        _animTimer.start();
    }

    private function rotateMe(evt:TimerEvent):void {
        _rotate = _rotate + 30;
        if(_rotate == 360)_rotate = 0;
        renderAnime(_rotate);
    }

    private function renderAnime(startAng:Number = 0):void {
        clearAnim();
        var theStar:Sprite = new Sprite()
        for(var i:uint = 0; i <= 12; i++){
            var theShape:Sprite = getShape();
                theShape.rotation = (i * 30) + startAng;
                theShape.alpha = 0 + (1/12 * i);
            theStar.addChild(theShape);
        }
        _anim.addChild(theStar);
    }

    private function clearAnim():void {
        if( _anim.numChildren == 0 ) return;
        _anim.removeChildAt(0);
    }

    private function getShape():Sprite {
        var shape:Sprite = new Sprite();
        shape.graphics.beginFill(_animColor, 1);
        shape.graphics.moveTo(-1, -12);
        shape.graphics.lineTo(2, -12);
        shape.graphics.lineTo(1, -5);
        shape.graphics.lineTo(0, -5);
        shape.graphics.lineTo(-1, -12);
        shape.graphics.endFill();
        return shape;
    }
}