/**
 * Copyright Horiuchi_H ( http://wonderfl.net/user/Horiuchi_H )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3iuE
 */

package 
{
	import caurina.transitions.Tweener;
	import flash.display.*;
	import flash.events.*;
	import flash.text.*;
	
	[SWF(width=465, height=465, frameRate=30, backgroundColor="#FFFFFF")]
	
	/**
	 * Tweenerで遊んでみました。
	 *  画面をWクリックすると、ランダムに配置されたオブジェクトがアニメーションします。
	 */
	public class Bounds extends Sprite 
	{
		private static const SIZE:/*int*/Array = [26, 24];
		private static const BASE_HEIGHT:int = 30;

		private var images:Array = new Array();
		
		public function Bounds() {
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);

			var label:TextField = new TextField();
			label.text = "Double Click Me!";
			label.x = 200;
			label.y = 200;
			label.mouseEnabled = false;
			addChild(label);
			
			var g:Graphics = this.graphics;
			g.lineStyle(1, 0x999999);
			g.moveTo(0, stage.stageHeight - BASE_HEIGHT);
			g.lineTo(stage.stageWidth, stage.stageHeight - BASE_HEIGHT);
			
			stage.addEventListener(MouseEvent.DOUBLE_CLICK, function(event:MouseEvent):void {
				start();
			});
			stage.doubleClickEnabled = true;
		}
		
		public function start():void {
			var image:Sprite;
			while (images.length > 0) {
				image = images.pop();
				Tweener.removeTweens(image);
				removeChild(image);
			}
			var count:int = random(50) + 20;
			var params:Object = { y:stage.stageHeight - SIZE[1] - BASE_HEIGHT, time:1, delay:0.5, transition:"easeOutElastic" };
			for (var index:int = 0; index < count; index++) {
				image = createImage(random(0xFFFFFF));
				image.x = random(stage.stageWidth - SIZE[0]);
				image.y = random(stage.stageHeight - SIZE[1] - BASE_HEIGHT);
				images.push(image);
				addChild(image);
				Tweener.addTween(image, {base:params});
			}
		}
		private function createImage(color:uint):Sprite {
			var image:Sprite = new Sprite();
			var g:Graphics = image.graphics;
			g.beginFill(color);
			g.drawRoundRect(0, 0, SIZE[0], SIZE[1], SIZE[0] - 4, SIZE[1] - 4);
			g.endFill();
			return image;
		}
		
		private function random(max:int):int {
			return Math.floor(Math.random() * max);
		}
	}
}
