/**
 * Copyright grgrdvrt ( http://wonderfl.net/user/grgrdvrt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3ij3
 */

// forked from nicoptere's shortest angle on circle
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    /**
     * @author Nicolas Barradeau
     */
    public class Rota extends Sprite 
    {
        private var c:Point;
        private var radius:Number = 150;
        private var p:Point;
        private var angle:Number = 0;
        private var destAngle:Number = 0;
        
        public function Rota() 
        {
            c = new Point( 250, 250 );
            p = new Point( 250, 250 );
            
            stage.addEventListener( MouseEvent.MOUSE_DOWN, onMouseDown );
            addEventListener( Event.ENTER_FRAME, oef );
            
        }
        
        private function onMouseDown(e:MouseEvent):void 
        {
            
            var mouse:Point = new Point( mouseX, mouseY );
            
            var angles:Vector.<Number> = shortestAngle( c, p, mouse );
            angle = angles[0];
            destAngle = angles[1];
            
        }
        
        /**
         * returns the shortest angle between a center and 2 points
         * @param    center first point
         * @param    p0 first point
         * @param    p1 second point
         * @return a vector Number with the start and end angles
         */
        static public function shortestAngle( center:Point, p0:Point, p1:Point ):Vector.<Number>
        {
            var angle:Number = Math.atan2( p0.y - center.y, p0.x - center.x );
            var destAngle:Number = Math.atan2( p1.y - center.y, p1.x - center.x );
            if ( Math.abs( destAngle - angle ) > Math.PI )
            {
                
                /*if ( destAngle > angle ) angle += Math.PI * 2;
                else destAngle += Math.PI * 2;*/
            }
            return Vector.<Number>([angle, destAngle]);
        }
        
        private function oef(e:Event):void 
        {
            graphics.clear();
            graphics.lineStyle( 3, 0xFFCC00 );
            graphics.drawCircle( c.x, c.y, radius );
            
            angle += ( destAngle - angle ) *.1
            
            p.x = c.x + Math.cos( angle ) * radius;
            p.y = c.y + Math.sin( angle ) * radius;
            
            
            graphics.lineStyle( 3, 0xAACC00 );
            graphics.moveTo( c.x, c.y );
            graphics.lineTo( p.x, p.y );
            
            graphics.drawCircle(     c.x + Math.cos( angle ) * radius,
                                    c.y + Math.sin( angle ) * radius, 5 );
        }    
    }
}