/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3iWy
 */

package {
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            deb = new TextField();
            deb.width = 320; deb.height = 240;
            deb.mouseEnabled = false;
            addChild(deb);
            
            stage.addEventListener(MouseEvent.CLICK, onClick);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor

        public function onClick(e:MouseEvent):void { cx = stage.mouseX; cy = stage.mouseY; }
        
        public var deb:TextField;
      
        public var cx:Number = 0;
        public var cy:Number = 0;
      
      
       public function onEnter(e:Event):void
       {
           graphics.clear();
           graphics.lineStyle(2, 0);
           
           var mx:Number; var my:Number;
           var kx:Number; var ky:Number;
           var ax:Number; var ay:Number; var az:Number;
           var bx:Number; var by:Number; var bz:Number;
           
           mx = stage.mouseX; my = stage.mouseY;
           kx = (mx / 465)*6.28; ky = (my/465)*6.28;
           
           graphics.drawCircle(mx, my, 8);
           graphics.drawCircle(cx, cy, 8);
           
           
           deb.text = "";
           deb.appendText("\n"+kx);
           deb.appendText("\n"+ky);
           
           var lat:Number; var lon:Number;
           lat = ky;
           lon = kx;
           
           ax = Math.sin(lon) * Math.cos(lat);
           ay = Math.sin(lat);
           az = Math.cos(lon) * Math.cos(lat);
          
           deb.appendText("\n"+ax);
           deb.appendText("\n"+ay);
           deb.appendText("\n"+az);
                        
           
           var r:Number;
           r = 32;
           graphics.drawCircle(230,230,r);
           graphics.drawCircle(230+ax*r,230+ay*r, 4);
           graphics.drawCircle(330,230,r);           
           graphics.drawCircle(330+ax*r,230+az*r, 4);
           
           
           lat = 0;
           lon = 0;
           lon = (cx / 465)*6.28;
           lat = (cy/465)*6.28;
           
           bx = Math.sin(lon) * Math.cos(lat);
           by = Math.sin(lat);
           bz = Math.cos(lon) * Math.cos(lat);
           
           
           graphics.drawCircle(230+bx*r,230+by*r, 2);
           graphics.drawCircle(330+bx*r,230+bz*r, 2);
           
           var d:Number;
           d = getMag(ax-bx,ay-by,az-bz);
           d = int(d*r); 
           deb.appendText("\n"+d);
           
           
           
       }//onenter
       
       public function getMag(ax:Number, ay:Number, az:Number):Number
       { return Math.sqrt(ax*ax+ay*ay+az*az); }
       
        
        
    }//classend
}