/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3iVc
 */

// forked from _wonder's インバースキネマティクス基礎
// forked from _wonder's フォワードキネマティクス基礎
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point
    
    public class SingleSegment extends Sprite {
    		private var ball:Ball;
    		private var gravity:Number = 0.5;
    		private var bounce:Number = -0.9;
    		private var segments:Array;
    		private var numSegments:uint = 5;
    		    		
        public function SingleSegment() {
            init();
        }
        
        private function init():void {
        		ball = new Ball();
        		ball.vx = 10;
        		addChild( ball );
        		
        		segments = new Array();
        		for( var i:uint = 0; i < numSegments; i++ ){
        			var segment:Segment = new Segment( 30, 10 );
        			addChild( segment );
        			segments.push( segment );
        		}
        		
        		segment.x = stage.stageWidth / 2;
        		segment.y = stage.stageHeight / 2;
        		
        		addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
        		moveBall();
        		
        		var target:Point = reach( segments[0], ball.x, ball.y );
        		for( var i:uint = 1; i < numSegments; i++ ){
        			var segment:Segment = segments[i];
        			target = reach( segments[i], target.x, target.y );
        		}
        		for( i = numSegments - 1; i > 0; i-- ){
        			var segmentA:Segment = segments[i];
        			var segmentB:Segment = segments[i-1];
        			position( segmentB, segmentA );
        		}
        		
        		checkHit();
        }
        
        private function reach(segment:Segment, xpos:Number, ypos:Number):Point {
        		var dx:Number = xpos - segment.x;
        		var dy:Number = ypos - segment.y;
        		var angle:Number = Math.atan2( dy, dx );
        		segment.rotation = angle * 180 / Math.PI;
        		
        		var w:Number = segment.getPin().x - segment.x;
        		var h:Number = segment.getPin().y - segment.y;
        		var tx:Number = xpos - w;
        		var ty:Number = ypos - h;
        		return new Point( tx, ty );
        }
        
        private function position(segmentA:Segment, segmentB:Segment):void {
        		segmentA.x = segmentB.getPin().x;
        		segmentA.y = segmentB.getPin().y;
        }
        
        private function moveBall():void {
        		ball.vy += gravity;
        		ball.x += ball.vx;
        		ball.y += ball.vy;
        		
        		if( ball.x + ball.radius > stage.stageWidth ){
        			ball.x = stage.stageWidth - ball.radius;
        			ball.vx *= bounce;
        		} else if ( ball.x - ball.radius < 0 ) {
        			ball.x = ball.radius;
        			ball.vx *= bounce;
        		}
        		if( ball.y + ball.radius > stage.stageHeight ){
        			ball.y = stage.stageHeight - ball.radius;
        			ball.vy *= bounce;
        		} else if ( ball.y - ball.radius < 0 ){
        			ball.y = ball.radius;
        			ball.vy *= bounce;
        		}
        }
        
        private function checkHit():void {
        		var segment:Segment = segments[0];
        		var dx:Number = segment.getPin().x - ball.x;
        		var dy:Number = segment.getPin().y - ball.y;
        		var dist:Number = Math.sqrt( dx*dx + dy*dy );
        		if( dist < ball.radius ){
        			ball.vx += Math.random() * 2 - 1;
        			ball.vy -= 1;
        		}
        }
    }
}

import flash.display.Sprite;
import flash.geom.Point;

class Segment extends Sprite {
	private var color:uint;
	private var segmentWidth:Number;
	private var segmentHeight:Number;
	
	public var vx:Number = 0;
	public var vy:Number = 0;
	
	public function Segment(segmentWidth:Number,segmentHeight:Number,color:uint=0xffffff){
		this.segmentWidth = segmentWidth;
		this.segmentHeight = segmentHeight;
		this.color = color;
		init();
	}
	
	public function init():void {
		//セグメントの描画
		graphics.lineStyle( 0 );
		graphics.beginFill( color );
		graphics.drawRoundRect( -segmentHeight / 2, -segmentHeight / 2, segmentWidth+segmentHeight, segmentHeight, segmentHeight, segmentHeight );
		graphics.endFill();
		
		//ピン
		graphics.drawCircle( 0, 0, 2 );
		graphics.drawCircle( segmentWidth, 0, 2 );
	}
	
	public function getPin():Point {
		var angle:Number = rotation * Math.PI / 180;
		var xPos:Number = x + Math.cos( angle ) * segmentWidth;
		var yPos:Number = y + Math.sin( angle ) * segmentWidth;
		return new Point( xPos, yPos );
	}
}

import flash.display.Sprite;

class Ball extends Sprite {
	public var radius:Number;
	public var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
	
	public function Ball(radius:Number=40, color:uint=0Xff0000){
		this.radius = radius;
		this.color = color;
		init();
	}
	
	public function init():void {
		graphics.beginFill(color);
		graphics.drawCircle(0, 0, radius);
		graphics.endFill();
	}
}