/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3i8C
 */

// forked from omari's forked from: Line class for easy drawing, vol.1
// forked from Kay's Line class for easy drawing, vol.1
/*
 * Line.start(x,y,radian)
 * Line.straight(len[,toAngle])
 * Line.curve(radius,angle[,toAngle])
 * Line.draw([lineStyle value])
 */
package {
    import com.bit101.components.HSlider;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    public class ProgressiveLinesSlider extends Sprite {
        private var line:Line;
        private var count:int;
        private var free:Line;
        private var spiral:Line;
        private var spiralSteps:Number;
        public function ProgressiveLinesSlider() {
            spiralSteps = 60;
            oldInit();
            var ggg:Graphics = (addChild(new Sprite) as Sprite).graphics;
            line = new Line(ggg);
            ggg.lineStyle(10);
            line.start(10, 100);
            for (var i:int = 0; i < 20; i++) 
            {
                line.straight(10);
            }
            addEventListener(Event.ENTER_FRAME, loop2);
            var spiralSlider:HSlider = new HSlider(this, 0, 0, onSprial);
            spiralSlider.maximum = spiral.commandsAmount;
            spiralSlider.setSize(100, spiralSlider.height);
            trace( "spiral.commandsAmount : " + spiral.commandsAmount );
            spiralSlider.maximum = spiral.commandsAmount;
            
        }
        
        private function onSprial(e:Event):void 
        {
            var hUISlider:HSlider = e.target as HSlider;
            var i:int = int(hUISlider.value);
            trace( "i : " + i );
            spiral.setpByStepClearing(i);
        }
        
        private function loop(e:Event):void 
        {
            line.setpByStep(count);
            free.setpByStep(count);
            //spiral.setpByStep(count);
            count++;
            //line.straight(10);
            //line.draw(10);
            if (count >= spiral.commandsAmount)
            {
                removeEventListener(Event.ENTER_FRAME, loop);
                count=0
                //addEventListener(Event.ENTER_FRAME, loop2);
            }
            
        }
        
        private function loop2(e:Event):void 
        {
            spiral.setpByStepClearing(count);
            count++;
            if (count>spiral.commandsAmount) 
            {
                removeEventListener(Event.ENTER_FRAME, loop2);
            }
        }
            
        private function oldInit():void 
        {
            var i:int;
            // Circle
            var circle:Line = new Line(graphics);
            circle.start(300,2);
            circle.corner(200,360);
            graphics.beginFill(0xff0000);
            circle.draw(1);
            graphics.endFill();
            
            // Free
            var ggg:Graphics = (addChild(new Sprite) as Sprite).graphics;
            free = new Line(ggg);
            free.start(30,90);
            free.straight(180);
            free.corner(20,125);
            free.straight(10);
            free.corner(35,55);
            free.straight(80);
            free.corner(20,-180,180);
            free.straight(70,180);    // ????
            free.corner(20,180);
            free.straight(70);
            free.corner(60,90);
            free.straight(90);
            free.corner(30,90);
            free.straight(340);
            free.corner(25,270);
            free.straight(50);
            //free.draw(15,0x999999,1,true,'normal','none');
            free.setStyle(15,0x999999,1,true,'normal','none');
            
            // ExpandRect
            var expandRect:Line = new Line(graphics);
            expandRect.start(300,250,-10);
            for (i = 0; i < 4; i++) {
                expandRect.corner(300,20);
                expandRect.corner(40,70);
            }
            expandRect.draw(15,0xff6600);
            
            // Spiral
            var spiralGraphics:Graphics = (addChild(new Sprite) as Sprite).graphics;
            spiral = new Line(spiralGraphics);
            spiral.start(300,200,180);
            for (i = 0; i < spiralSteps; i++) 
            {
                spiral.corner(2+2*i,120);
            }
            spiral.straight(250);
            spiral.setStyle(3,0x006600);
            //spiral.draw(3,0x006600);
        
            // Spark
            var spark:Line = new Line(graphics);
            spark.start(100,313);
            for (i = 0; i < 24; i++) 
            {
                spark.straight(100,165);
            }
            graphics.beginFill(0x999900,0.75);
            //spark.draw(NaN);
            graphics.endFill();
        
        }
    }
}
//package jp.seeda.graphics{
    import flash.display.Graphics;
    import flash.geom.Point;
    import flash.geom.Matrix;
    /*public*/ class Line {

        protected var target:Graphics;
        private var nX:Number;
        private var nY:Number;
        private var nAngle:Number;
        private var nRadian:Number;
        private var points:Vector.<Number>=new Vector.<Number>  ;
        private var commands:Vector.<int>=new Vector.<int>  ;
        private var commandsPoints:Array=[];

        public function Line(gTarget:Graphics):void {
            target = gTarget;
        }

        public function draw(thickness:Number=0,
                             color:uint=0,alpha:Number=1,
                             pixelHinting:Boolean=false,
                             scaleMode:String = "normal",
                             caps:String=null,
                             joints:String=null,
                             miterLimit:Number=3):void {
            target.lineStyle(thickness, color, alpha, pixelHinting, scaleMode, caps, joints, miterLimit);
            target.drawPath(commands, points);
        }
        public function setStyle(thickness:Number=0,
                             color:uint=0,alpha:Number=1,
                             pixelHinting:Boolean=false,
                             scaleMode:String = "normal",
                             caps:String=null,
                             joints:String=null,
                             miterLimit:Number=3):void {
            target.lineStyle(thickness, color, alpha, pixelHinting, scaleMode, caps, joints, miterLimit);
        }
        
        public function setpByStep(nth:uint):void 
        {
            trace( "Line.setpByStep > nth : " + nth );
            if (nth>=commandsPoints.length) 
            {
                return
            }
            var commandPoints:Array = commandsPoints[nth];
            var command:Vector.<int> = Vector.<int>([commandPoints[0]]);
            var this_points:Vector.<Number>= Vector.<Number>(commandPoints[1]);
            target.drawPath(command, this_points);
        }
        
        public function setpByStepClearing(nth:uint):void 
        {
            trace( "Line.setpByStep > nth : " + nth );
            //if (nth>=commandsPoints.length) 
            //{
                //trace( "return : "  );
                //return
            //}
            var commandsB:Vector.<int> = new Vector.<int>([]);
            var pointsB:Vector.<Number> = new Vector.<Number>([]);
            target.clear();
            target.lineStyle(0);
            for (var i:int = 0; i < nth; i++) 
            {
                
                var commandPoints:Array = commandsPoints[i];
                var command:int = commandPoints[0];
                commandsB[commandsB.length] = command;
                var this_points:Array = commandPoints[1];
                var cpl:uint = this_points.length;
                for (var j:int = 0; j < cpl; j++) 
                {
                    pointsB[pointsB.length] = this_points[j];
                }
            }
            target.drawPath(commandsB, pointsB);
        }
        
        public function get commandsAmount():uint { return commandsPoints.length; }

        public function start(x:Number=0, y:Number=0, angle:Number=0):void {
            nX=x;
            nY=y;
            nAngle = angle;
            nRadian=angle2radian(nAngle);
            points.push(nX,nY);
            commands.push(1);
            commandsPoints[commandsPoints.length] = [1,[nX,nY]];
        }

        public function straight(length:Number=0, angle:Number=NaN):void {
            if (!isNaN(angle)) nAngle += angle;
            nRadian = angle2radian(nAngle);
            nX +=length*Math.cos(nRadian);
            nY +=length*Math.sin(nRadian);
            points.push(nX,nY);
            commands.push(2);
            commandsPoints[commandsPoints.length] = [2, [nX, nY]];
        }
        
        /*
         * 現在角（nRadian,nAngle）から半径（radius）／角度（angle）で円弧を描くPointを取得
         */
        public function corner(radius:Number=100, toAngle:Number=45, fromAngle:Number=NaN):void {
            if (!isNaN(fromAngle)) nAngle += fromAngle;
            var nFromRadian:Number = angle2radian(nAngle);

            // 相対到達角
            var nToRadian:Number = angle2radian(toAngle);
            nToRadian = getRangeValue(nToRadian, Math.PI*2);
            
            var cp:Array = getArcPoints(radius, nToRadian);
            var matrix:Matrix = new Matrix();
            matrix.translate(-radius,0);
            matrix.rotate(nFromRadian-Math.PI/2);
            matrix.translate(nX, nY);
            var max:int = cp.length-1;
            for (var i:int = 1; i < max; i+=2) {
                var control:Point = matrix.transformPoint(cp[i]);
                var anchor:Point  = matrix.transformPoint(cp[i+1]);
                points.push(control.x, control.y, anchor.x, anchor.y);
                nX = anchor.x;
                nY = anchor.y;
                commands.push(3);
                commandsPoints[commandsPoints.length] = [3, [control.x, control.y, anchor.x, anchor.y]];
            }
            nAngle += toAngle;
            nRadian = angle2radian(nAngle);
        }

        // コントロール／アンカーポイントをおプロジェクトとして取得
        // Point(0,0), radian:0から取得しておき後にmatrixで移動
        public static function getArcPoints(nRadius:Number, toRadian:Number):Array {
            var points:Array = new Array();
            var vals:Object = getArcValues(nRadius, toRadian);
            for (var i:int = 0; i <= vals.divideNum; i++) {
                // Anchor
                points.push(new Point(nRadius*Math.cos(vals.dividedRadian*i),
                                      nRadius*Math.sin(vals.dividedRadian*i)));
                // Control
                points.push(new Point(vals.distance*Math.cos(vals.dividedRadian*(i+0.5)),
                                      vals.distance*Math.sin(vals.dividedRadian*(i+0.5))));
            }
            return points;
        }
        
        /*
         * 円弧を描くのに必要な材料を配列として返す
         * @return divideNum: 分割数
         * @return dividedRadian: 分割された角度
         * @return distance: 中心点からコントロールポイントまでの距離
         */
        public static function getArcValues(nRadius:Number, nRadian:Number):Object {
            // 分割数を得る（45°未満：1）
            var divideNum:int = 1;
            while (Math.abs(nRadian)/divideNum > Math.PI/4) divideNum++;
            // 分割された角度
            var dividedRadian:Number = nRadian/divideNum;
            // コントロールポイントまでの距離を得る
            var distance:Number = getControlRadius(nRadius,Math.abs(dividedRadian));
            return {divideNum:divideNum, dividedRadian:dividedRadian, distance:distance};
        }
        
        // 角度からコントロールポイントの半径を取得
        public static function getControlRadius(nRadius:Number, nRadian:Number):Number {
            var rHalf:Number = nRadian/2;
            var nHeight:Number = nRadius * Math.atan(rHalf);
            var radius:Number = Math.sqrt(Math.pow(nHeight,2)+Math.pow(nRadius,2));
            return radius;
        }

        // 数値を+-limitの範囲に収束
        public function getRangeValue(num:Number, limit:Number):Number {
            while(num >  limit) num -= limit*2;
            while(num < -limit) num += limit*2;
            return num;
        }
        
        // angleをradianに変換
        private function angle2radian(angle:Number=0):Number {
            var radian:Number= angle * (Math.PI / 180);
            return radian;
        }
    }
//}