/**
 * Copyright ponica ( http://wonderfl.net/user/ponica )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3i0u
 */

// forked from Thy's Graph 1.6
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.GlowFilter;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    /**
     * ...
     * @author Thi
     * Graph v. 1.6 / 2.0
     * 
     * 
     * some expresison samples:
     * 0 + 1 - 2 * 3 / 4 ^ -5 +6143
     * -1 ^ round (x) - sin (x) + asin(x²) + (.08x² + .1x - 1)
     * 
     * pi = PI = Math.PI
     * e = E = Math.E
     * sin (), cos (), tan (), acos (), asin (), atan ()
     * random = Math.random ()
     * round (), floor (), ceil ()
     * log (), exp ()
     * sqrt ()
     * abs ()
     * 
     * syntax observations:
     * 1 + 1 * 1 = 1 + (1 * 1)
     * 1 * 1 ^ 1 = 1 * (1 ^ 1)
     * 1 + 1 ^ 1 = 1 + (1 ^ 1)
     * 1² = 1 ^ 1
     * 1³ = 1 ^ 3
     * 1x = (1)x = 1(x) = (1)(x) = x(1) = (x)1 = 1 * x
     * sen (x) = seno (x) = sin (x)
     * cosseno (x) = cos (x)
     * tangente (x) = tangent (x) = tgt (x) = tg (x) = tan (x)
     * absoluto (x) = modulo (x) = abs (x)
     * aleatorio = random
     * raiz (x) = sqrt (x)
     * 
     * The calculator works using 3 main functions:
     * 1° - transform the string to an array, ready to be readen
     * 2° - organizes the array to Reverse Polish Notation (RPN)
     * 3° - return the resulting value
     * We do this for each x point for each function for each graph!
     * 
     * TODO:
     * an menu, with 'new function', 'new var' and 'new graph' (diferent color) functions
     * also with 'zoom' and 'position' options
     * 
     * this code's version's dirty ..
     * 
     */
    public class Main extends Sprite 
    {
        
        
        
        public var // libraly
        // text libraly, like 'format, glow'
        txt_libraly:Array = [new TextFormat("Tahoma", 16), new GlowFilter()], 
        // default libraly, like 'x y sin pi log'
        lib:Array = ["x", 1, "y", 2];
        
        public var // proprieties
        w:Number = 465, h:Number = 465;
        
        private var calc:Calculator = new Calculator();
        
        private var
        back_lines_data:BitmapData = new BitmapData(w, h, false, 0xFFFFFF),
        back_lines:Bitmap = new Bitmap(back_lines_data, "auto", true),
        back_menu:Shape = new Shape();
        
        public var // setup
        min:Point = new Point(-10,-10), // the initial x & y value @ graph
        max:Point = new Point(10, 10), // the final x & y value @ graph
        step:Point = new Point((max.x - min.x) / w, (max.y - min.y) / h),
        step_back_constrain:Boolean = true,
        step_back:Point = new Point(1, 1);
        public var setup:Array = 
        [w,h,min, max, step]
        
        private var // functions
        function0:Function_,
        func_delay:int = 10,
        func_title_old:String = "",
        func_input_old:String = "",
        //
        functions:Vector.<Function_> = new Vector.<Function_>();
        
        private var 
        graphs:Vector.<Graph> = new Vector.<Graph>(),
        graph_delay:int = 150;
        
        
        private var 
        scene:int = 0, scene_delay:int = 60,
        scrool_old:Array = [new Point()],
        scrool_vel:Point = new Point(),
        scrool:Boolean,
        scrool_delay:int = 0;
        
        
        // glow function fot texts
        private function 
        glowIn(e:MouseEvent = null):void
        {
            e.target.filters = [lib[1]];
        };
        private function
        glowOut(e:MouseEvent = null):void
        {
            e.target.filters = [];
        };
        
        public function Main():void 
        {
            functions[0] = new Function_(txt_libraly);
            function0 = functions[0];
            graphs[0] = new Graph(lib, setup);
            
            function0.input.text = "sin (x)"
            
            drawBackgrounds();
            this.addChild(back_lines);
            this.addChild(back_menu);
            this.addChild(graphs[0]);
            this.addChild(function0);
            
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
            
            
            this.addEventListener(Event.ENTER_FRAME, ef);
        }
        
        private function drawBackgrounds():void
        {
            var i:int = -1;
            var s:Shape = new Shape();
            var g:Graphics = s.graphics;
            // lines
            var n:Number = Math.floor(((min.x - 1) / step_back.x)) * step_back.x;
            var n2:Number = w / (max.x - min.x)
            // vertical line
            while (n <= max.x)
            {
                g.lineStyle(1, 0, .2, true);
                n += step_back.x;
                if(n == 0) g.lineStyle(2, 0, 1, true);
                g.moveTo((n - min.x) * n2, 0);
                g.lineTo((n - min.x) * n2, h); // vertical
            }
            n = Math.ceil(min.y / step_back.y) * step_back.y;
            n2 = h / (max.y - min.y)
            while (n < max.y)
            {
                g.lineStyle(1, 0, .2, true);
                n += step_back.y;
                if(n == 0) g.lineStyle(2, 0, 1, true);
                g.moveTo(0,(n - min.y) * n2);
                g.lineTo(w,(n - min.y) * n2); // horizontal
            }
            back_lines_data.draw(s);
            g.clear(); s = null;
            
            g = back_menu.graphics;
            g.beginFill(0, .8);
            g.drawRoundRect(0, 0, 465, 30, 0, 0);
            g.endFill();
            g = null;
        }
        
        private function updateLineBackground():void
        {
            var i:int = -1;
            var s:Shape = new Shape();
            var g:Graphics = s.graphics;
            // lines
            var n:Number = Math.floor(((min.x - 1) / step_back.x)) * step_back.x;
            var n2:Number = w / (max.x - min.x)
            // vertical line
            while (n <= max.x)
            {
                g.lineStyle(1, 0, .2, true);
                n += step_back.x;
                if(n == 0) g.lineStyle(2, 0, 1, true);
                g.moveTo((n - min.x) * n2, 0);
                g.lineTo((n - min.x) * n2, h); // vertical
            }
            n = Math.ceil(min.y / step_back.y) * step_back.y;
            n2 = h / (max.y - min.y)
            while (n < max.y)
            {
                g.lineStyle(1, 0, .2, true);
                n += step_back.y;
                if(n == 0) g.lineStyle(2, 0, 1, true);
                g.moveTo(0,(n - min.y) * n2);
                g.lineTo(w,(n - min.y) * n2); // horizontal
            }
            back_lines_data.fillRect(back_lines_data.rect, 0xFFFFFF);
            back_lines_data.draw(s);
            g.clear(); s = null;
        }
        
        private function ef(e:Event = null):void
        {
            var i:int = -1;
            
            if (scene == 0)
            {
                // scene transit
                if (mouseY < 30)
                {
                    if (-- scene_delay == 0)
                    {
                        // TRANSIT THE SCENE
                        return;
                    } else
                    {
                        scene_delay = 60;
                    }
                }
                
                // update function expression
                if (func_title_old != function0.title.text || func_input_old != function0.input.text)
                {
                    func_title_old = function0.title.text;
                    func_input_old = function0.input.text;
                    func_delay = 10;
                }
                if (--func_delay == 0)
                {
                    // FUNCTION HAS BEEN UPDATED
                    // so we update theyr RPN
                    var func:Function_; // temp function
                    while (++i < functions.length)
                    {
                        func = functions[i];
                        func.rpn = calc.translate(func.input.text);
                        func.preventError = calc.preventError;
                        trace("______")
                        trace(func.rpn)
                        func.rpn = calc.RPN(func.rpn, func.preventError);
                        trace(func.rpn);
                        trace("______")
                        
                    }
                    
                    // activate graphics draw, and clear graphs 'j'
                    graph_delay = 150;
                    clearGraphs()
                    
                    
                    // now we start to draw graphics
                    drawGraphs();
                    
                }
                
                
                lineGraphs();
                
                
                
                moveLineBackroung()
                
            }
            
        }
        
        private function clearGraphs():void
        {
            var i:int;
            
            i = -1;
            while (++i < graphs.length)
            {
                graphs[i].clear();
                graphs[i].cacheAsBitmap = false;
            }
        }
        
        private function drawGraphs():void
        {
            var 
            X:Number = min.x, graph:Graph, i:int, a:int = -1, func:Function_;
            trace(X)
            while ((X += step.x) < max.x) // 465 loops
            {
                updateLibraly("x", X);
                i = -1;
                while (++i < functions.length) // function loops
                {
                    func = functions[i];
                    updateLibraly(func.title.text, calc.calculate(func.rpn, lib) );
                }
                i = -1;
                while (++i < graphs.length) // graphics loops
                {
                    graph = graphs[i];
                    graph.update();
                }
            }
        }
        
        private function lineGraphs(delay:Number = .3):void
        {
            var i:int;
            if (-- graph_delay > 0)
            {
                i = -1;
                while (++i < graphs.length)
                {
                    graphs[i].clear();
                    graphs[i].line(delay);
                }
                if (graph_delay == 1)
                {
                    i = -1;
                    while (++i < graphs.length)
                    {
                        graphs[i].cacheAsBitmap = true;
                    }
                }
            }
        }
        
        private function updateLibraly(item:String, value:Number):void
        {
            var i:int = -1;
            while (++i < lib.length)
            {
                if (item == lib[i])
                {
                    lib[++i] = value;
                    return;
                }
                ++i;
            }
        }
        
        private function mouseDown(e:MouseEvent):void
        {
            if(scene == 0 && mouseY > 30)
            {
                scrool_old[0].x = mouseX
                scrool_old[0].y = mouseY
                scrool = true;
            }
            
        }
        
        private function mouseUp(e:MouseEvent):void
        {
            scrool = false;
            scrool_delay = 10;
        }
        
        private function mouseMove(e:Event):void
        {
            
        }
        
        private function moveLineBackroung():void
        {
            var i:int = -1;
            if (scrool)
            {
                
                scrool_vel.x = (scrool_old[0].x - mouseX) * .05;
                scrool_vel.y = (scrool_old[0].y - mouseY) * .05;
                scrool_old[0].x  = mouseX
                scrool_old[0].y  = mouseY                
            
                min.x += scrool_vel.x;
                max.x += scrool_vel.x;
                min.y += scrool_vel.y;
                max.y += scrool_vel.y;
                step.x = (max.x - min.x) / w;
                step.y =  (max.y - min.y) / h;
                setup[2] = min;
                setup[3] = max;
                setup[4] = step;
                
                //
                
                updateLineBackground()
                i = -1;
                while (++i < graphs.length)
                {
                    graphs[i].updateSetup(setup);
                }
                clearGraphs();
                
                graph_delay = 10;
                drawGraphs();
                lineGraphs(1);
                
            } else if (-- scrool_delay > 0)
            {
                min.x += scrool_vel.x *= .8;
                max.x += scrool_vel.x;
                min.y += scrool_vel.y *= .8;
                max.y += scrool_vel.y;
                step.x = (max.x - min.x) / w;
                step.y =  (max.y - min.y) / h;
                setup[2] = min;
                setup[3] = max;
                setup[4] = step;
                
                //
                
                updateLineBackground()
                i = -1;
                while (++i < graphs.length)
                {
                    graphs[i].updateSetup(setup);
                }
                clearGraphs();
                
                graph_delay = 10;
                drawGraphs();
                lineGraphs(1);
            }
        }
        
    }    
}

import flash.display.Sprite;
import flash.display.Shape
import flash.text.TextField;
import flash.display.Graphics;
import flash.text.TextFieldAutoSize;
import flash.geom.Point;


class Graph extends Shape
{
    public var
    color:uint = 0xFF0000,
    g:Graphics,
    X:String = "x", Y:String = "y";
    
    private var 
    points:Vector.<Point> = new Vector.<Point>(465, true),
    points2:Vector.<Point> = new Vector.<Point>(465, true),
    j:int;
    
    private var 
    lib:Array, setup:Array;
    
    private var 
    w:Number,
    h:Number,
    min:Point,
    max:Point,
    step:Point;
    
    public function Graph(libraly:Array = null, setup:Array = null):void
    {
        g = this.graphics;
        g.lineStyle(1, color);
        this.lib = libraly;
        this.setup = setup;
        updateSetup(setup);
        j = -1;
        while (++j < 465)
        {
            points[j] = new Point();
            points2[j] = new Point();
        }
    }
    
    public function update():void
    {
        //trace(j);
        ++j;
        points[j].x = search(X);
        points[j].y = search(Y);
    }
    
    public function line(delay:Number = .3):void
    {
        var a:Number = 0, b:Number = 0;
        j = 0;
        //g.moveTo( (points2[0].x += (points[0].x - points2[0].x) * .3) / step.x + w / 2,
        //h*.5 - ((points2[0].y += (points[j].y - points2[j].y) * .3) / step.y));
        g.moveTo( (points2[0].x += (points[0].x - points2[0].x) * delay) / step.x - min.x/step.x,
         -((points2[0].y += (points[j].y - points2[j].y) * delay) / step.y + min.y / step.y));
        while (++j < 465)
        {
            a = points2[j].x += (points[j].x - points2[j].x) * delay
            b = points2[j].y += (points[j].y - points2[j].y) * delay
            if (a == Infinity || b == Infinity) continue;
            //g.lineTo(a / step.x + w/2, h*.5 - (b / step.y));
            g.lineTo(a / step.x - min.x/step.x , -(b / step.y + min.y / step.y));
        }
    }
    
    public function clear():void
    {
        j = -1;
        g.clear();
        g.lineStyle(1, color);
    }
    
    private function search(item:String = null):Number
    {
        var i:int = -1;
        while (++i < lib.length)
        {
            if (item == lib[i])
            {
                if (Number(lib[++i])) 
                {
                    if ((lib[i]) == -Infinity )
                    {
                        trace("a")
                        return Infinity;
                    }
                    return lib[i];
                }
                return 0;
            }
            ++i;
        }
        if (Number (item)) return Number(item);
        return 0;
    }
    
    public function updateSetup(Setup:Array = null):void
    {
        this.setup = Setup;
        w = setup[0],
        h = setup[1],
        min = setup[2],
        max = setup[3],
        step = setup[4];
    }
}

class Button extends Sprite
{
    private var 
    lib:Array;
    public const t:TextField = new TextField();
    
    
    public function Button(label:String = null, lib:Array = null):void
    {
        var g:Graphics = this.graphics;
        this.lib = lib;
        t.defaultTextFormat = lib[0];
        t.selectable = false;
        t.text = label;
        t.autoSize = TextFieldAutoSize.LEFT;
        t.textColor = 0xFF0000;
        g.beginFill(0);
        g.lineStyle(0, 0, 0, true);
        g.drawRoundRect( -2, -2, t.width + 4, t.height + 4, 10, 10);
        g.endFill();
    }
    
    public function update(label:String = null):void
    {
        var g:Graphics = this.graphics;
        t.text = label;
        g.clear();
        g.beginFill(0);
        g.lineStyle(0, 0, 0, true);
        g.drawRoundRect( -2, -2, t.width + 4, t.height + 4, 10, 10);
        g.endFill();
    }
}

class Function_ extends Sprite
{
    public var 
    title:TextField = new TextField(),
    input:TextField = new TextField(),
    symbol:TextField = new TextField(),
    rpn:Array, preventError:Boolean;
    
    private var 
    lib:Array;
    
    public function Function_(lib:Array):void
    {
        this.lib = lib;
        this.addChild(title);
        this.addChild(input);
        this.addChild(symbol);
        
        title.defaultTextFormat = lib[0];
        title.type = "input";
        title.text = "y";
        title.autoSize = TextFieldAutoSize.LEFT;
        title.width = title.width;
        title.autoSize = TextFieldAutoSize.NONE;
        title.textColor = 0xFFFFFF;
        title.multiline = false;
        
        symbol.defaultTextFormat = lib[0];
        symbol.selectable = false;
        symbol.text = "=";
        symbol.autoSize = TextFieldAutoSize.LEFT;
        symbol.width = symbol.width;
        symbol.autoSize = TextFieldAutoSize.NONE;
        symbol.textColor = 0xFFFFFF;
        
        input.defaultTextFormat = lib[0];
        input.type = "input";
        input.text = "x";
        input.autoSize = TextFieldAutoSize.LEFT;
        input.width = input.width;
        input.autoSize = TextFieldAutoSize.NONE;
        input.textColor = 0xFFFFFF;
        title.multiline = false;
        
        if (title.width < 10) title.width = 10;
        if (title.width > 435 - symbol.width) title.width = 435 - symbol.width;
        symbol.x = title.width + 10;
        input.x = symbol.x + symbol.width + 10;
        input.width = 465 - input.x + input.width;
    }
    
    public function update():void
    {
        title.autoSize = TextFieldAutoSize.LEFT;
        title.width = title.width;
        if (title.width < 10) title.width = 10, title.autoSize = TextFieldAutoSize.NONE;
        if (title.width > 435 - symbol.width) 
        {
            title.width = 435 - symbol.width; 
            title.autoSize = TextFieldAutoSize.NONE;
        }
        symbol.x = title.width + 10;
        input.x = symbol.x + symbol.width + 10;
        input.width = 465 - input.x + input.width;
    }
    
    
}


class Calculator
{
    public var 
    lib:Array, preventError:Boolean;
    
    private var 
    char:String, // used by several methods
    e2:Array, e3:Array; // arrays, used by the #2 method
    
    public function translate(expression:String = null):Array
    {
        var 
        // storage
        s:String = expression,
        e:Array = [], num:Array = [], 
        // loops
        i:int = 0, j:int = 0, 
        // Other
        length:int = s.length, last:String = "";
        char = "";
        
        
        preventError = false;
        
        while ( i < length)
        {
            char = s.charAt(i);
            if (Number(char) || char == "0")
            {
                // whos 'is' in the left of the char
                last = e[e.length - 1];
                if (last == ")")
                {
                    e.push("*");
                }
                
                // we build the number, by each character
                j = i;
                while (Number(char) || char == "," || char == "." || char == "0") 
                {
                    num.push(char)
                    ++j
                    char = s.charAt(j)
                }
                if (last == "-")
                {
                    last = e[e.length - 2];
                    if (last == "+" || last == "-" || last == "*" || last == "/" || last == "^" ||
                    last == "(" || last == null)
                    {
                        // 2,*,-,1 -> 2,*,-1
                        e[e.length-1] = String(0-Number(num.join("")));
                    } else
                    {
                        e.push(num.join(""));
                    }
                } else
                {
                    e.push(num.join(""));
                }
                num = [];
                i = j-1;
                j = 0;
                
            } else if (char == "*" || char == "+" || char == "-" || char == "/" || char == "^") 
            {
                // push all operators
                e.push(char);
                
            } else if (char == "." || char == ",")
            {
                // create a decimal, example: .2 -> 0.2
                num.push("0");
                num.push(".");
                //
                j = i;
                if (Number(char) || char == "0")
                {
                    while (Number(char) || char == "0")
                    {
                        num.push(char);
                        ++j;
                        char = s.charAt(j);
                    }
                    e.push(num.join(""));
                    i = j - 1;
                    num = [];
                    j = 0;
                }
                
            } else if (char == "(" || char == "[" || char == "{")
            {
                preventError = true
                // take the last element
                last = e[e.length - 1]
                /*if (last != "+" && last != "-" && last != "*" && last != "/" && last != "^" && 
                last != "undefined" && last != null && last != "sin" && last != "cos" && 
                last != "tan" && last != "log" && last != "e" && last != "pi" && last != "asin" &&
                last != "acos" && last != "atan" && last != "random" && last != "round" && last != "floor" && 
                last != "ceil" && last != "exp" && last != "sqrt" && last != "abs")*/
                
                // if last cahr is different of an operator or 'function that uses ()'
                if (last != "+" && last != "-" && last != "*" && last != "/" && last != "^" && 
                last != "undefined" && last != null && last != "sin" && last != "cos" && 
                last != "tan" && last != "log" && last != "asin" &&    last != "acos" && 
                last != "atan" && last != "round" && last != "floor" && 
                last != "ceil" && last != "exp" && last != "sqrt" && last != "abs")
                
                {
                    // add an multiplication
                    e.push("*")
                }
                e.push("(")
                // 2(x -> 2 * (x
                
            } else if (char == "²")
            {
                // ² -> ^ 2
                e.push("^")
                e.push("2")
                
            } else if (char == "³")
            {
                // ³ -> ^ 3
                e.push("^")
                e.push("3")
                
            } else if (char == ")" || char == "]" || char == "}")
            {
                // )]} -> )))
                e.push(")")
                
            } else if (char != " ")
            {
                last = e[e.length -1]
                if (last != "+" && last != "-" && last != "*" && last != "/" && last != "^" && 
                last != "undefined" && last != null && last != "(")  
                {
                    // add an multiply
                    e.push("*")
                    // y x -> y * x
                }
                j = i
                while (char != "," && char != "." && char != "+" && char != "-" && char != "*" && char != "/" && char != "^" && char != "(" && char != "[" && char != "{" && char != ")" && char != "]" && char != "}" && char != " " && char != null && char != "undefined" && char != "" && char != "²" && char != "³") 
                {
                    num.push(char)
                    ++j;
                    char = s.charAt(j)
                }
                // we just formed an word, char by char.
                
                var temp:String = num.join("")
                if (temp == "sen" || temp == "seno")
                {
                    temp = "sin"
                } else if (temp == "cosseno")
                {
                    temp = "cos"
                } else if (temp == "tangent" || temp == "tangente" || temp == "tgt" || temp == "tg")
                {
                    temp = "tan"
                } else if (temp == "E")
                {
                    temp = "e"
                } else if (temp == "PI")
                {
                    temp = "pi"
                } else if (temp == "absoluto" || temp == "modulo")
                {
                    temp = "abs"
                } else if (temp == "aleatorio")
                {
                    temp = "random"
                } else if (temp == "raiz")
                {
                    temp = "sqrt"
                }
                e.push(temp)
                num = []
                temp = ""
               i = j-1
            }
            ++i
        }
        return e;
    }
    
    public function RPN(elements:Array = null, PreventError:Boolean = false):Array
    {
        e2 = []; // temp elements
        e3 = []; // final (returned) elements
        char = "";
        
        var
        e:Array = elements.concat(), // initial elements
        i:int = 0, j:int = 0,
        length:int = e.length;
        preventError = PreventError;
        
        while (i < length)
        {
            char = e[i];
            if (Number(char) || char == "0")
            {
                e3.push(char)
            } else if (char == "(")
            {
                e2.push(char)
            } else if (char == "+" || char == "-" || char == "*" || char == "/" || char == "^" || 
            char == "sin" || char == "cos" || char == "tan" || char == "acos" || char == "asin" || 
            char == "atan" || char == "round" || char == "floor" || 
            char == "ceil" || char == "log" || char == "exp" || char == "sqrt" || char == "abs"  )
            {
                e2.push(char)
                // call a function that organizes the order
                OperatorLevel() // send the e2 and e3 local vars
            }  else if (char == ")")
            {
                e2.push(char)
                CloseParantesis()
            } else
            {    
                e3.push(char)
            }
            ++i
        }
        
        // now add 'calculation' array (reverse) to the result array
        j = e2.length
        while (j > 0)
        {
            if (e2[j - 1] != "")
            {
                e3.push(e2[j-1])
            }
            --j
        }
        
        return e3;
    }
    
    private function OperatorLevel():void
    {
        var 
        level1:int, level2:int;
        
        if (char == "+" || char == "-") 
        {
            level1 = 1;
        } else if (char == "*" || char == "/") 
        {
            level1 = 2;
        } else if (char == "^")
        {
            level1 = 4;
        } else if (char == "sin" || char == "cos" || char == "tan" || char == "asin" || 
        char == "acos" || char == "atan" || char == "round" || char == "floor" || char == "ceil" ||
        char == "log" || char == "exp" || char == "sqrt" || char == "abs")
        {
            level1 = 8
        }
        if (e2[e2.length - 2] == "+" || e2[e2.length - 2] == "-") 
        {
            level2 = 1;
        } else if (e2[e2.length - 2] == "*" || e2[e2.length - 2] == "/") 
        {
            level2 = 2;
        } else if (e2[e2.length - 2] == "^") 
        {
            level2 = 3;
        } else if (e2[e2.length - 2] == "sin" || e2[e2.length - 2] == "cos" || e2[e2.length - 2] == "tan" ||
        e2[e2.length - 2] == "asin" || e2[e2.length - 2] == "acos" || e2[e2.length - 2] == "atan" ||
        e2[e2.length - 2] == "round" || e2[e2.length - 2] == "floor" || e2[e2.length - 2] == "ceil" ||
        e2[e2.length - 2] == "log" || e2[e2.length - 2] == "exp" || e2[e2.length - 2] == "sqrt" ||
        e2[e2.length - 2] == "abs")
        {
            level2 = 4;
        } else 
        {
            level2 = 0;
        }
        if (level1 <= level2) 
        {
            e3.push(e2[e2.length-2]);
            e2.splice(e2.length - 2, 1);
            // repeats
            OperatorLevel();
        }
    }
    
    private function CloseParantesis():void
    {
        if (e2[e2.length - 2] != "(")
        {
            e3.push(e2[e2.length - 2])
            e2.splice(e2.length - 2, 1)
            if (preventError)
            {
                CloseParantesis();
            }
        } else 
        {
            e2.splice(e2.length-2,2)
        }
    }
    
    public function calculate(elements:Array = null, libraly:Array = null):Number
    {
        var
        e:Array = elements.concat(),
        n0:Boolean, n1:Boolean,
        i:int, j:int, lib:Array = libraly.concat(),
        num:Number;
        char = "";
        
        while (i < e.length)
        {
            char = e[i];
            //{
                
                if (char == "+")
                {
                    e[i] = Number(e[i - 2]) + Number(e[i - 1]);
                    e.splice(i - 2, 2);
                    --i; --i;
                } else if (char == "-")
                {
                    if (Number(e[i - 2]))
                    {
                        e[i] = Number(e[i - 2]) - Number(e[i - 1]);
                        e.splice(i - 2, 2);
                    } else
                    {
                        e[i] = - Number(e[i - 1]);
                        e.splice(i - 1, 1);
                    }
                    --i; --i;
                } else if (char == "*")
                {
                    e[i] = Number(e[i - 2]) * Number(e[i - 1]);
                    e.splice(i - 2, 2);
                    --i; --i;
                } else if (char == "/")
                {
                    e[i] = Number(e[i - 2]) / Number(e[i - 1]);
                    e.splice(i - 2, 2);
                    --i; --i;
                } else if (char == "^")
                {
                    e[i] = Math.pow(Number(e[i - 2]) , Number(e[i - 1]));
                    e.splice(i - 2, 2);
                    --i; --i;
                } else if (!Number(char) && char != "0")
                {
                    if (char == "sin")
                    {
                        e[i] = Math.sin(Number(e[i - 1]));
                        e.splice(i - 1, 1);
                        --i;
                    } else if (char == "cos")
                    {
                        e[i] = Math.cos(Number(e[i - 1]));
                        e.splice(i - 1, 1);
                        --i;
                    } else if (char == "tan")
                    {
                        e[i] = Math.tan(Number(e[i - 1]));
                        e.splice(i - 1, 1);
                        --i;
                    } else if (char == "asin")
                    {
                        num = Number(e[i - 1]);
                        if (num * num <= 1)
                        {
                            e[i] = Math.asin( num );
                        } else
                        {
                            e[i] = 0;
                        }
                        e.splice(i - 1, 1);
                        --i;
                    } else if (char == "acos")
                    {
                        num = Number(e[i - 1]);
                        if (num * num <= 1)
                        {
                            e[i] = Math.acos( num );
                        } else
                        {
                            e[i] = 0;
                        }
                        e.splice(i - 1, 1);
                        --i;
                    } else if (char == "atan")
                    {
                        e[i] = Math.atan(Number(e[i - 1]));
                        e.splice(i - 1, 1);
                        --i;
                    } else if (char == "random")
                    {
                        e[i] = Math.random();
                        --i;
                    } else if (char == "pi")
                    {
                        e[i] = Math.PI;
                        --i;
                    } else if (char == "e")
                    {
                        e[i] = Math.E;
                        --i;
                    } else if (char == "round")
                    {
                        e[i] = Math.round(Number(e[i - 1]));
                        e.splice(i - 1, 1);
                        --i;
                    } else if (char == "floor")
                    {
                        e[i] = Math.floor(Number(e[i - 1]));
                        e.splice(i - 1, 1);
                        --i;
                    } else if (char == "ceil")
                    {
                        e[i] = Math.ceil(Number(e[i - 1]));
                        e.splice(i - 1, 1);
                        --i;
                    } else if (char == "log")
                    {
                        e[i] = Math.log(Number(e[i - 1]));
                        e.splice(i - 1, 1);
                        --i;
                    } else if (char == "exp")
                    {
                        e[i] = Math.exp(Number(e[i - 1]));
                        e.splice(i - 1, 1);
                        --i;
                    } else if (char == "sqrt")
                    {
                        e[i] = Math.sqrt(Number(e[i - 1]));
                        e.splice(i - 1, 1);
                        --i;
                    } else if (char == "abs")
                    {
                        e[i] = Math.abs(Number(e[i - 1]));
                        e.splice(i - 1, 1);
                        --i;
                    } else
                    {
                        // ITS A WORD, we search in the libraly for it
                        //var found:Boolean;
                        j = 0;
                        while (j < lib.length)
                        {
                            if (char == lib[j])
                            {
                                e[i] = lib[++j]
                                --i
                                //found = true;
                                break;
                            }
                            ++j; ++j;
                        }
                        // the index of the value has been found (j)    
                        if (j == 0 && lib[0] != char)
                        {
                            ++i
                        }
                        /*if (!found) 
                        {
                            trace("POHA");
                            return NaN;
                        }*/
                    }
                    
                    
                    
                    
                } 
                
                ++i
                if (e.length == 1)
                {
                    return Number(e[0]);
                }
                
                
                
            /*} else
            {
                
            }*/
            
            
            
            
            
        }
        
        return 0;
        
        
    }
    
}


