/**
 * Copyright mokehehe ( http://wonderfl.net/user/mokehehe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3hhb
 */

// forked from toyoshim's マンデルブロ @ Frocessing
package {
    import frocessing.display.*;
    [SWF(width="465", height="465", frameRate="1")]
    public class FrocessingSample extends F5MovieClip2D {
        private var screen_width:int = 465;
        private var screen_height:int = 465;
        private var offset_x:Number = 0.0;
        private var offset_y:Number = 0.0;
        private var zoom:Number = 1.0;
        private var count_array:Array;
        private var real_array:Array;
        private var image_array:Array;
        private var frame:int;
        private var first_rendered:Boolean;
        
        public function setup():void {
            size(screen_width, screen_height);
//            background(0);
            colorMode(HSB, 255);
            count_array = new Array(screen_width * screen_height);
            real_array = new Array(screen_width * screen_height);
            image_array = new Array(screen_width * screen_height);
            clear_count();
//            noLoop();
//            redraw();
        }

        private function clear_count():void {
            for (var y:int = 0; y < screen_height; ++y) {
                for (var x:int = 0; x < screen_width; ++x) {
                    var i:int = x + y * screen_width;
                    count_array[i] = -1;
                    real_array[i] = 0.0;
                    image_array[i] = 0.0;
                }
            }
            frame = 0;
            first_rendered = false;
            loop();
        }
        
        public function mousePressed():void {
            offset_x = (offset_x + mouseX - screen_width / 2.0) / zoom;
            offset_y = (offset_y + mouseY - screen_height / 2.0) / zoom;
            zoom *= 1.2;
            offset_x *= zoom;
            offset_y *= zoom;
            clear_count();
//            redraw();
        }
        
        public function calc_stroke(x:int, y:int, n:int):int {
            const max:int = 32;
            var cx:Number = (x + offset_x - screen_width * 2.2 / 3.0) / (screen_width / 2.0) / zoom;
            var cy:Number = (y + offset_y - screen_height / 2.0) / (screen_height / 2.0) / zoom;
            var idx:int = x + y * screen_width;
            var r:Number = real_array[idx];
            var i:Number = image_array[idx];

            var nr:Number = r * r - i * i + cx;
            var ni:Number = 2.0 * r * i + cy;
            
            real_array[idx] = nr;
            image_array[idx] = ni;
            if (nr * nr + ni * ni > 4) {
                count_array[idx] = n;
                return n;
            } else {
                return -1;
            }
        }
        
        public function draw():void {
            var ndraw:int = 0;
            for (var y:int = 0; y < screen_height; y++) {
                for (var x:int = 0; x < screen_width; x++) {
                    var i:int = x + y * screen_width;
                    if (count_array[i] < 0) {
                        var n:int = calc_stroke(x, y, frame);
                        if (n >= 0) {
                            var c:int = 256 - n * 8;
                            stroke(c, c, c);
                            point(x, y);
                            ++ndraw;
                        }
                    }
                }
            }
            ++frame;
            if (ndraw > 0) {
                first_rendered = true;
            } else {
                if (first_rendered) {
                    noLoop();
                }
            }
        }
    }    
}
