/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3hXI
 */

package {
    import flash.geom.Rectangle;
    import flash.display.BitmapData;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            
            skin = new BitmapData(32,32, true, 0);
            skin.fillRect(skin.rect, 0xF0880000);
            skin.fillRect(new Rectangle(0,8,32,16), 0xF0FF0000);
            skin.fillRect(new Rectangle(0,12,32,7), 0xFFFFFFFF);
            
            //skin.noise(42);            

            stage.addEventListener(MouseEvent.CLICK, onClick);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var skin:BitmapData;
        
        public function onClick(e:MouseEvent):void
        { cx = Math.random()*430; cy = Math.random() * 430; }

        public var vecVert:Vector.<Number> = new Vector.<Number>(12, false);
        public var vecUv:Vector.<Number> = new Vector.<Number>(12, false);
        
        public function drawLine(ax:Number, ay:Number, bx:Number, by:Number, r:Number = 16):void
        {
            var ang:Number;   var ca:Number; var sa:Number;
            ang = Math.atan2(by-ay, bx-ax);
            ca = Math.cos(ang) * r;
            sa = Math.sin(ang) * r;
            
            var u0:Number; var v0:Number;
            var u1:Number; var v1:Number;
            u0 = 0; v0 = 0;
            u1 = 1; v1 = 1;
            
            
            vecVert[0] = ax + sa;     vecVert[1] = ay - ca; //0 
            vecVert[2] = ax - sa;     vecVert[3] = ay + ca; //1
            vecVert[4] = bx + sa;     vecVert[5] = by - ca; //2
            
            vecVert[6] = bx + sa;     vecVert[7] = by - ca; //2
            vecVert[8] = ax - sa;     vecVert[9] = ay + ca; //1            
            vecVert[10] = bx - sa;     vecVert[11] = by + ca; //3
            
            vecUv[0] = u0;     vecUv[1] = v0; //0 
            vecUv[2] = u0;     vecUv[3] = v1; //1
            vecUv[4] = u1;     vecUv[5] = v0; //2
            
            vecUv[6] = u1;     vecUv[7] = v0; //2
            vecUv[8] = u0;     vecUv[9] = v1; //1            
            vecUv[10] = u1;    vecUv[11] = v1; //3  

           // graphics.beginFill(0xFF, 1);
            graphics.beginBitmapFill(skin);
            graphics.drawTriangles(vecVert,null,vecUv);      
            graphics.endFill();            
        }//drawline
        
        
        public var cx:Number =230;
        public var cy:Number = 230;
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);

            var mx:Number; var my:Number;
            mx = stage.mouseX; my = stage.mouseY;

            drawLine(cx, cy, mx, my, 16);            
            
        }//onenter
        
    }//classend
}