/**
 * Copyright req ( http://wonderfl.net/user/req )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3hRg
 */

// forked from sakef's 簡単ドット地球儀
/*
    簡単ドット地球儀。
*/
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.events.Event;
    import net.wonderfl.utils.SequentialLoader;
    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.BitmapEffectLayer;

    import funnel.*;
    import funnel.gui.ArduinoGUI;
    import funnel.ui.*;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
    public class Main extends BasicView
    {
        private static const IMG:String = "http://assets.wonderfl.net/images/related_images/5/5c/5ce4/5ce43791031655e75d33c8a6382dc1429fb4fb76";
        private static const N_POINT1:int=150;
        private static const N_POINT2:int=100;
        private var pixels:Pixels;
        private var imgs:Array
        
        private const NUM_CHANNELS:int = 3;

        private var aio:Arduino;
        private var scopes:Array;
        
        // コンストラクタ
        public function Main()
        {            
            super(465, 465, true, true);
            
            // 画像ロード
            imgs = [];
            SequentialLoader.loadImages([IMG], imgs, init);
        }
        
        // 色々初期化する関数
        private function init():void
        {
            // レイヤーの用意
            var layer:BitmapEffectLayer=new BitmapEffectLayer(viewport, 465, 465, true, 0, BitmapClearMode.CLEAR_PRE, true);
            layer.clearBeforeRender=true;
            viewport.containerSprite.addLayer(layer);
            
            // カメラの設定・Pixelsの初期化
            camera.z=-500;
            pixels=scene.addChild(new Pixels(layer)) as Pixels;
            
            // 世界地図画像の初期化
            var ldr:Loader=imgs.pop();
            var source:BitmapData = (ldr.content as Bitmap).bitmapData;
            
            // 座標を計算して、Pixel3Dを作成
            for(var i:int=0; i < N_POINT1; i++)
            {
                var theta1:Number=(360 / N_POINT1) * i * Math.PI / 180;
                for(var j:int=0; j < N_POINT2; j++)
                {
                    // 座標計算
                    var theta2:Number=((180 / N_POINT2) * j - 90) * Math.PI / 180;
                    var xx:Number=230 * Math.cos(theta2) * Math.sin(theta1);
                    var yy:Number=230 * Math.sin(theta2);
                    var zz:Number=230 * Math.cos(theta2) * Math.cos(theta1);
                    
                    // 色計算 & Pixel3D作成
                    var color:uint = (source.getPixel(i, j) == 0xffffff)?(0xff0000ff):(0xff00ff00);
                    pixels.addPixel3D(new Pixel3D(color, xx, yy, zz));
                }
            }
            
            // フレームイベント
            addEventListener(Event.ENTER_FRAME, onFrame);
            //-------------------------------------------------------------------            
            var config:Configuration = Arduino.FIRMATA;
            config.setDigitalPinMode(11, PWM);
            config.setDigitalPinMode(12, IN);
            config.setDigitalPinMode(13, OUT);

            aio = new Arduino(config);

            scopes = new Array(NUM_CHANNELS);
            for (var k:int = 0; k < NUM_CHANNELS; k++) {
                scopes[k] = new SignalScope(10, 10 + (60 * k), 200, "A" + k);
                addChild(scopes[k]);
            }

            var gui:ArduinoGUI = new ArduinoGUI();
            addChild(gui);
            aio.gui = gui;

            var button:Button = new Button(aio.digitalPin(12));
            var externalLED:LED = new LED(aio.digitalPin(11));
            var onBoardLED:LED = new LED(aio.digitalPin(13));

            button.addEventListener(ButtonEvent.PRESS, function(e:Event):void {
                onBoardLED.on();
                externalLED.blink(1000, 0, Osc.SIN);
            });

            button.addEventListener(ButtonEvent.RELEASE, function(e:Event):void {
                onBoardLED.off();
                externalLED.stopBlinking();
            });

            //aio.analogPin(0).addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            //aio.analogPin(0).addFilter(new Scaler(0.000, 0.649, 0, 1, Scaler.LINEAR, true));
            
            aio.analogPin(0).filters = [
                new Scaler(0.3, 0.7, -45, 45, Scaler.LINEAR, true),
                new Convolution(Convolution.MOVING_AVERAGE)
            ];

            aio.analogPin(1).filters = [
                new Scaler(0.3, 0.7, -45, 45, Scaler.LINEAR, true),
                new Convolution(Convolution.MOVING_AVERAGE)
            ];
            addEventListener(Event.ENTER_FRAME, loop);
//-------------------------------------------------------------------            
        }
        
        // レンダリング
        private function onFrame(e:Event):void
        {
            pixels.rotationX ++;
            pixels.rotationY ++;
            singleRender();
        }
        
        private function loop(event:Event):void {
            for (var i:int = 0; i < NUM_CHANNELS; i++) {
                scopes[i].update(aio.analogPin(i));
            }
            pixels.rotationX = aio.analogPin(0).value;
            pixels.rotationY = aio.analogPin(1).value;
        }
    }
}