/**
 * Copyright alpicola ( http://wonderfl.net/user/alpicola )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3gsi
 */

// forked from 5ivestar's Guilloches

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;

	[SWF(backgroundColor="#ffffff", frameRate="24", width="465", height="465")]

	public class Guilloche extends Sprite {

		private var r:Number = 0.085;
		private var R:Number = 55;
		private var p:Number = 0;
		private var scale:Number = 3;
		private var steps:uint = 1000;
		private var color:uint = 0x000000;
		private var bitmap:BitmapData;
		private var shape:Shape = new Shape();
		private var playing:Boolean = true;

		public function Guilloche() {
			stage.scaleMode = "noScale";
			stage.align = "TL";
			bitmap = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x000000);
			addChild(new Bitmap(bitmap))
			addEventListener(Event.ENTER_FRAME, draw);
			stage.addEventListener(MouseEvent.MOUSE_UP, click);
		}

		public function draw(e:Event):void {
			var x:Number, y:Number, t:Number = 0;
			var rR:Number = r + R;
			var rp:Number = r + p;
			var dt:Number = 2 * Math.PI / steps;
			var g:Graphics = shape.graphics;
			var matrix:Matrix = new Matrix();
			matrix.translate(stage.stageWidth / 2, stage.stageHeight / 2);
			p += 0.05;
			R -= 0.05;
			if (R < 0) p = 0, R = 55;

			g.clear();
			g.lineStyle(1, color, 0.3);
			g.moveTo((r * 2 + R + p) * scale, 0);

			bitmap.lock();
			bitmap.fillRect(bitmap.rect, 0x000000);
			for (var i:int = 1; i <= steps; i++) {
				t += dt;
				x = (rR * Math.cos(t) + rp * Math.cos(rR/r * t)) * scale;
				y = (rR * Math.sin(t) + rp * Math.sin(rR/r * t)) * scale;
				g.lineTo(x, y);
				if ((i & 7) == 0) {
					bitmap.draw(shape, matrix);
					g.clear();
					g.lineStyle(1, color, 0.3);
					g.moveTo(x, y);
				}
			}
			bitmap.unlock();
		}

		public function click(e:Event):void {
			if (playing) {
				playing = false;
				removeEventListener(Event.ENTER_FRAME, draw);
			} else {
				playing = true;
				addEventListener(Event.ENTER_FRAME, draw);
			}
		}

	}
}
