/**
 * Copyright KinkumaDesign ( http://wonderfl.net/user/KinkumaDesign )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3gB8
 */

package 
{
	/**
	 * 
	 * ステージをクリックするたびにわんこが巻き巻きするよ！
	 * 早くクリックしないともとに戻っちゃうから、急いでクリックしてね。
	 * 
	 * わんこの読み込み方はbeinteractiveさんのWANCO? OR NOTを使わせていただきました。
	 * http://wonderfl.net/code/665b18adfd9433de72edbb9f70db9a598522fa4b
	 */
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Loader;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.display.TriangleCulling;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.net.URLRequest;

	[SWF(width="450", height="450", frameRate="60", backgroundColor="#000000")]
	public class Main extends Sprite 
	{
		private static var UNKO_URL:String = 'http://swf.wonderfl.net/static/assets/checkmate05/wancoProfessional.swf';
		private var _srcBmd:BitmapData;
		private var _rowPixels:Array;
		private var _canvas:Sprite;
		private var _baseDeg:Number = 0;
		private var _incrementDeg:Number = 0;
		private var _accerartaionDeg:Number = 0;
		private var _drawDeg:Number = -0.01;
		private var loader:Loader;
		private var unko:MovieClip;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loaderCompHD);
			loader.load(new URLRequest(UNKO_URL));
		}
		
		private function loaderCompHD(e:Event):void 
		{
			stage.addEventListener(MouseEvent.MOUSE_DOWN, downHD);
			loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, loaderCompHD);
			var UnkoClass:Class = loader.contentLoaderInfo.applicationDomain.getDefinition('WakeMotion') as Class;
			unko = new UnkoClass();
			
			_canvas = new Sprite();
			addChild(_canvas);
			_canvas.x = 225;
			_canvas.y = 225;
			
			_srcBmd = new BitmapData(unko.width * 4 + 30, unko.height * 4 + 30, true);
			drawUnko();
			
			var i:int;
			var rowpx:RowPixel;
			var sw:Number = _srcBmd.width;
			var sh:Number = _srcBmd.height;
			_rowPixels = new Array();
			for (i = 0; i < sh; i++) { 
				var v:Vector.<Number> = Vector.<Number>([0 - sw/2, i  - sh/2, sw - sw/2, i - sh/2]);
				var uvt:Vector.<Number> = Vector.<Number>([0, i / sh, 1, i / sh]);
				rowpx = new RowPixel(v, uvt);
				_rowPixels.push(rowpx);
			}
			addEventListener(Event.ENTER_FRAME, draw);
		}
		
		private function downHD(e:MouseEvent):void 
		{
			_accerartaionDeg += 0.1;
			if (_accerartaionDeg > 0.5) {
				_accerartaionDeg = 0.5;
			}else if (_accerartaionDeg < 0) {
				_accerartaionDeg = 0;
			}
		}
		
		private function drawUnko():void
		{
			var mat:Matrix = new Matrix();
			mat.translate(unko.width - 30, unko.height);
			mat.scale(4, 4);
			
			_srcBmd.lock();
			_srcBmd.fillRect(_srcBmd.rect, 0);
			_srcBmd.draw(unko, mat);
			_srcBmd.unlock();
		}
		
		private function draw(e:Event):void
		{
			drawUnko();
			var vertices:Vector.<Number> = new Vector.<Number>();
			var ind:Vector.<int> = new Vector.<int>();
			var uvt:Vector.<Number> = new Vector.<Number>();
			var i:int;
			var rowpx:RowPixel;
			var fl:Number = 200;
			var z1:Number = 0;
			var z2:Number = 0;
			var deg:Number = _baseDeg;
			_baseDeg++;
			
			_accerartaionDeg += _drawDeg;

			_incrementDeg += _accerartaionDeg;
			if (_incrementDeg < 0) {
				_incrementDeg = 0;
			}else if (_incrementDeg > 100) {
				_incrementDeg = 100;
			}
			var sh:Number = _srcBmd.height / 2;
			for (i = 0; i < _rowPixels.length; i++) {
				rowpx = _rowPixels[i];
				var v:Vector.<Number> = rowpx.getRotationVertices(deg);
				deg += _incrementDeg * 0.1;
				var u:Vector.<Number> = rowpx.uvtData;
				var t1:Number = fl / (fl + v[2]);
				var t2:Number = fl / (fl + v[5]);
				vertices.push(
						v[0] * t1, v[1] * t1,
						v[3] * t2, v[4] * t2
				);
				uvt.push(
					u[0], u[1], t1,
					u[2], u[3], t2
				);
				ind.push(
					i*2, i*2+1, i*2+2, i*2+1, i*2+3, i*2+2
				);
			}
			var g:Graphics = _canvas.graphics;
			g.clear();
			g.beginBitmapFill(_srcBmd);
			g.drawTriangles(vertices, ind, uvt);
		}
		
		
	}
}
import flash.geom.Matrix3D;
import flash.geom.Vector3D;

class RowPixel 
{
	public var vertices:Vector.<Number>;
	public var uvtData:Vector.<Number>;
	
	public function RowPixel(vertices:Vector.<Number>, uvtData:Vector.<Number>)
	{
		this.vertices = vertices;
		this.uvtData = uvtData;
	}
	
	public function getRotationVertices(deg:Number):Vector.<Number>
	{
		var mat1:Matrix3D = new Matrix3D();
		var mat2:Matrix3D = new Matrix3D();
		var v1:Vector3D = new Vector3D(vertices[0], vertices[1], 0);
		var v2:Vector3D = new Vector3D(vertices[2], vertices[3], 0);
		mat1.appendRotation(deg, Vector3D.Y_AXIS);
		mat2.appendRotation(deg, Vector3D.Y_AXIS);
		v1 = mat1.transformVector(v1);
		v2 = mat2.transformVector(v2);
		return Vector.<Number>([v1.x, v1.y, v1.z, v2.x, v2.y, v2.z]);
	}
}