/**
 * Copyright correa_elias ( http://wonderfl.net/user/correa_elias )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3g9r
 */

// forked from yd_niku's forked from: Egg laying of Coral
// forked from yd_niku's Egg laying of Coral
// forked from yd_niku's forked from: forked from: flash on 2009-10-6
// forked from yd_niku's forked from: flash on 2009-10-6
// forked from yd_niku's flash on 2009-10-6
package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.net.*;
    import flash.geom.*;
    import flash.system.*;
    import flash.utils.*;
    [SWF(frameRate=60)]
    public class FlashTest extends Sprite {
        public function FlashTest() {
            if( stage ) init();
            else addEventListener( Event.ADDED_TO_STAGE, init );
        }
        
        private var _canvas:BitmapData;
        private var _map:BitmapData;
        
        private var _stream:BitmapData;
        private var _force:BitmapData;
        
        private function init(e:Event=null):void {
            removeEventListener( Event.ADDED_TO_STAGE, init );
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.addEventListener( Event.RESIZE, resize );
            resize();
            
            _canvas = new BitmapData(rect.width,rect.height,false,0)
            addChild( new Bitmap( _canvas ) );
            
            _map = new BitmapData(rect.width/4,rect.height/4,false,0);
            var mapdisplay:DisplayObject = addChild( new Bitmap(_map) );
            mapdisplay.alpha = 0.5;
            mapdisplay.scaleX = mapdisplay.scaleY = 4;
            mapdisplay.blendMode = BlendMode.ADD;
            
            _stream = new BitmapData(rect.width/4,rect.height/4,true,0);
            
            
            _force = new BitmapData(rect.width/4,rect.height/4,true,0);
            var streamDisplay:Bitmap = new Bitmap( _force );
            addChild( streamDisplay );
            
            addEventListener( Event.ENTER_FRAME, update );
            update();
            
            addEventListener( Event.ENTER_FRAME, emitter );
            emitter();
            
            _brush.graphics.beginFill(0x0, 1);
            _brush.graphics.drawCircle(10,10,10);
            _brush.graphics.endFill();
            
            var drawTimer:Timer = new Timer(100);
            drawTimer.addEventListener( TimerEvent.TIMER, mouseDraw );
            drawTimer.start();
            //addEventListener( Event.ENTER_FRAME, mouseDraw );
            mouseDraw();
            
            var timer:Timer = new Timer(10000);
            timer.addEventListener( TimerEvent.TIMER, updateForceMap );
            timer.start();
            
            updateForceMap();
        }
        
        private var _brush:Sprite = new Sprite;
        private var _preMouse:Point = new Point(232,232);
        private var _matrixBrush:Matrix = new Matrix();
        private var _blur:BlurFilter= new BlurFilter(16,16,2);
        
        private var _ctfBrush:ColorTransform = new ColorTransform(0,0,0,1,0,0,0,0);
        
        private function mouseDraw( e:Event = null ):void {
            var dx :Number = (mouseX - _preMouse.x)/256;
            var dy :Number = (mouseY - _preMouse.y)/256;
            _matrixBrush.tx = _preMouse.x/4 - 10;
            _matrixBrush.ty = _preMouse.y/4 - 10;
            _ctfBrush.redOffset = dx*100+ 100;
            _ctfBrush.blueOffset =  dy*100 + 100;
            _stream.draw( _brush, _matrixBrush, _ctfBrush );
            _stream.colorTransform( _stream.rect, new ColorTransform( 0.99, 0.99, 0.99, 0.99 ) );
            
            _preMouse.x = mouseX;
            _preMouse.y = mouseY;
            
            _force.draw( _map );
            _force.draw( _stream, null, null, BlendMode.ADD );
        }
        private function updateForceMap( e:Event = null ):void {
            _map.perlinNoise( 256, 256, 4, Math.random()*0xff>>0, true, true, 5 )
        }
        
        private const PARTICLE_LENGTH:int = 15000;
        private var _emitterCount:int = 0;
        private function emitter( e:Event=null ):void {
            if( _emitterCount++ % 3 != 0 ) return;
            
            var angle:Number, radius:Number;
            for( var i:int = 0; i<80; ++i ) {
                var p :Particle = new Particle;
                p.x = (rect.width/2) + ( Math.random() - 0.5 ) *6;
                p.y = rect.height - 20 * Math.random();
                angle =( Math.random() - 0.5 ) * 12- 60 - _emitterCount/10;
                radius = Math.random() * 2 + 1;
                p.vx = Math.cos(angle/180*Math.PI) * radius ;
                p.vy = Math.sin(angle/180*Math.PI) * radius ;
                _particles.push( p );
            }
             
            if( _particles.length >= PARTICLE_LENGTH )
                removeEventListener(  Event.ENTER_FRAME, emitter );
        }
        
        
        private var _windDrag:Point = new Point( 0.998, 0.998 );
        private var _particles:Vector.<Particle> = new Vector.<Particle>();
        
        private var _ctf:ColorTransform = new ColorTransform(0.98, 0.997, 0.995, 0.98 );
        private function update(e:Event = null):void {
            _canvas.lock();
            _canvas.colorTransform( _canvas.rect, _ctf );
            
            _canvas.applyFilter( _canvas, rect, distPoint, _blur );
            for each( var p:Particle in _particles ) {
                if( p.life < 0 ) continue;
                var forceColor:uint = _force.getPixel(p.x>>2,p.y>>2);
                var forceX:Number = ((forceColor >> 16)-128) / 256;
                var forceY:Number = ((forceColor & 0xFF )-128) / 256;
                
                p.ax = p.ax*0.3 + forceX * 0.02;
                p.ay = p.ay*0.3 + forceY * 0.02;
                
                p.vx += p.ax;
                p.vy += p.ay;
                
                p.vx *= _windDrag.x;
                p.vy *= _windDrag.y;
                
                p.x += p.vx;
                p.y += p.vy;
                
                p.life++;
                 
                if( p.x < 0 ) p.x = rect.width;
                else if( p.x > rect.width ) p.x = 0;
                if( p.y < 0 ) p.y = rect.height;
                else if( p.y > rect.height ) p.y = 0;
                
                _canvas.setPixel( p.x, p.y, 0x00ff00 );
            }
            _canvas.unlock();
        }
        
        public var distPoint:Point = new Point;
        public var rect:Rectangle = new Rectangle();
        public var center:Point = new Point();
        private function resize(e:Event=null):void{
            rect.width = stage.stageWidth;
            rect.height= stage.stageHeight;
            
            center.x=  rect.width/2>>0;
            center.y = rect.height/2>>0;
        }
    }
}

class Particle {
    public var x:Number = 0;
    public var y:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var ax:Number = 0;
    public var ay:Number = 0;
    public var life:Number = 100;
}