/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3g5H
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    
    [SWF(backgroundColor=0x000000)]
    public class InverseKinematics extends Sprite
    {
        private var numRopes:Number = 1;
        private var hourRadius:Number = 200;
        private var minRadius:Number = 150;
        private var secRadius:Number = 100;
        private var hourColor:uint = 0xccff00;
        private var minColor:uint = 0x6699cc;
        private var secColor:uint = 0xcc0000;
        private var hour:Sprite;
        private var min:Sprite;
        private var sec:Sprite;
        private var count:Number;
        
        public function InverseKinematics() 
        {
            /* gettime */
            var date:Date = new Date();
            var dateHour:Number = date.getHours();
            var dateMin:Number = date.getMinutes();
            var dateSec:Number = date.getSeconds();   
            
            count = dateSec;
            
            /* base */
            var base:Sprite = new Sprite();
            base.x = stage.stageWidth / 2;
            base.y = stage.stageHeight / 2;
            base.graphics.lineStyle( 0, 0xffffff );
            base.graphics.drawCircle(0, 0, hourRadius);
            base.graphics.drawCircle(0, 0, minRadius);
            base.graphics.drawCircle(0, 0, secRadius);
            base.alpha = 0.5;
            addChild( base );
            
            /* hour Sprite */
            hour = new Sprite();
            createFig( hour, hourColor );
            hour.x = stage.stageWidth / 2;
            hour.y = stage.stageHeight / 2 - hourRadius;
            addChild( hour );
            setPos( hour, dateHour*6 );
            
            /* min Sprite */
            min = new Sprite();
            createFig( min, minColor );
            min.x = stage.stageWidth / 2;
            min.y = stage.stageHeight / 2 - minRadius;
            addChild( min );
            setPos( min, dateMin*6 );
            
            /* sec Sprite */
            sec = new Sprite();
            createFig( sec, secColor );
            sec.x = stage.stageWidth / 2;
            sec.y = stage.stageHeight / 2 - secRadius;
            addChild( sec );
            setPos( sec, dateSec*6 );
            
            /* create IK */
            var hourIK:IK = new IK( mouseX, mouseY, hour, hourColor);
            addChild( hourIK );
            
            var minIK:IK = new IK( stage.stageWidth / 2, stage.stageHeight / 2, min, minColor);
            addChild( minIK );
            
            var secIK:IK = new IK( stage.stageWidth / 2, stage.stageHeight / 2, sec, secColor);
            addChild( secIK );
            
            /* timer */
            var timer:Timer = new Timer(1000);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
        }
        
        private function onTimer(e:TimerEvent):void {
            count++;
            setPos( sec );
            if( count % 60 == 0 ) setPos( min );
            if( count % 360 == 0 ) setPos( hour );
        }
        
        private function setPos(target:Sprite, angle:Number=6):void {
            var x1:Number = target.x - stage.stageWidth / 2;
            var y1:Number = target.y - stage.stageHeight / 2;
            var x2:Number = Math.cos( angle * Math.PI / 180 ) * x1 - Math.sin( angle * Math.PI / 180 ) * y1;
            var y2:Number = Math.cos( angle * Math.PI / 180 ) * y1 + Math.sin( angle * Math.PI / 180 ) * x1;
            target.x = stage.stageWidth / 2 + x2;
            target.y = stage.stageHeight / 2 + y2;
        }

        private function createFig(target:Sprite, color:uint):void {
            target.graphics.beginFill( color );
            target.graphics.drawCircle(0, 0, 10);
            target.graphics.endFill();
        }

    }

}

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    
    class IK extends Sprite
    {
        private var segments:Array;
        private var target:Sprite;
        private var num:Number = 60;
        
        public function IK(posX:Number, posY:Number, target:Sprite, color:uint=0x000000) 
        {
            this.target = target;

            segments = new Array();
            for( var i:uint = 0; i < num; i++ ){
                var seg:Segment = new Segment( 5, 2, color );
                addChild( seg );
                segments.push( seg );
            }
            
            seg.x = posX;
            seg.y = posY;

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            segments[segments.length-1].x = mouseX;
            segments[segments.length-1].y = mouseY;
            var next:Point = reach(segments[0], target.x, target.y);
            
            for( var i:uint = 1; i < num; i++ ){
                var seg:Segment = segments[i];
                next = reach( seg, next.x, next.y) ;
            }

            for( i = num - 1; i > 0; i-- ){
                var segA:Segment = segments[i];
                var segB:Segment = segments[i-1];
                position( segB, segA );
            }
        }
        
        private function reach(seg:Segment, xPos:Number, yPos:Number):Point {
            var dx:Number = xPos - seg.x;
            var dy:Number = yPos - seg.y;
            var angle:Number = Math.atan2( dy, dx );
            seg.rotation = angle * 180 / Math.PI;
            
            var w:Number = seg.getPin().x - seg.x;
            var h:Number = seg.getPin().y - seg.y;
            var tx:Number = xPos - w;
            var ty:Number = yPos - h;
            
            return new Point( tx, ty );
        }

        private function position(segA:Segment, segB:Segment):void {
            segA.x = segB.getPin().x;
            segA.y = segB.getPin().y;
        }

    }

import flash.display.Sprite;
import flash.geom.Point;

class Segment extends Sprite {
    private var color:uint;
    private var segmentWidth:Number;
    private var segmentHeight:Number;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public function Segment(segmentWidth:Number,segmentHeight:Number,color:uint=0xffffff){
        this.segmentWidth = segmentWidth;
        this.segmentHeight = segmentHeight;
        this.color = color;
        init();
    }
    
    public function init():void {
        //セグメントの描画
        graphics.lineStyle(0, color);
        graphics.beginFill( color );
        graphics.drawRoundRect( -segmentHeight / 2, -segmentHeight / 2, segmentWidth+segmentHeight, segmentHeight, segmentHeight, segmentHeight );
        graphics.endFill();
    }
    
    public function getPin():Point {
        var angle:Number = rotation * Math.PI / 180;
        var xPos:Number = x + Math.cos( angle ) * segmentWidth;
        var yPos:Number = y + Math.sin( angle ) * segmentWidth;
        return new Point( xPos, yPos );
    }
}