/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3ft6
 */

// forked from milkmidi's Electricity Effect
// forked from tkinjo's forked from: Electricity Effect
package {
    
    /**
     * ...
     * @author milkmidi
     * http://milkmidi.blogspot.com
     * 
     * -----
     * forked by tkinjo
     * 
     * This effect is cool!
     * So, I added comment and refactored for study.
     */
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "0x0")]
    public class ElectPaint extends Sprite {
        
        private const GLOW_FILTER_1:GlowFilter = new GlowFilter( 0x00ffff, 1,   1,  1,  100, 1, false, true  );
        private const GLOW_FILTER_2:GlowFilter = new GlowFilter( 0x00ffff, 0.6, 8,  8,  2,   1, false, false );
        private const GLOW_FILTER_3:GlowFilter = new GlowFilter( 0x6666ff, 0.8, 10, 10, 3,   1, false, false );
        
        private const CLEAR_COLOR_TRANSFORM:ColorTransform = new ColorTransform( 1, 1, 1, 0 );
        
        private const FRICTION:Number = 0.5;
        
        private const INIT_POINT:Point = new Point();
        
        private const PERLIN_NOISE_QUOLITY:Number = 0.4;
        
        
        private var sourceBitmapData      :BitmapData;
        private var displaceBitmapData    :BitmapData;
        private var perlinNoiseBitmapData :BitmapData;
        private var mapBitmapData         :BitmapData;
        
        
        
        private var offsetArray:Array = [new Point(), new Point()];
        private var displacementFilter:DisplacementMapFilter;
        private var blurFilter:BlurFilter
        private var mapBitmapDataMatrix:Matrix;
        
        private var canvas:Sprite;
        private var stabilizer:Point = new Point();
        private var mouseDown:Boolean;
        
        
        
        public function ElectPaint() {
            
            // sourceBitmapData
            sourceBitmapData = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0 );
            
            // perlinNoiseBitmapData
            perlinNoiseBitmapData = new BitmapData( stage.stageWidth * PERLIN_NOISE_QUOLITY, stage.stageHeight * PERLIN_NOISE_QUOLITY );
            
            // mapBitmapData
            mapBitmapDataMatrix = new Matrix();
            mapBitmapDataMatrix.scale( 1 / PERLIN_NOISE_QUOLITY, 1 / PERLIN_NOISE_QUOLITY );
            
            mapBitmapData = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0 );
            mapBitmapData.draw( perlinNoiseBitmapData, mapBitmapDataMatrix );
            
            blurFilter = new BlurFilter( 1 / PERLIN_NOISE_QUOLITY, 1 / PERLIN_NOISE_QUOLITY );
            mapBitmapData.applyFilter( mapBitmapData, mapBitmapData.rect, INIT_POINT, blurFilter );
            
            // displaceBitmapData & displaceBitmap
            displaceBitmapData = new BitmapData( stage.stageWidth, stage.stageHeight, true, 0 );
            
            var displaceBitmap:Bitmap = new Bitmap( displaceBitmapData );
            addChild( displaceBitmap );
            
            
            
            // filter
            displacementFilter = new DisplacementMapFilter( mapBitmapData, INIT_POINT, 1, 1, 25, 25, DisplacementMapFilterMode.COLOR );
            
            displaceBitmap.blendMode = BlendMode.SCREEN;
            displaceBitmap.filters   = [ GLOW_FILTER_2, GLOW_FILTER_3 ];
            
            
            
            canvas = new Sprite();
            
            
            
            // add eventListener
            addEventListener( Event.ENTER_FRAME, enterFrameHandler );
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP,   mouseUpHandler);
        }
        
        private function enterFrameHandler( event:Event ):void {
            
            
            if ( mouseDown ) {
                
                stabilizer.x += ( stage.mouseX - stabilizer.x ) * FRICTION;
                stabilizer.y += ( stage.mouseY - stabilizer.y ) * FRICTION;
                
                canvas.graphics.lineTo( stabilizer.x, stabilizer.y );
            }
            sourceBitmapData.colorTransform( sourceBitmapData.rect, CLEAR_COLOR_TRANSFORM );
            sourceBitmapData.draw( canvas );
            
            
            
            // update perlinNoiseBitmapData
            offsetArray[0].x -= 2;
            offsetArray[1].x -= 1;
            
            perlinNoiseBitmapData.perlinNoise( 10 * PERLIN_NOISE_QUOLITY, 20 * PERLIN_NOISE_QUOLITY, 1, 0, false, true, BitmapDataChannel.RED, true, offsetArray );
            mapBitmapData.colorTransform( sourceBitmapData.rect, CLEAR_COLOR_TRANSFORM );
            mapBitmapData.draw( perlinNoiseBitmapData, mapBitmapDataMatrix );
            mapBitmapData.applyFilter( mapBitmapData, mapBitmapData.rect, INIT_POINT, blurFilter );
            
            
            
            // update displaceBitmapData
            displaceBitmapData.applyFilter( sourceBitmapData,   sourceBitmapData.rect, INIT_POINT, GLOW_FILTER_1      );
            displaceBitmapData.applyFilter( displaceBitmapData, sourceBitmapData.rect, INIT_POINT, displacementFilter );
        }
        
        private function mouseDownHandler( event:MouseEvent ):void {
            
            mouseDown = true;
            canvas.graphics.lineStyle( 8 );
            
            stabilizer.x = event.stageX;
            stabilizer.y = event.stageY;
            
            canvas.graphics.moveTo( stabilizer.x, stabilizer.y );
        }
        
        private function mouseUpHandler( event:MouseEvent ):void {
            
            mouseDown = false;
            canvas.graphics.lineStyle();
        }
    }
}