/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3eY7
 */

package {
  import com.actionscriptbible.Example;
  import flash.geom.Matrix3D;
  
  public class ch34ex5 extends Example {
    public function ch34ex5() {
      //create a default (identity) matrix
      var m:Matrix3D = new Matrix3D();
      prettyPrintMatrix(m); //identity matrix

      var v:Vector.<Number> = m.rawData;
      v[4] = 9.2;
      m.rawData = v;
      prettyPrintMatrix(m); //9.2 appears on top of 2nd column

      m.identity(); //reset matrix
      m.appendTranslation(16, 19, 21);
      prettyPrintMatrix(m); //the translation factors appear in column 4
    }
    protected function prettyPrintMatrix(m:Matrix3D):void {
      var str:String = "";
      for (var col:int = 0; col < 4; col++) {
        var line:String = "|";
        for (var row:int = 0; row < 4; row++) {
          line += "\t" + m.rawData[row*4+col].toPrecision(3) + "\t";
        }
        str += line + "|\n";
      }
      trace(str);
    }
  }
}