/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3djL
 */

package  
{
    import flash.display.Sprite;
    
    public class GaussianDistributionClient extends Sprite 
    {
        
        public function GaussianDistributionClient() 
        {
            var mu:Number = 0;
            var sigma:Number = 1;
            var cx:Number = 0;
            var cy:Number = 0;
            
            graphics.lineStyle(9);
            drawGaussian(mu, sigma, cx, cy);
            graphics.lineStyle(2,255);
            drawGaussian(mu, 0.5, cx, cy);
            graphics.lineStyle(2,0xff7f00);
            drawGaussian(-2.5, sigma, cx, cy);
            graphics.lineStyle(5,0xff0000);
            draw();
            graphics.lineStyle(5,0x00ff00);
            drawNormalized(2.5,sigma,cx,cy);
        }
        
        private function draw():void 
        {
            var mu:Number = 0;
            var sigma:Number = 1;
            var cy:Number=0;
            var cx:Number=0;
            var gd:Number;
            var xx:Number;
            var nn:Number;
            var number:int = 100;
            var nInv:Number = 1 / number;
            var size:Number = 10;
            
            //units per pixel  Y axis
            var uppY:Number = 200;
            //pixels per unit X axis
            var ppuX:int = 2;
            var plotHeight:Number = 200;
            
            for (var i:int = 0; i <= number; i++) 
            {
                nn = i * nInv;
                xx = (nn - 0.5)*size;
                gd = GaussianDistribution.getValue(xx, mu, sigma);
                graphics.lineTo(cx + i * ppuX, cy + plotHeight - gd * uppY);
            }
        }
        private function drawNormalized(mu:Number, sigma:Number, cx:Number, cy:Number):void 
        {
            var gd:Number;
            var xx:Number;
            var nn:Number;
            var number:int = 100;
            var nInv:Number = 1 / number;
            var size:Number = 10;
            
            //units per pixel  Y axis
            var uppY:Number = 200;
            //pixels per unit X axis
            var ppuX:int = 2;
            var plotHeight:Number = 200;
            
            for (var i:int = 0; i <= number; i++) 
            {
                nn = i * nInv;
                xx = (nn - 0.5)*size;
                gd = GaussianDistribution.getNormalizedValue(xx, mu, sigma);
                graphics.lineTo(cx + i * ppuX, cy + plotHeight - gd * uppY);
            }
        }
        
        private function drawGaussian(mu:Number, sigma:Number, cx:Number, cy:Number):void 
        {
            var g1:GaussianDistribution = new GaussianDistribution(mu, sigma);
            var data1:Array = g1.getData();
            var l:uint = data1.length;
            var valueAtZero:Number = GaussianDistribution.getValue(0, mu, sigma);
            var vazInv:Number = 1 / valueAtZero;
            trace( "valueAtZero : " + valueAtZero );
            trace( "vazInv : " + vazInv );
            //units per pixel  Y axis
            var uppY:Number = 200;
            //pixels per unit X axis
            var ppuX:int = 2;
            var plotHeight:Number = 200;
            graphics.moveTo(cx, cy + plotHeight);
            for (var i:int = 0; i < l; i++) 
            {
                graphics.lineTo(cx + i * ppuX, cy + plotHeight - data1[i] * uppY);
            }
            graphics.drawRect(cx, cy, ppuX*l, uppY);
        }
        
    }

}
class GaussianDistribution 
{
    private var mu:Number;
    private var _sigma:Number;
    private var factor:Number;
    
    public function GaussianDistribution(mu:Number, sigma:Number) 
    {
        this.sigma = sigma;
        this.mu = mu;
        
        
    }
    
    public function getData():Array 
    {
        var gaussian:Number;
        var pow:Number;
        var xx:Number;
        var normal:Number;
        var steps:int = 100;
        var delta:Number = 1 / steps;
        var data:Array = [];
        var initxx:Number = -5;
        var finalxx:Number = 5;
        var size:Number = 10;
        size = finalxx > initxx?finalxx - initxx:initxx - finalxx;
        for (var i:int = 0; i < steps; i++) 
        {
            normal = i * delta;
            xx = size * normal - size*0.5;
            pow = -(xx - mu) * (xx - mu)/(2*sigma*sigma);
            gaussian = factor * Math.pow(Math.E, pow);
            data[i] = gaussian;
        }
        return data;
    
    }
    
    public static function getNormalizedValue(xx:Number, mu:Number, sigma:Number):Number
    {
        return getValue(xx, mu, sigma) / getValue(mu, mu, sigma);
    }
    public static function getValue(xx:Number, mu:Number, sigma:Number):Number
    {
        var gaussian:Number;
        var pow:Number;
        var s:Number = 1 / sigma;
        var factor:Number  = s / Math.sqrt(2 * Math.PI);
        pow = -(xx - mu) * (xx - mu)*s*s*0.5;            
        gaussian = factor * Math.pow(Math.E, pow);
        return gaussian
    }
    
    public function get sigma():Number 
    {
        return _sigma;
    }
    
    public function set sigma(value:Number):void 
    {
        _sigma = value;
        factor = 1 /( sigma * Math.sqrt(2 * Math.PI));
    }
    
}