/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3cb3
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;

    [SWF(width = '465', height = '465')]
    public class MafiaTunnelE0 extends Sprite
    {
        private var bmd : BitmapData;
        private var buffer : Vector.<uint>;
        private var fcnt : int;
        private var dt : Number;

        function MafiaTunnelE0()
        {
            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            var bm : Bitmap = new Bitmap(bmd = new BitmapData(512, 512, false));
            bm.x = bm.y = -((512 - 465) >> 1);
            bm.opaqueBackground = 0x0;
            addChild(bm);

            buffer = new Vector.<uint>(512 << 9, true);

            dt = 6.283185307179586 * Math.random();
            fcnt = (1024 * Math.random()) >> 0;

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void
        {
            this.fcnt++;
            this.dt += 0.033;

            var dt : Number = this.dt;
            var fcnt : int = this.fcnt;

            var blob : Number = 0.6 + 0.3 * Math.cos(((fcnt & 1023) / 1024) * 6.283185307179586);
            var cosdt : Number = Math.cos(dt);
            var vax : Number = cosdt + Math.sin(dt * 0.2);
            var vaz : Number = 2 + Math.cos(dt * 0.5) * 0.5;
            var vbx : Number = -Math.cos(dt * 0.7);
            var vbz : Number = 2 + Math.sin(dt * 0.5);
            var vcx : Number = -Math.sin(dt * 0.2) * 0.5;
            var vcy : Number = Math.sin(dt);

            cosdt *= 0.18;

            var pos : int = buffer.length - 2048 - (fcnt & 1);
            while (pos > 2048)
            {
                pos--;
                pos--;
                var px : int = pos & 511;
                var py : int = pos >> 9;

                var ox : Number = -1 + 2 * (px / 512);
                var oy : Number = - 0.3 + 1.25 * (1 - (2 * (py / 512)));
                var dx : Number = (ox + cosdt) * 0.015625;
                var dy : Number = (1 - (2 * (py / 512))) * 0.015625;
                var t : Number = 64;
                var lum : Number = 0.0;

                var i : int = ((192 - (((px - 256) * (px - 256) + (py - 256) * (py - 256)) >> 8)) >> (6 - ((py + fcnt) & 1)));
                while (i-- > 0)
                {
                    var vx : Number = ox + dx * t;
                    var vy : Number = oy + dy * t;
                    var vz : Number = 0.015625 * t;

                    var th : Number = vx + 1.5707963267948966;
                    var cax1 : Number = 1.27323954 * th - 0.405284735 * th * th;

                    th = (vx * 3) + 1.5707963267948966;
                    if (th > 3.141592653589793) th -= 6.283185307179586;
                    var cax2 : Number = (th < 0) ? (1.27323954 * th + 0.405284735 * th * th) : (1.27323954 * th - 0.405284735 * th * th);

                    th = vy + 1.5707963267948966;
                    var cay1 : Number = 1.27323954 * th - 0.405284735 * th * th;

                    th = (vy * 4) + 1.5707963267948966;
                    if (th > 3.141592653589793) th -= 6.283185307179586;
                    var cay2 : Number = (th < 0) ? (1.27323954 * th + 0.405284735 * th * th) : (1.27323954 * th - 0.405284735 * th * th);

                    th = (vz * 7 + dt * 7) + 1.5707963267948966;
                    th %= 6.283185307179586;
                    if (th > 3.141592653589793) th -= 6.283185307179586;
                    var caz : Number = (th < 0) ? (1.27323954 * th + 0.405284735 * th * th) : (1.27323954 * th - 0.405284735 * th * th);

                    var ddd : Number = Math.sqrt((vx - vax) * (vx - vax) + (vy - 0.3) * (vy - 0.3) + (vz - vaz) * (vz - vaz)) * Math.sqrt((vx - vbx) * (vx - vbx) + (vy - 0.3) * (vy - 0.3) + (vz - vbz) * (vz - vbz)) * Math.sqrt((vx - vcx) * (vx - vcx) + (vy - vcy) * (vy - vcy) + (vz - 2.0) * (vz - 2.0)) * ((cay1 * cax1) - 0.1) - ((caz * cax2 * cay2) * 0.1);
                    if (ddd < blob)
                    {
                        t--;

                        vx += 0.25;
                        vy += 0.25;
                        vz += 0.25;

                        th = vx + 1.5707963267948966;
                        cax1 = 1.27323954 * th - 0.405284735 * th * th;

                        th = (vx * 3) + 1.5707963267948966;
                        cax2 = 1.27323954 * th - 0.405284735 * th * th;

                        var vec : Number = ddd - (Math.sqrt((vx - vax) * (vx - vax) + (vy - 0.3) * (vy - 0.3) + (vz - vaz) * (vz - vaz)) * Math.sqrt((vx - vbx) * (vx - vbx) + (vy - 0.3) * (vy - 0.3) + (vz - vbz) * (vz - vbz)) * Math.sqrt((vx - vcx) * (vx - vcx) + (vy - vcy) * (vy - vcy) + (vz - 2.0) * (vz - 2.0)) * ((cay1 * cax1) - 0.1) - ((caz * cax2 * cay2) * 0.1));
                        vec *= 0.5 / (Math.sqrt(3 * vec * vec) + 0.0001);

                        lum += (vec < 0) ? -vec : 0;

                        break;
                    }

                    t += 16;
                }

                var cr : uint = (lum + t * 0.0025) * 0xFF;
                var cg : uint = (lum + t * 0.00225) * 0xFF;
                var cb : uint = (lum + t * 0.002) * 0xFF;

                buffer[pos] = (cr << 16) | (cg << 8) | (cb);
            }

            bmd.setVector(bmd.rect, buffer);
        }
    }
}