/**
 * Copyright muta244 ( http://wonderfl.net/user/muta244 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3cQt
 */

package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 1000000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        var array:Array = [];
        var vector1:Vector.<int> = new Vector.<int>(0, false);
        var vector2:Vector.<int> = new Vector.<int>(_NUM_TIMES, false);
        var vector3:Vector.<int> = new Vector.<int>(_NUM_TIMES, true);
        
        for (var i:uint = 0; i < _NUM_TIMES; i++) {
            array[i] = 0;
            vector1[i] = 0;
        }
        
        _measure("ループのみ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                
            }
        });
        
        _measure("Array の要素に加算処理", function ():void
        {
            var e:uint;
            for (var i:uint = 0, l:uint = array.length; i < l; i++) {
                array[i]++;
            }
        });
        
        _measure("Vector.<int>(0, false) の要素に加算処理", function ():void
        {
            var e:uint;
            for (var i:uint = 0, l:uint = vector1.length; i < l; i++) {
                vector1[i]++;
            }
        });
        
        _measure("Vector.<int>(" + _NUM_TIMES + ", false) の要素に加算処理", function ():void
        {
            var e:uint;
            for (var i:uint = 0, l:uint = vector2.length; i < l; i++) {
                vector2[i]++;
            }
        });
        
        _measure("Vector.<int>(" + _NUM_TIMES + ", true) の要素に加算処理", function ():void
        {
            var e:uint;
            for (var i:uint = 0, l:uint = vector3.length; i < l; i++) {
                vector3[i]++;
            }
        });
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
