/**
 * Copyright MMMMMonchi ( http://wonderfl.net/user/MMMMMonchi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3cHEm
 */

// forked from hipisuit's Conway’s Game of Life
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.utils.ByteArray;
    
    [SWF(width="600", height="600", frameRate="24", backgroundColor="0xF5F5F5")]
    public class GameOfLifeApplication extends Sprite
    {
        private const size:Point = new Point(100, 100);
        private const black:uint = Math.random()*num;
        private var num:int=10000000;
        private const white:uint = 0x333333;
        
        private var _canvas:Bitmap;
        private var _canvasBMD:BitmapData;
        private var _drawBMD:BitmapData;
        
        private var i:int;
        private var j:int;
        private var _count:int;
        
        private var _rect:Rectangle;
        private var _pixels:ByteArray;
        
        
        public function GameOfLifeApplication()
        {
            _rect = new Rectangle(0, 0, size.x, size.y);
            
            _drawBMD = new BitmapData(size.x, size.y, false, num);
            
            _canvasBMD = new BitmapData(size.x, size.y, false, num);
            
            _canvas = new Bitmap(_canvasBMD);
            _canvas.width = stage.stageWidth;
            _canvas.height = stage.stageHeight;
            addChild(_canvas);
            
            for (i = 0; i < 2000; i++)
            {
                _canvasBMD.setPixel(Random.integer(1, size.x), Random.integer(1, size.y), black);
            }
            
            addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
        }
        
        private function _enterFrameHandler(event:Event):void
        {
            
            num=Math.random()*10000;
            _drawBMD.fillRect(_rect, white);
            
            // the i, j, size.x and size.y have an offset of 1. this to make sure no cells get stuck on the border.
            for (i = 1; i < size.x - 1; i++)
            {
                for (j = 1; j < size.y - 1; j++)
                {
                    _count = 0;
                    
                    if (_canvasBMD.getPixel(i + 1, j) == black) _count++;
                    if (_canvasBMD.getPixel(i - 1, j) == black) _count++;
                    if (_canvasBMD.getPixel(i, j - 1) == black) _count++;
                    if (_canvasBMD.getPixel(i, j + 1) == black) _count++;
                    if (_canvasBMD.getPixel(i - 1, j + 1) == black) _count++;
                    if (_canvasBMD.getPixel(i - 1, j - 1) == black) _count++;
                    if (_canvasBMD.getPixel(i + 1, j + 1) == black) _count++;
                    if (_canvasBMD.getPixel(i + 1, j - 1) == black) _count++;
                    
                    switch (_count)
                    {
                        case 3:
                        {
                            _drawBMD.setPixel(i, j, black)
                            break;
                        }
                        case 2:
                        {
                            if (_canvasBMD.getPixel(i, j) == black) _drawBMD.setPixel(i, j, black);
                            break;
                        }
                    }
                }
            }
            
            _pixels = _drawBMD.getPixels(_rect);
            _pixels.position = 0;
            _canvasBMD.setPixels(_rect, _pixels);
        }
    }
}

class Random
{
    // static interface:
    // random(); // returns a number between 0-1 exclusive.
    public static function random():Number
    {
        return Math.random();
    }
    
    // float(50); // returns a number between 0-50 exclusive
    // float(20,50); // returns a number between 20-50 exclusive
    public static function float(min:Number, max:Number = NaN):Number 
    {
        if (isNaN(max))
        {
            max = min;
            min=0;
        }
            
        return random() * (max - min) + min;
    }
    
    public static function integer(min:Number, max:Number = NaN):int 
    {
        if (isNaN(max))
        {
            max = min; 
            min = 0; 
        }
        
        max += 1;
        
        // Need to use floor instead of bit shift to work properly with negative values:
        return Math.floor(float(min, max));
    }
}
