/**
 * Copyright www0z0k ( http://wonderfl.net/user/www0z0k )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3cHE
 */

package {
    import flash.text.TextFormat;
    import flash.utils.getTimer;
    import flash.display.Shape;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    public class FlashTest extends Sprite {
        private var tf:TextField;
        private var tf2:TextField;
        private var maxHeight:int = 250;
        private var maxWidth:int = 100;
        public function FlashTest() {
            init();            
        }
        
         private function init():void{
            tf = new TextField();
            addChild(tf);
            tf.multiline = true;
            tf.height = maxHeight;
            tf.width = maxWidth;
            tf.background = true;
            tf.backgroundColor = 0xaaaaaa;
            
            var borderShape:Shape = new Shape();
            borderShape.graphics.lineStyle(1);
            borderShape.graphics.beginFill(0);
            borderShape.graphics.drawRect(0,0,maxWidth,maxHeight);
            borderShape.graphics.endFill();            
            tf.mask = borderShape;
            
            tf2 = new TextField();
            addChild(tf2);
            tf2.multiline = true;
            tf2.height = maxHeight;
            tf2.width = maxWidth;
            tf2.background = true;
            tf2.backgroundColor = 0xaaaaaa;
            tf2.x = maxWidth * 2;
                        
            var borderShape2:Shape = new Shape();
            borderShape2.graphics.lineStyle(1);
            borderShape2.graphics.beginFill(0);
            borderShape2.graphics.drawRect(0,0,maxWidth,maxHeight);
            borderShape2.graphics.endFill();
            borderShape2.x = tf2.x;
            tf2.mask = borderShape2;
            
            graphics.lineStyle(2);
            graphics.drawRect(0,0,maxWidth,maxHeight);
            graphics.drawRect(tf2.x,0,maxWidth,maxHeight);
            stage.addEventListener(MouseEvent.CLICK, onclick);            
        }
        
        private function onclick(e:MouseEvent):void{
            var currStamp:int = getTimer();//saving time for current strings
                        
            var str1:String = tf2.text; //saving contents of the right TF
            if (tf2.textHeight >= maxHeight) {/*check if it's too high. check for this TF is not so hard 
            because it's one string higher - but it has to scroll every time a word is added to reveal the bottom line*/
                str1 = (tf2.text.split('\r').splice(1, tf2.numLines - 1) as Array).join('\r');/*so here we realize that
                our saved string is too long - so we've to remove the most ancient record from the very top:
                just break (split) the text into array using carriage return symbol as a delimiter, then we use splice 
                (it removes elements from an array and returns them, first argument is the index of the first element 
                removed, second is a number of elements to be removed) - so splice returns us all our original chat strings
                [the very first is missing, though], but flex sdk doesn't recognize it as an array, so we have to use 
                coercion. so at this point we have an array of strings that we need - we only have to join it back into a
                string - of course, using a carriage return character as a separetor*/
                

            }
            tf2.text = str1 + ((str1.length == 0 ? '#' : '\r#') + currStamp);/*then we take our resulting string, 
            check if it's empty, if yes - we just add '#' before our current record, else we first add a carriage return symbol */
           
            tf2.y = maxHeight - tf2.textHeight < 0 ? 0 : maxHeight - tf2.textHeight;/*tf2 adjusts its' vertical position
            but anyway keeps it above zero*/
            tf2.scrollV = tf2.maxScrollV;//we scroll to the very bottom to reveal our current entry
            
            var str:String = tf.text; //this part is the same but without scrolling because it's 1 string shorter
            if(tf.textHeight >= maxHeight - tf.textHeight/tf.numLines) {
                str = (tf.text.split('\r').splice(1, tf.numLines - 1) as Array).join('\r');
            }
            tf.text = str + ((str.length == 0 ? '#' : '\r#') + currStamp);            
            tf.y = maxHeight - tf.textHeight < 0 ? 0 : maxHeight - tf.textHeight;
       }
    }
}