/**
 * Copyright 1031no ( http://wonderfl.net/user/1031no )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3c2r
 */

// forked from sake's PV3Dその4 前作ったらせん階段をPV3Dで。
/*
    以前、FP10の3Dで作ったのをPV3Dで。
    やっぱ、カメラが自由に動くってのはいいですよね。
*/

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.events.RendererEvent;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;

	[SWF(width="465", height="465", backgroundColor="0xffffff", frameRate="40")]
	public class PV3D_sample05 extends Sprite
	{
		private var container:Sprite;
		private var viewport:Viewport3D;
		private var scene:Scene3D;
		private var camera:Camera3D;
		private var render:BasicRenderEngine;
		private var rootNode:DisplayObject3D
		private var cube:Cube;
		private var xx:Number=0;
		private var ss:Number=0;
		private const k:Number=15;

		public function PV3D_sample05()
		{
			container=new Sprite();
			addChild(container);
			container.x=stage.stageWidth / 2;
			container.y=stage.stageHeight / 2;
			viewport=new Viewport3D(0, 0, true, true);
			scene=new Scene3D();
			camera=new Camera3D();
			render=new BasicRenderEngine();
			rootNode=scene.addChild(new DisplayObject3D("rootNode"));

			addChild(viewport);
			camera.zoom=10;
			camera.focus=30;
			camera.y=900;
			camera.x=-400;
			camera.target=DisplayObject3D.ZERO;
			addEventListener(Event.ENTER_FRAME, onFrame);

			var boxcolor:Array=new Array();
			for(var i:int=0; i < 6; i++) boxcolor[i]=new ColorMaterial(Math.floor(Math.random() * 0xFFFFFF), 0.5);
			var materials:MaterialsList=new MaterialsList({front:boxcolor[0], back:boxcolor[1], right:boxcolor[2], left:boxcolor[3], top:boxcolor[4], bottom:boxcolor[5]});
			cube=new Cube(materials, 100, 100, 100);
			rootNode.addChild(cube);

			var h:int=-50;
			var s:Number=0;
			for(var i:int=0; i < 500; i++)
			{
				var p:Plane=new Plane(new ColorMaterial(0x00ff00, 0.5, true), 100, 100);
				p.material.doubleSided=true;
				p.rotationX=90;
				p.y = h;
				h += 10;
				p.x = 1.1 * s * Math.cos(s * Math.PI / 180);
				p.z = 1.1 * s * Math.sin(s * Math.PI / 180);
				s += 20;
				rootNode.addChild(p);
			}
		}

		public function onFrame(e:Event):void
		{
			cube.z=1.1 * ss * Math.sin(ss * Math.PI / 180);
			cube.x=1.1 * ss * Math.cos(ss * Math.PI / 180);
			cube.y=10 * (-1 * (2 * k - 1 + 2 * Math.sqrt(k * k - k)) * (xx - k + Math.sqrt(k * k - k) - Math.floor(xx)) * (xx - k + Math.sqrt(k * k - k) - Math.floor(xx)) + k + Math.floor(xx));
			xx+=0.1;
			ss+=2;

			var ct:DisplayObject3D=camera.target;
			ct.x=cube.x;

			render.renderScene(scene, camera, viewport);
		}
	}
}