/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3bdK
 */

package {
    import flash.display.*;
    public class FlashTest extends Sprite {
        
        private var YAWA:Object;
        
        public function FlashTest() {
            stage.scaleMode = StageScaleMode.NO_SCALE
            stage.align = StageAlign.TOP_LEFT
            useYAWA(onReady);
        }
        
        private function onReady(o:Object):void {
            YAWA = o;
            YAWA.requestCodeRanking(onCodeRanking, YAWA.DAYS_1DAY, YAWA.ORDER_PV);
        }
        
        private function onCodeRanking(data:Array):void {
            CodeView.addHeading(this);
            for (var i:int = 0; i < 9 && i < data.length; i++) {
                var cv:CodeView = new CodeView(data[i]);
                cv.x = (i % 3) * 261 + 10;
                cv.y = Math.floor(i / 3) * 223 + 59;
                addChild(cv);
            }
        }
        
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.net.*;
import flash.text.*;
import flash.system.*;

internal class CodeView extends Sprite {
    
    private static const context:LoaderContext = new LoaderContext(true);
    private static const pvFormat:TextFormat = new TextFormat('Arial', 24, 0xcc3333, true, null, null, null, null, TextFormatAlign.RIGHT);
    private static const titleFormat:TextFormat = new TextFormat('Arial', 18.0667, 0xcc0000, true, null, true);
    private static const nameFormat:TextFormat = new TextFormat('Arial', 13, 0xff0000, null, null, true);
    private static const base:BitmapData = prepareBase();
    private static const title:BitmapData = prepareTitle();
    
    private static function prepareBase():BitmapData {
        var bd:BitmapData = new BitmapData(207, 176, false, 0xffffff);
        var l:Loader = new Loader();
        l.contentLoaderInfo.addEventListener(Event.COMPLETE, function (e:Event):void {
            bd.draw(l);
        });
        l.load(new URLRequest('http://i.imgur.com/uC7o6.png'), context);
        return bd;
    }
    
    private static function prepareTitle():BitmapData {
        var d:Date = new Date();
        var tf:TextField = new TextField();
        tf.defaultTextFormat = titleFormat;
        tf.text = 'flash on ' + d.fullYear + '-' + (d.month + 1) + '-' + d.date;
        tf.width = 205;
        var bd:BitmapData = new BitmapData(205, 25, false, 0xffffff);
        bd.draw(tf);
        bd.copyPixels(bd, new Rectangle(0, 21, 205, 1), new Point(0, 22));
        return bd;
    }
    
    public static function addHeading(c:DisplayObjectContainer):void {
        var l:Loader = new Loader();
        l.load(new URLRequest('http://i.imgur.com/cBhMH.png'), context);
        l.x = 10;
        l.y = 10;
        c.addChild(l);
    }
    
    public function CodeView(o:Object) {
        var tf:TextField;
        var b:Bitmap;
        
        b = new Bitmap(base);
        addChild(b);
        
        b = new Bitmap(title);
        b.x = 1;
        b.y = 106;
        addChild(b);
        
        tf = new TextField();
        tf.mouseEnabled = false;
        tf.defaultTextFormat = pvFormat;
        tf.text = o.code.pv;
        tf.x = 102;
        tf.y = 67;
        addChild(tf);
        
        tf = new TextField();
        tf.mouseEnabled = false;
        tf.defaultTextFormat = nameFormat;
        tf.text = o.user.name;
        tf.x = 19;
        tf.y = 133;
        addChild(tf);
    }
    
}

function useYAWA(onReady:Function, swfurl:String="http://swf.wonderfl.net/swf/usercode/8/8f/8f46/8f46608d59b94c39bf42b94a89c1819f9e3bce61.swf") : void {
    var loader:Loader = new Loader();
    loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event) : void { onReady(e.target.content); });
    loader.load(new URLRequest(swfurl + "?t=" + String(int(new Date().time))));
}