/**
 * Copyright hacker_lra4mj5w ( http://wonderfl.net/user/hacker_lra4mj5w )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3bFV
 */

// forked from szeremeta's forked from: flash on 2010-1-9
// forked from mirkofresa's flash on 2010-1-9
﻿package 
{
    import flash.display.DisplayObject;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import com.greensock.easing.Strong;
    import gs.TweenLite;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.view.BasicView;
    
    /**
     * ...
     * @author Charlie Schulze, charlie[at]woveninteractive[dot]com
     */
    
    public class Main extends BasicView 
    {
        protected var planes:Array = [];
        protected var numItems:Number = 13;
        protected var radius:Number = 304;
        protected var currentItem:Number = 0;
        
        protected var mat:ColorMaterial;
        protected var planesHolder:DisplayObject3D;
        protected var rightBtn:Sprite;
        protected var leftBtn:Sprite;
        
        public function Main():void 
        {
            super();
            init();
        }
        protected function init():void 
        {
            createChildren();
            createButtons();
            commitProperties();
            startRendering();
        }
        protected function createChildren():void 
        {
            
            planesHolder = new DisplayObject3D();
            
            //Create Material
            //mat             = new WireframeMaterial(0xFFFF00    );
            //mat.smooth         = true;
            //mat.doubleSided = false;
            
            for (var i:int = 0; i < numItems; i++) 
            {
                mat = new ColorMaterial(Math.random() * 0xFFFFFF);
                var plane:Plane = new Plane(mat, 150, 234);
                planes.push(plane);
                
                //Add plane to the scene
                planesHolder.addChild(plane);
            }
            scene.addChild(planesHolder);
        }
        
        protected function commitProperties():void 
        { 
            //Set properties of our planes
            for (var i:int = 0; i < planes.length; i++) 
            {
                var angle:Number     = Math.PI * 2 / numItems * i;
                var plane:Plane     = planes[i];
                var calc:Number     = 0;
                //if( i > currentItem ) calc = calc * -1;
                
                //else if( i == currentItem ) calc = 0;
                plane.x             = calc + Math.cos(angle) * radius;
                plane.z             = Math.sin(angle) * radius;
                plane.rotationY     = -360 / numItems * i - 90;
            }
            
            //Adjust camera
            camera.y = 50;
            camera.focus = 40;
            camera.zoom = 15;
            //camera.rotationY = 180;
            //camera.rotationX = 180;
            
            
            
            //Rotate once
            rotate();
        }

        //Rotates the carousel
        protected function rotate():void 
        {
            var rotateTo:Number = (-360 / numItems) * currentItem + 90;
            TweenLite.to(planesHolder, 1, { rotationY:rotateTo, ease: Strong.easeOut } );
        }
        
        /*
         * Everything below this point is just for creating / setting events for 
         * controlling the carousel. 
         */

        protected function createButtons():void 
        {
            //Create Buttons
            rightBtn = createButton();
            leftBtn = createButton();
                
            addChild(leftBtn);
            addChild(rightBtn);
            
            //Add button listeners
            rightBtn.buttonMode = true;
            leftBtn.buttonMode = true;
            rightBtn.addEventListener(MouseEvent.CLICK, buttonClick);
            leftBtn.addEventListener(MouseEvent.CLICK, buttonClick);
                        
            //Place buttons on stage
            rightBtn.x             = stage.stageWidth - 120;
            leftBtn.x             = 100;
            rightBtn.y             =  stage.stageHeight -30;
            leftBtn.y             =  (stage.stageHeight -30) + 20;
            leftBtn.rotation     = 180;
        }
        
        //Button actions
        protected function buttonClick(evt:MouseEvent):void 
        {
            switch (evt.target)
            {
                case rightBtn:
                currentItem --;
                break;
                
                case leftBtn:
                currentItem ++;
                break;
            }
            rotate();
        }
        
        //Creates a simple arrow shape / returns the sprite
        protected function createButton():Sprite
        {
            var btn:Sprite = new Sprite();
            
            btn.graphics.beginFill(0x333333);
            btn.graphics.moveTo(0, 0);
            btn.graphics.lineTo(0, 20);
            btn.graphics.lineTo(10, 10);
            btn.graphics.lineTo(0, 0);
            btn.graphics.endFill();
            return btn;
        }
    }
}