/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3abI
 */

// forked from sakusan393's モアレっぽい感じ
// 音にあわせて自動で変化するようにしてみた。
// 拍はbeinteractive先生のBeatTimerを使ってます。
// 曲は友人が作った曲を拝借（一応フリー音源ではありません)
// GCしまくりですね。。。

//　友人がこの雰囲気に会いそうな曲を書いてくれたので差し替え。
// 友人サイトは：http://araoto.com

package  {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BevelFilter;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.net.URLRequest;
	import net.hires.debug.Stats;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	
	[SWF(backgroundColor="0", frameRate="30", width="465", height="465")]
	
	/**
	 * ...
	 * @author 393
	 */
	public class YuraYura extends Sprite{
		private var _bmd:BitmapData = new BitmapData(465, 465,false,0);
		private var _bm:Bitmap = new Bitmap(_bmd);
		private var _phase:int;
		private var _gain:int;
		private var _sound:Sound;
		private var _soundChannel:SoundChannel;
		private var _beatTimer:BeatTimer;
		private var _point:Point = new Point();
		private var _speedX:int;
		private var _speedY:int;
		private var _isOnBeat:Boolean;
		private var _effects:Array = [Expo.easeIn, Expo.easeOut
										,Circ.easeIn, Circ.easeOut
										,Sine.easeIn, Sine.easeOut
										,Quint.easeIn, Quint.easeOut
										,Linear.linear];
										
		private var _xArray:Array = [23, 27, 48, 49, 54, 58, 95, 101, 103, 105, 107, 108, 109, 133, 134, 135, 150, 154, 159, 160, 162, 179, 217, 219, 240, 246, 259, 261, 264, 266, 267, 268, 269, 270, 283, 288, 299, 301, 303, 322, 355, 357, 358, 363, 386, 463, 457, 404, 390];
		
		private var _colorTransForm:ColorTransform = new ColorTransform(0.99, 0.99, 0.99);
		private var _filter:BlurFilter = new BlurFilter(15, 15, 1);
		
		public function YuraYura() {
			addChild(_bm);
			addChild(new Stats());
			
			addEventListener(Event.ENTER_FRAME, timerHandler);

			_beatTimer = new BeatTimer();		
			_sound = new Sound();
			_sound.load(new URLRequest("http://393.bz/data/moareBPM120.mp3"));
			_sound.addEventListener(Event.COMPLETE, loadCompleteHadler);
		};
		
		private function loadCompleteHadler(e:Event):void {
			_sound.removeEventListener(Event.COMPLETE, loadCompleteHadler);
			soundStart();
		}
		
		private function soundStart():void {
			_soundChannel = _sound.play(0);
			_beatTimer.start(120);
			_soundChannel.addEventListener(Event.SOUND_COMPLETE, soundCompleteHandler );
		}
		
		private function soundCompleteHandler(e:Event):void {
			_soundChannel.removeEventListener(Event.SOUND_COMPLETE, soundCompleteHandler );
			soundStart();
		}
		private function timerHandler(e:Event):void {
			_beatTimer.update();
			if ((_beatTimer.beatPosition | 0) % 4 == 0) {
				if (!_isOnBeat) {
					_isOnBeat = true;
					var endX:int = _xArray[(0 | Math.random() * _xArray.length)];
					var endY:int = (0 | Math.random() * 465);
					BetweenAS3.to(_point, { x:endX, y:endY },  .5, _effects[(0 | Math.random() * _effects.length)]).play();
					
				}
			}else {
				if(Math.random() > 0.5)	_isOnBeat = false;
			}
			
			_gain += (((_point.y - (stage.stageHeight / 2))) - _gain) * 0.1;
			
			var substract:int = ((_point.x - stage.stageWidth/2)/stage.stageWidth) * 200+2;
			_phase -= substract;
			if (_phase >= 0) _phase -= 360;
			if (_phase <= -360) _phase = 360 + _phase;
			
			_bmd.colorTransform(_bmd.rect, _colorTransForm);
			_bmd.applyFilter(_bmd, _bmd.rect, _bmd.rect.topLeft, _filter);
			_bmd.lock();
			//_bmd.fillRect(_bmd.rect, 0);
			drawLine(0+_phase,_gain,0xFF0000);
			drawLine(1+_phase+3*_phase-120,_gain,0x00FF00);
			drawLine(2 + _phase + 6 * _phase-240, _gain, 0x0000FF);
			_bmd.unlock();
		}
		private function drawLine(phase:int, gain:int, color:int):void {
			for (var i:int = phase; i < 465; i += 3) {
				var yMax:int = Math.sin(Math.PI / (_point.x/360) * (phase + i)) * gain+465 / 2;
				for (var j:int = 0; j < yMax; j++) {
					_bmd.setPixel(i, j, color);
				}
			}
		}
	}
}
import flash.utils.getTimer;
class BeatTimer
{
	public function BeatTimer()
	{
	}
	
	private var _bpm:Number;
	private var _startTime:uint;
	private var _beatPosition:Number;
	private var _phase:Number;
	private var _isOnBeat:Boolean = false;
	
	public function get bpm():Number
	{
		return _bpm;
	}
	
	public function get beatPosition():Number
	{
		return _beatPosition;
	}
	
	public function get phase():Number
	{
		return _phase;
	}
	
	public function get isOnBeat():Boolean
	{
		return _isOnBeat;
	}
	
	public function start(bpm:Number):void
	{
		_bpm = bpm;
		_startTime = getTimer();
		update();
	}
	
	public function update():void
	{
		var currentTime:uint = getTimer();
		var beatInterval:Number = (60 * 1000) / _bpm;
		var oldPosition:Number = _beatPosition;
		
		_beatPosition = (currentTime - _startTime) / beatInterval;
		_phase = _beatPosition - int(_beatPosition);
		_isOnBeat = int(oldPosition) != int(_beatPosition);
	}
}