/**
 * Copyright keno42 ( http://wonderfl.net/user/keno42 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3aRd
 */

// 私用プログラム 画像の明るさと彩度、色相を表示

package {
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.ui.*;
    import flash.net.*;
    import flash.utils.*;
    public class FlashTest extends Sprite {
        private var label_url:TextField = new TextField();
        private var input:TextField = new TextField();
        private var guide:TextField = new TextField();
        private var loader:Loader;
        private var bmp:Bitmap = new Bitmap();
        private var graph:Sprite = new Sprite();
        
        public function FlashTest() {
            // write as3 code here..
            
            // place texts
            label_url.text = "Image URL";
            label_url.autoSize = "left";
            addChild(label_url);
            input.border = true;
            input.type = "input";
            addChild(input);
            input.height = 20;
            input.x = label_url.textWidth + 5;
            input.width = 465 - 5 - input.x;
            input.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            guide.autoSize = "left";
            guide.y = label_url.y + 25;
            setGuideText(0);
            addChild(guide);
            addChild(bmp);
            bmp.y = guide.y + 25;
            addChild(graph);
            graph.x = 5;
            graph.y = bmp.y + 5;
        }
        private function setGuideText(type:int):void{
            var str:String;
            switch(type){
                case 0: str = "input image's url and hit enter";
                    break;
                case 1: str = "loading...";
                    break;
                case 2: str = "load complete. analyzing...";
                    break;
                case 3: str = "load failed. input correct url again.";
                    break;
                case 4: str = "analysis finished. you can input another image url";
                    break;
            }
            guide.text = str;
        }
        private function onKeyDown(e:KeyboardEvent):void{
            if(e.keyCode == Keyboard.ENTER){
                if( loader == null){
                    loader = new Loader();
                    loader.load(new URLRequest(input.text));
                    loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete, false, 0, true);
                    loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIoError, false, 0, true);
                    setGuideText(1);
                }
            }
        }
        private function onComplete(e:Event):void{
            var temp:ByteArray = loader.contentLoaderInfo.bytes;
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete2, false, 0, true);
            loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIoError, false, 0, true);
            loader.loadBytes(temp);
        }
        private function onComplete2(e:Event):void{
            setGuideText(2);
            var bmpData:BitmapData = new BitmapData(loader.width, loader.height, true, 0x0);
            bmpData.draw(loader.content);
            bmp.bitmapData = bmpData;
            analyze(bmpData);
        }
        private function onIoError(e:Event):void{
            setGuideText(3);
            loader = null;
        }
        private function analyze(bmp:BitmapData):void{
            var temp:ByteArray = bmp.getPixels(bmp.rect);
            var v:Array = new Array(256); // it's different from v of hsv, but brightness of grayscale
            var s:Array = new Array(256);
            var h:Array = new Array(360);
            var i:int;
            var maxH:int;
            for( i = 0; i < 256; i++){
                v[i] = s[i] = h[i] = 0;
            }
            for( ; i < 360; i++ ){
                h[i] = 0;
            }
            for( i = 0; i < temp.length; i+=4 ){
                var tempV:int = (151 * temp[i+1] + 78 * temp[i+2] + 27 * temp[i+3]) >> 8;
                v[tempV]++;
                var max:int = (temp[i+1]>temp[i+2])?temp[i+1]:temp[i+2];
                max = (max>temp[i+3])?max:temp[i+3];
                var min:int = (temp[i+1]<temp[i+2])?temp[i+1]:temp[i+2];
                min = (min<temp[i+3])?min:temp[i+3];
                var tempS:int = max - min;
                s[tempS]++;
                var tempH:int;
                if( tempS != 0 ){
                    if( max == temp[i+1] ){
                        tempH = 60 * (temp[i+2] - temp[i+3]) / tempS;
                    } else if ( max == temp[i+2] ){
                        tempH = 120 + 60 * (temp[i+3] - temp[i+1]) / tempS;
                    } else {
                        tempH = 240 + 60 * (temp[i+1] - temp[i+2]) / tempS;
                    }
                    if ( tempH < 0 ) tempH += 360;
                    h[tempH]++;
                    maxH = (maxH>h[tempH])?maxH:h[tempH];
                }
            }
            var pixelNum:Number = temp.length / 4;
            var a:Number = 256 / pixelNum;
            var st:Number = 0;
            graph.graphics.clear();
            graph.graphics.beginFill(0xFFFFFF, 0.5);
            graph.graphics.lineStyle(0, 0x0);
            graph.graphics.drawRect(-1, -1, 258, 258);
            graph.graphics.drawRect(-1, 263, 361, 101);
            graph.graphics.endFill();
            graph.graphics.lineStyle(0, 0x888888);
            graph.graphics.moveTo(1, 128);
            graph.graphics.lineTo(255, 128);
            graph.graphics.moveTo(128, 1);
            graph.graphics.lineTo(128, 255);
            for( i = 60; i <= 300; i+= 60 ){
                graph.graphics.moveTo(i, 264);
                graph.graphics.lineTo(i, 363);
            }
            
            // brightness
            graph.graphics.lineStyle(0, 0x0);
            graph.graphics.moveTo(0, 256);
            for( i = 0; i < 256; i++){
                graph.graphics.lineStyle(0, i * 0x10101);
                st += v[i];
                graph.graphics.lineTo(i,256 - Math.floor(a * st));
            }
            
            // saturation
            st = 0;
            graph.graphics.lineStyle(0, 0x000000);
            graph.graphics.moveTo(0, 256);
            for( i = 0; i < 256; i++){
                graph.graphics.lineStyle(0, i << 16);
                st += s[i];
                graph.graphics.lineTo(i,256 - Math.floor(a * st));
            }
            // hue
            a = 100 / maxH;
            graph.graphics.lineStyle(0,0,0);
            for( i = 0; i < 60; i++ ){
                graph.graphics.beginFill(0xFF0000 | (int(0xFF * i/60)<<8));
                graph.graphics.drawRect(i, 364, 1, - a * h[i]);
            }
            for( ; i < 120; i++ ){
                graph.graphics.beginFill(0x00FF00 | (int(0xFF * (120-i)/60)<<16));
                graph.graphics.drawRect(i, 364, 1, - a * h[i]);
            }
            for( ; i < 180; i++ ){
                graph.graphics.beginFill(0x00FF00 | (int(0xFF * (i-120)/60)<<0));
                graph.graphics.drawRect(i, 364, 1, - a * h[i]);
            }
            for( ; i < 240; i++ ){
                graph.graphics.beginFill(0x0000FF | (int(0xFF * (240-i)/60)<<8));
                graph.graphics.drawRect(i, 364, 1, - a * h[i]);
            }
            for( ; i < 300; i++ ){
                graph.graphics.beginFill(0x0000FF | (int(0xFF * (i-240)/60)<<16));
                graph.graphics.drawRect(i, 364, 1, - a * h[i]);
            }
            for( ; i < 360; i++ ){
                graph.graphics.beginFill(0xFF0000 | (int(0xFF * (360-i)/60)<<0));
                graph.graphics.drawRect(i, 364, 1, - a * h[i]);
            }
            graph.graphics.endFill();
            loader = null;
            setGuideText(4);
            
        }
    }
}