/**
 * Copyright Etienne.Verhote ( http://wonderfl.net/user/Etienne.Verhote )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3a7D
 */

// forked from jerryrom's Grass2
// forked from jerryrom's Grass
// forked from jerryrom's Curtain
// forked from jerryrom's Corn
// forked from jerryrom's Pole
// forked from jerryrom's Waterfall
// forked from Hasufel's Space Comet
package {

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    
    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=60)]
    public class Grass2 extends Sprite {
        private var cvs:BitmapData;     
        private var particles:Array = [];
        private var h:int = stage.stageHeight;
        private var w:int = stage.stageWidth;
        private var c:uint = 0xff5FB404;
        private var cs:Array = [0xffF70723, 0xffb3071b, 0xec5668, 0xfffa2d45, 0xff870413];
        private var blur:BlurFilter;
        private var sign:int = 1;

        public function Grass2(){
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            graphics.beginFill(0x000000);
                graphics.drawRect(0, 0, 465, 465);
                graphics.endFill();
                
            blur = new BlurFilter(0,5,1);
            cvs = new BitmapData(w,h,true,0);
            addChild(new Bitmap(cvs)) as Bitmap;
            addEventListener(Event.ENTER_FRAME,update);
        }
        
        private function update(e:Event):void{
            cvs.applyFilter(cvs,cvs.rect,new Point(0,0),blur);
            cvs.lock();
            var n:int = particles.length;
            while(n--) {
                var p:Particle = particles[n];
                p.vx *= 1.01;
                p.vy *= 1.01;
                p.x+=p.vx;
                p.y+=p.vy;
                var c1:uint = uint(0xff * p.y /465) << 24 | 0x00ffffff;
                cvs.setPixel32(p.x, p.y, p.c&c1);
                if (p.y<0 || h<p.y || p.x<0 || p.x>w){
                    particles.splice(n,1);
                }
            }
            cvs.unlock();
            n = 20;
            
            while (n--) {
                createParticle(Math.random()*w, h, cs[n%5] , 2*(Math.random()-0.5), -2*(Math.random()),true);
            }
        }

        private function createParticle(xx:Number, yy:Number, c:int, vx:Number, vy:Number, type:Boolean):void {
            var p:Particle = new Particle();
            p.x = xx;
            p.y = yy;
            p.vx = vx;
            p.vy = vy;
            p.c = c;
            particles.push(p);
        }
    }
}

class Particle {
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var c:uint;
}