/**
 * Copyright x10der ( http://wonderfl.net/user/x10der )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Zer
 */

package {
    import flash.events.ErrorEvent;
    

    import flash.display.Bitmap;

    import flash.display.Loader;

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.net.URLRequest;

    

    /**

     * ...

     * @author ami hanya ami@orn.co.il

     */

    public class FlashTest extends Sprite

    {

        private var nowbitmap:Bitmap;

        private var piecesArray:Array = new Array();

        private var horizontalPieces:Number = 5;

        private var verticalPieces:Number = 4;

        private var imageWidth:Number;

        private var imageHeight:Number;

        private var pieceWidth:Number;

        private var pieceHeight:Number;

        private var showGuid:Boolean = true;

        private var showGuidCon:Sprite;

        private var regularCon:Sprite;

        

        public function FlashTest():void

        {

            if (stage)

                init();

            else

                addEventListener(Event.ADDED_TO_STAGE, init);

        }

        

        private function init(e:Event = null):void

        {

            removeEventListener(Event.ADDED_TO_STAGE, init);

            var imageLoader:Loader = new Loader();

            var image:URLRequest = new URLRequest("http://wonderfl.net/img/qa/qa_question_en.png");

            imageLoader.addEventListener(ErrorEvent.ERROR, onError);
            imageLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, imageLoad);

            imageLoader.load(image);

        

        }

        private function onError(e:ErrorEvent):void
        {
            trace(e.text);
        }

        

        private function imageLoad(e:Event = null):void

        {
            trace("all good");
            nowbitmap = e.target.content as Bitmap;

            imageWidth = nowbitmap.width;

            imageHeight = nowbitmap.height;

            pieceWidth = Math.round(imageWidth / horizontalPieces);

            pieceHeight = Math.round(imageHeight / verticalPieces);

            if (showGuid)

            {

                showGuidCon = new Sprite

                addChild(showGuidCon);

            }

            regularCon = new Sprite

            addChild(regularCon);

            for (var i:uint = 0; i < horizontalPieces; i++)

            {

                piecesArray[i] = new Array();

                for (var j:uint = 0; j < verticalPieces; j++)

                {

                    piecesArray[i][j] = new Object();

                    piecesArray[i][j].right = Math.floor(Math.random() * 2);

                    piecesArray[i][j].down = Math.floor(Math.random() * 2);

                    if (j > 0)

                    {

                        piecesArray[i][j].up = 1 - piecesArray[i][j - 1].down;

                    }

                    if (i > 0)

                    {

                        piecesArray[i][j].left = 1 - piecesArray[i - 1][j].right;

                    }

                    var n:Number = j + i * verticalPieces;

                    if (showGuid)

                    {

                        var pieceGuid:Piece = new Piece

                        showGuidCon.addChild(pieceGuid);

                        pieceGuid.init({image: nowbitmap.bitmapData, i: i, j: j, tileObj: piecesArray[i][j], horizontalPieces: horizontalPieces, verticalPieces: verticalPieces, crop: {x: i * pieceWidth, y: j * pieceHeight, width: pieceWidth, height: pieceHeight}, x: i * pieceWidth + i, y: j * pieceHeight + j, width: pieceWidth, height: pieceHeight, draggable: false});

                    }

                    var piece:Piece = new Piece

                    regularCon.addChild(piece);

                    piece.init({image: nowbitmap.bitmapData, i: i, j: j, tileObj: piecesArray[i][j], horizontalPieces: horizontalPieces, verticalPieces: verticalPieces, crop: {x: i * pieceWidth, y: j * pieceHeight, width: pieceWidth, height: pieceHeight}, x: i * pieceWidth + i, y: j * pieceHeight + j, width: pieceWidth, height: pieceHeight, draggable: true});

                    

                }

            }

        }

    

    }
}
 


    import com.greensock.easing.*;

    import com.greensock.*;

    import flash.display.Bitmap;

    import flash.display.Graphics;

    import flash.display.Shape;

    import flash.display.Sprite;

    import flash.events.MouseEvent;

    

    /**

     * ...

     * @author ami hanya ami@orn.co.il

     */

    class Piece extends Sprite

    {

        private var image:Bitmap;

        private var obj:Object

        private var gap:Number = 20;

        

        public function Piece()

        {

        

        }

        

        public function init($obj:Object):void

        {

            obj = $obj;

            x = obj.x;

            y = obj.y;

            var offsetX:Number = obj.width * obj.i;

            var offsetY:Number = obj.height * obj.j;

            var x8:Number = Math.round(obj.width / 8);

            var y8:Number = Math.round(obj.height / 8);

            var i:Number = obj.i;

            var j:Number = obj.j;

            var tileObj:Object = obj.tileObj;

            var s:Shape = new Shape

            var context:Graphics = s.graphics;

            

            if (obj.draggable)

            {

                context.lineStyle(2, 0, 1, true, "round");

                context.beginBitmapFill(obj.image);

                

            }

            else

            {

                context.lineStyle(2, 0, .5, true, "round");

                context.beginFill(0xFFFFFF, .5);

                

            }

            context.moveTo(offsetX, offsetY);

            s.x = -offsetX;

            s.y = -offsetY;

            

            if (j != 0)

            {

                context.lineTo(offsetX + 3 * x8, offsetY);

                if (tileObj.up == 1)

                {

                    context.curveTo(offsetX + 2 * x8, offsetY - 2 * y8, offsetX + 4 * x8, offsetY - 2 * y8);

                    context.curveTo(offsetX + 6 * x8, offsetY - 2 * y8, offsetX + 5 * x8, offsetY);

                }

                else

                {

                    context.curveTo(offsetX + 2 * x8, offsetY + 2 * y8, offsetX + 4 * x8, offsetY + 2 * y8);

                    context.curveTo(offsetX + 6 * x8, offsetY + 2 * y8, offsetX + 5 * x8, offsetY);

                }

            }

            context.lineTo(offsetX + 8 * x8, offsetY);

            if (i != obj.horizontalPieces - 1)

            {

                context.lineTo(offsetX + 8 * x8, offsetY + 3 * y8);

                if (tileObj.right == 1)

                {

                    context.curveTo(offsetX + 10 * x8, offsetY + 2 * y8, offsetX + 10 * x8, offsetY + 4 * y8);

                    context.curveTo(offsetX + 10 * x8, offsetY + 6 * y8, offsetX + 8 * x8, offsetY + 5 * y8);

                }

                else

                {

                    context.curveTo(offsetX + 6 * x8, offsetY + 2 * y8, offsetX + 6 * x8, offsetY + 4 * y8);

                    context.curveTo(offsetX + 6 * x8, offsetY + 6 * y8, offsetX + 8 * x8, offsetY + 5 * y8);

                }

            }

            context.lineTo(offsetX + 8 * x8, offsetY + 8 * y8);

            if (j != obj.verticalPieces - 1)

            {

                context.lineTo(offsetX + 5 * x8, offsetY + 8 * y8);

                if (tileObj.down == 1)

                {

                    context.curveTo(offsetX + 6 * x8, offsetY + 10 * y8, offsetX + 4 * x8, offsetY + 10 * y8);

                    context.curveTo(offsetX + 2 * x8, offsetY + 10 * y8, offsetX + 3 * x8, offsetY + 8 * y8);

                }

                else

                {

                    context.curveTo(offsetX + 6 * x8, offsetY + 6 * y8, offsetX + 4 * x8, offsetY + 6 * y8);

                    context.curveTo(offsetX + 2 * x8, offsetY + 6 * y8, offsetX + 3 * x8, offsetY + 8 * y8);

                }

            }

            context.lineTo(offsetX, offsetY + 8 * y8);

            if (i != 0)

            {

                context.lineTo(offsetX, offsetY + 5 * y8);

                if (tileObj.left == 1)

                {

                    context.curveTo(offsetX - 2 * x8, offsetY + 6 * y8, offsetX - 2 * x8, offsetY + 4 * y8);

                    context.curveTo(offsetX - 2 * x8, offsetY + 2 * y8, offsetX, offsetY + 3 * y8);

                }

                else

                {

                    context.curveTo(offsetX + 2 * x8, offsetY + 6 * y8, offsetX + 2 * x8, offsetY + 4 * y8);

                    context.curveTo(offsetX + 2 * x8, offsetY + 2 * y8, offsetX, offsetY + 3 * y8);

                }

            }

            addChild(s)

            if (obj.draggable)

            {

                TweenMax.to(this, .5, {x: Math.round(Math.random() * (obj.image.width - obj.width)), y: Math.round(Math.random() * (obj.image.height - obj.height)), delay: 1 + Math.random(), ease: Back.easeInOut, onComplete: addMouseEvent});

            }

            else

            {

                mouseChildren = false;

                mouseEnabled = false;

            }

        

        }

        

        private function addMouseEvent():void

        {

            if (obj.draggable)

            {

                buttonMode = true;

                addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);

            }

        }

        

        private function mouseDown(e:MouseEvent):void

        {

            startDrag();

            parent.setChildIndex(this, parent.numChildren - 1);

            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);

        

        }

        

        private function mouseUp(e:MouseEvent):void

        {

            stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUp);

            stopDrag();

            x = Math.round(x);

            y = Math.round(y);

            if (x < obj.x + gap / 2 && x > obj.x - gap / 2 && y < obj.y + gap / 2 && y > obj.y - gap / 2)

            {

                x = obj.x;

                y = obj.y;

                mouseEnabled = false;

                mouseChildren = false;

                parent.setChildIndex(this, 0);

            }

        }

    

    }



