/**
 * Copyright yotsu42keisuke ( http://wonderfl.net/user/yotsu42keisuke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3ZS0
 */

// forked from abakane's Smoke 煙の表現
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    [SWF(width=465, height=465, backgroundColor=0x0, frameRate=30)]
    
    //perlinNoiseで作ったBitmapDataをcopyPixelsで丸く切り取ってます
    //そのまま使うと重いすね
    public class Smoke extends Sprite
    {
        private var px:Number;
        private var py:Number;
        private var b:Boolean;
        
        public function Smoke()
        {
            if( !stage ) this.addEventListener( Event.ADDED_TO_STAGE, init);//
            else init();//
            Wonderfl.capture_delay(5);
        }
        
        private function init( e:Event=null ):void
        {
            this.removeEventListener( Event.ADDED_TO_STAGE, init);//
            stage.addEventListener( MouseEvent.MOUSE_DOWN, onMouseDown);//
        }
        
        private function onMouseDown( e:MouseEvent ):void
        {
            px = mouseX;
            py = mouseY;
            stage.addEventListener( MouseEvent.MOUSE_UP, onMouseUp);//
            stage.addEventListener( MouseEvent.MOUSE_MOVE, onMouseMove);//
        }
        
        private function onMouseUp( e:MouseEvent ):void
        {
            stage.removeEventListener( MouseEvent.MOUSE_UP, onMouseUp);//
            stage.removeEventListener( MouseEvent.MOUSE_MOVE, onMouseMove);//
        }
        
        private function onMouseMove( e:MouseEvent ):void
        {
            b = !b;
            if( b ) return;
            var fog:Fog = new Fog( mouseX, mouseY, px-mouseX, py-mouseY);
            addChild( fog );
            px = mouseX;
            py = mouseY;
        }
        
    }
}

import flash.display.*;
import flash.geom.*;

import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.*;

class Fog extends Sprite{
    private const L:Number = 30;//半径
    private var self:Fog;
    
    function Fog( _x:Number, _y:Number, _vx:Number, _vy:Number)
    {
        this.self = this;
        var bmp:Bitmap;
        var bmpd:BitmapData = new BitmapData( L, L, true, 0x0);
        var _bmpd:BitmapData = bmpd.clone();
        var __bmpd:BitmapData = bmpd.clone();
        var m:Matrix = new Matrix();
        var s:Sprite = new Sprite();
        
        _bmpd.perlinNoise( L*0.5, L*0.5, 1, Math.random()*100 | 0, false, true, 0x0, true, null);
        
        m.createGradientBox( L, L, 0, -L*0.5, -L*0.5);
        s.graphics.beginGradientFill( GradientType.RADIAL, [0xFFFFFF, 0xFFFFFF, 0xFFFFFF], [1, 0.7, 0], [0x0, 0x99, 0xFF], m, SpreadMethod.PAD);
        s.graphics.drawCircle( 0, 0, L*0.5);
        s.graphics.endFill();
        m = new Matrix();
        m.translate( L*0.5, L*0.5);
        __bmpd.draw( s, m);
        
        bmpd.copyPixels( _bmpd, new Rectangle(0, 0, L, L), new Point(0,0), __bmpd, new Point(0,0), true);
        _bmpd.dispose();
        __bmpd.dispose();
        s = null;
        bmp = new Bitmap(bmpd);
        bmp.scaleX = bmp.scaleY = 2;
        bmp.x = bmp.y = -L;
        addChild( bmp );
        
        var r:Number = Math.atan2( _vy, _vx);
        r += (0.5 - Math.random() )*Math.PI/9;
        var tx:Number = Math.cos(r)*(Math.random() + 0.5)*100;
        var ty:Number = Math.sin(r)*(Math.random() + 0.5)*100;
        var nx:Number = tx*0.3*Math.random();
        var ny:Number = ty*0.3*Math.random();
        BetweenAS3.serial(
            BetweenAS3.tween( self, {x:tx+_x, y:ty+_y, scaleX:2.5, scaleY:2.5, alpha:0, _blurFilter:{blurX:16, blurY:16} }, {x:nx+_x, y:ny+_y, scaleX:0.8, scaleY:0.8, alpha:0.8, _blurFilter:{blurX:4, blurY:4, quality:1}}, 1, Cubic.easeOut),
            BetweenAS3.removeFromParent( self ),
            BetweenAS3.func( function():void{
                removeChild( bmp );
                bmp = null;
                bmpd.dispose();
                self = null;
            } )
        ).play();
    }
    
}