/**
 * Copyright kaiho ( http://wonderfl.net/user/kaiho )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3ZKX
 */

/*
 * 昔ながらの車よけGameをイメージ
 * ・スコアは走った時間で増えていく（よけて走るだけ）
 * ・耐久性０　で終了
 * ・壁接触　－５
 * ・その他の車接触　接触の仕方によって変わる
 * ・マウスダウンで加速を追加（最高速度到達で）
 */
package 
{
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.events.EventDispatcher;
	
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	
	[SWF(width=400, height=500, backgroundColor=0x888888, frameRate=50)]
	
	public class Main extends Sprite 
	{
		
		//画面サイズ
		private var W:Number = 400;
		private var H:Number = 500;
		private var backColor:uint = 0x888888;
		
		//マイカー
		private var myCar:MahhaGO;
		private var myCarColor:uint = 0xffffff;
		private var carHandring:Number = 1;//マウス追っかけ速度
		private var myCarX:Number = W / 2;//初期表示位置(X軸)
		private var myCarY:Number = (H / 10) * 9;//初期表示位置(Y軸)
		private var myCarRote:Number = 0;
		private var myCarRflg:Boolean = false;
		private var myCarPower:Number = 50;//耐久性
		private var myCarMAX:Number = 10;//加速上限
		private var myCarSpeedUp:Number = 0;//加速コントロール用
		private var MAXflg:Boolean = false;
		
		//ハイスコア表示テキスト
		private var hScoreText:TextField;
		private var HSCORE:String = "HSCORE：　";
		private var hScorePoint:Number = 0;
		
		//スコア表示テキスト
		private var scoreText:TextField;
		private var SCORE:String = "SCORE　：　";
		private var scorePoint:Number = 0;
		private var scoreRate:Number = 1;//加算スコア
		private var MAXSpeedB:Number = 3;//最高速度到達時加算スコア倍率
		
		//POWER表示テキスト
		private var bodyText:TextField;
		private var POWER:String = "POWER　：　";
		
		//マイカーステータステキスト
		private var myCarText:TextField;
		private var MAX:String = "MAX SPEED";
		private var ACC:String = "ACCELERATION";
		private var DEC:String = "DECELERATION";
		private var NOR:String = "NORMAL";
		
		//その他の車
		private var atherCar:Car;
		private var atherCarColor:uint = 0x0;
		private var atherCarX:Number = W / 2;//初期表示位置(X軸)
		private var atherCarDSpeed:Number = 5;//その他の車のデフォルトスピード
		private var atherSpeedSrow:Number = atherCarDSpeed;
		private var atherPowerSrow:Number = 1;
		private var atherSpeedHeiRate:Number = 3//ときどき来る対向車の倍率
		private var atherCarSpeed:Number = atherSpeedSrow;
		private var ahterCarPower:Number = atherPowerSrow;
		private var hitR:Number = 45;
		
		//壁
		private var wallL:wall;//壁：左側
		private var wallR:wall;//壁：右側
		private var wallW:Number = 75;
		private var wallC:uint = 0xaaaaaa;
		private var wallH:Number = 2;//壁接触時移動スピード
		
		//中央白線
		private var wLine:whiteLine;
		private var wlWid:Number = 4;
		private var wlHei:Number = 100;
		private var wlDSpeed:Number = 30;//白線のデフォルト
		private var wlSpeed:Number = wlDSpeed;
		
		//中央表示テキスト
		private var messageText:TextField;
		private var START:String = "CLICK START!!";
		private var RETRY:String = "RETRY?";
		
		public function Main():void 
		{
			
			makingWall();
			makingLine();
			makingAther();
			makingMyCar();
			makeText();
		}
		
		//マイカー
		private function makingMyCar():void {
			myCar = new MahhaGO(this, myCarX, myCarY, myCarColor);
			myCar.draw();
			
			stage.addChild(myCar);
		}
		
		//他車
		private function makingAther():void {
			atherCar = new Car(this, myCarX, 0, atherCarColor);
			atherCar.draw();
			
			stage.addChild(atherCar);
		}
		
		//壁
		private function makingWall():void {
			wallL = new wall(0, wallW, H, wallC);
			wallR = new wall(W - wallW, wallW, H, wallC);
			
			stage.addChild(wallL);
			stage.addChild(wallR);
		}
		
		//中央白線
		private function makingLine():void {
			wLine = new whiteLine(myCarX, wlWid, wlHei, wlSpeed , H);
			
			stage.addChild(wLine);
			
		}
		
		//テキスト
		private function makeText():void {
			//スコアテキスト
			hScoreText = new TextField();
			hScoreText.text = HSCORE + hScorePoint;
			hScoreText.width = W;
			stage.addChild(hScoreText);
			
			//スコアテキスト
			scoreText = new TextField();
			scoreText.text = SCORE + scorePoint;
			scoreText.width = W;
			scoreText.y = 20;
			stage.addChild(scoreText);
			
			//POWERテキスト
			bodyText = new TextField();
			bodyText.text = POWER + myCarPower;
			bodyText.y = 40;
			stage.addChild(bodyText);
			
			//ステータステキスト
			myCarText = new TextField();
			myCarText.text = NOR;
			myCarText.y = 100;
			stage.addChild(myCarText);
			
			//スタート＆リトライ表示テキスト
			messageText = new TextField();
			messageText.text = START;
			messageText.x = W / 2 - 50;
			messageText.y = H / 2;
			messageText.wordWrap = false;
			messageText.autoSize = "center";
			stage.addChild(messageText);
			stage.addEventListener(MouseEvent.CLICK, startCar);
		}
		
		//マイカーイベント
		public function drivingCar(event:Event):void {
			
			if (mouseX > myCar.x) {
				myCar.x += carHandring;
				
				//車位置微調整
				if (mouseX < myCar.x) {
					myCar.x = mouseX;
				}
			} else if(mouseX < myCar.x) {
				myCar.x -= carHandring;
				
				//車位置微調整
				if (mouseX > myCar.x) {
					myCar.x = mouseX;
				}
			} 
			
			checkWall();
			
		} 
		
		//ほかの車イベント
		private function drivingAtherCar(event:Event):void {
			atherCar.y += atherCarSpeed;
			
			if (atherCar.hitTestObject(myCar)) {
				myCarPower = myCarPower - ahterCarPower;
				bodyText.text = POWER + myCarPower;
				
				myCarRote = hitR;
				stage.addEventListener(Event.ENTER_FRAME, hitCar);
			}
			
			nextCar();
		}
		
		//中央白線イベント（Game中はずっと起動する（ある意味メインで動くやつ））
		private function flowLine(event:Event):void {
			wLine.flow();//白線
			scoreWrite();//スコア表示
			powerCheck();//Powerチェック
		}
		
		//壁接触時のイベント
        private function checkWall():void{
			//壁接触チェック
			if (myCar.hitTestObject(wallL) || myCar.hitTestObject(wallR)) {
				myCarPower = myCarPower - 5;
				
				stage.addEventListener(Event.ENTER_FRAME, hitWall);
				stage.removeEventListener(Event.ENTER_FRAME, drivingCar);
			}
        }
		
		//その他の車が画面下行った時のイベント
		private function nextCar():void {
			if (atherCar.y - 50 > H) {
				atherCar.y = -50;
				atherCar.x = (Math.random() * (W - 200)) + 100;
				
				if (Math.random() * 10 > 8) {
					atherCar.scaleY = -1;
					atherCarSpeed = atherSpeedSrow * atherSpeedHeiRate;
					ahterCarPower = atherPowerSrow * atherSpeedHeiRate;

					} else {
					atherCar.scaleY = 1;
					atherCarSpeed = atherSpeedSrow;
					ahterCarPower = atherPowerSrow;
				}
			}
			
		}
		
		//その他の車に当たった時のイベント
		private function hitCar(event:Event):void {
			myCar.rotation = myCarRote;
			if (myCarRflg) {
				myCarRote = Math.abs(myCarRote) - 1;
				myCarRflg = false;
			} else {
				myCarRote = (Math.abs(myCarRote) - 1) * - 1;
				myCarRflg = true;
			}
			
			if (myCarRote == 0) {
				stage.removeEventListener(Event.ENTER_FRAME, hitCar);
			}
		}
		
		//壁接触時のイベント
		private function hitWall(event:Event):void {
			
			if (myCar.x < (W / 2)) {
				myCar.x += wallH;
			} else {
				myCar.x -= wallH;
			}
			
			if (Math.abs(myCar.x - (W / 2)) < 75) {
				stage.addEventListener(Event.ENTER_FRAME, drivingCar);
				stage.removeEventListener(Event.ENTER_FRAME, hitWall);
			}
		}
		
		//加速イベント
		public function accelerationStart(e:MouseEvent):void {
			
			stage.addEventListener(Event.ENTER_FRAME, acceleration);
			
		}
		
		
		public function acceleration(e:Event):void {
			
			if (myCarSpeedUp <= myCarMAX) {
				myCarSpeedUp = myCarSpeedUp + 0.1;
				myCarText.text = ACC;				
			}
			
				var i:int = Math.round(myCarSpeedUp);
				
				atherCarSpeed = atherCarSpeed + (i / 10);
				ahterCarPower = atherPowerSrow * i;
				wlSpeed = wlDSpeed + i;
				
				
				
			
			if (myCarSpeedUp > myCarMAX && !MAXflg) {
				scoreRate *= MAXSpeedB;
				MAXflg = true;
				myCarText.text = MAX;
			}
			
		}
		
		//減速イベント
		public function decelerationStart(e:MouseEvent):void {
			
			stage.removeEventListener(Event.ENTER_FRAME, acceleration);
			stage.addEventListener(Event.ENTER_FRAME, deceleration);

		}
		
		//減速イベント
		public function deceleration(e:Event):void {
			
			if (MAXflg) {
				scoreRate /= MAXSpeedB;
				MAXflg = false;
			}
			
			if (myCarSpeedUp > 0) {
				myCarSpeedUp = myCarSpeedUp - 0.1;
				
			}
			
				var i:int = Math.round(myCarSpeedUp);
				
				atherCarSpeed = atherCarSpeed + (i / 10);
				ahterCarPower = atherPowerSrow * i;
				wlSpeed = wlDSpeed + (i * 2);
				myCarText.text = DEC;

			
			if (myCarSpeedUp <= 0) {
				myCarText.text = NOR;
				stage.removeEventListener(Event.ENTER_FRAME, deceleration);
			}
			
		}		
		
		//GAMEスタート
		private function startCar(event:MouseEvent):void {
			messageText.text = "";
			
			//初期化
			myCar.x = W / 2;
			myCarPower = 50;
			scorePoint = 0;
			scoreRate = 1;
			atherCar.y = -20;
			wlSpeed = wlDSpeed;
			atherCarSpeed = atherSpeedSrow;
			ahterCarPower = atherPowerSrow;
			myCarText.text = NOR;
			myCarSpeedUp = 0;
			MAXflg = false;
			
			stage.addEventListener(Event.ENTER_FRAME, drivingCar);
			stage.addEventListener(Event.ENTER_FRAME, drivingAtherCar);
			stage.addEventListener(Event.ENTER_FRAME, flowLine);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, accelerationStart);
			stage.addEventListener(MouseEvent.MOUSE_UP, decelerationStart);
			stage.removeEventListener(MouseEvent.CLICK, startCar);
		}
		
		//ストップ
		private function stopCar():void {
			messageText.text = RETRY;
			stage.removeEventListener(Event.ENTER_FRAME, drivingCar);
			stage.removeEventListener(Event.ENTER_FRAME, drivingAtherCar);
			stage.removeEventListener(Event.ENTER_FRAME, flowLine);
			stage.removeEventListener(Event.ENTER_FRAME, hitWall);
			stage.removeEventListener(MouseEvent.MOUSE_DOWN, accelerationStart);
			stage.removeEventListener(MouseEvent.MOUSE_UP, decelerationStart);
			stage.removeEventListener(Event.ENTER_FRAME, acceleration);
			stage.removeEventListener(Event.ENTER_FRAME, deceleration);
			stage.addEventListener(MouseEvent.CLICK, startCar);
		}
		
		//スコア
		public function scoreWrite():void {
			scorePoint = scorePoint + scoreRate;
			scoreText.text = SCORE + scorePoint;//スコア加算
			
			if (hScorePoint < scorePoint) {
				hScorePoint = scorePoint;
				hScoreText.text = HSCORE + hScorePoint;
			}
		}
		
		//Powerチェック
		private function powerCheck():void {
			if (myCarPower <= 0) {
				myCarPower = 0
				stopCar();
			}
			
			bodyText.text = POWER + myCarPower;
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;
import flash.display.Sprite

import flash.events.Event;

class obj extends Sprite {
	private var feild:Main;
	public var color:uint;
	
	public function obj(f:Main) {
		this.feild = f;
	}
	
	public function draw():void 
	{
	}
	
}

//マイカー
class MahhaGO extends obj {
	
	public function MahhaGO(f:Main, x:Number, y:Number, c:uint) {
		super(f);
		this.x = x;
		this.y = y;
		this.color = c;
		
		draw();
		
	}
	
	//目指せ、線でマッハ号もどき
	override public function draw():void {
		graphics.lineStyle(1, 0, 1);
		graphics.beginFill(color);
		//中央フロント右側
		graphics.moveTo(0, -29);
		graphics.lineTo(1, -28);
		graphics.lineTo(2.5, -26);
		graphics.lineTo(3.5, -20);
		graphics.lineTo(5, -15);
		graphics.lineTo(5, -10);
		//フロント右
		graphics.lineTo(7, -7);
		graphics.lineTo(5, -10);
		graphics.lineTo(5, -15);
		graphics.lineTo(7, -20);
		graphics.lineTo(3.5, -20);
		graphics.lineTo(7, -20);
		graphics.lineTo(10, -25);//フロント右先端
		graphics.lineTo(13, -20);
		graphics.lineTo(14, -15);
		graphics.lineTo(13, -10);
		graphics.lineTo(12, -5);
		//車体右
		graphics.lineTo(8, 3);
		graphics.lineTo(10, 9);
		graphics.lineTo(12, 13);
		graphics.lineTo(12, 16);
		graphics.lineTo(10, 20);
		
		//リア右
		graphics.lineTo(8, 23);
		graphics.lineTo(5, 25);
		graphics.lineTo(5, 18);
		graphics.lineTo(5, 28);
		graphics.lineTo(5, 25);
		graphics.lineTo(3, 23);
		
		//リア中央
		graphics.lineTo(2, 20);
		graphics.lineTo(1, 15);
		graphics.lineTo(3, 10);
		graphics.lineTo(1, 15);
		graphics.lineTo(-1, 15);
		graphics.lineTo(-3, 10);
		graphics.lineTo(-1, 15);
		graphics.lineTo(-2, 20);
		
		//リア左
		graphics.lineTo(-3, 23);
		graphics.lineTo(-5, 25);
		graphics.lineTo(-5, 18);
		graphics.lineTo(-5, 28);
		graphics.lineTo(-5, 25);
		graphics.lineTo(-8, 23);
		
		//車体左
		graphics.lineTo(-10, 20);
		graphics.lineTo(-12, 16);
		graphics.lineTo(-12, 13);
		graphics.lineTo(-10, 9);
		graphics.lineTo(-8, 3);
		
		//フロント左
		graphics.lineTo(-12, -5);
		graphics.lineTo(-13, -10);
		graphics.lineTo(-14, -15);
		graphics.lineTo(-13, -20);
		graphics.lineTo(-10, -25);//フロント左先端
		graphics.lineTo(-7, -20);
		graphics.lineTo(-3.5, -20);
		graphics.lineTo(-7, -20);
		graphics.lineTo(-5, -15);
		graphics.lineTo(-5, -10);
		graphics.lineTo(-7, -7);
		
		//中央フロント左側
		graphics.lineTo(-5, -10);
		graphics.lineTo(-5, -15);
		graphics.lineTo(-3.5, -20);
		graphics.lineTo(-2.5, -26);
		graphics.lineTo(-1, -28);
		graphics.lineTo(0, -29);
		graphics.endFill();
	}
}

class Car extends obj {
	
	public function Car(f:Main, x:Number, y:Number, c:uint) {
		super(f);
		this.x = x;
		this.y = y;
		this.color = c;
		
		draw();
	}
	
	//車もどき
	override public function draw():void {
		graphics.lineStyle(1, 0, 1);
		graphics.beginFill(color);
		graphics.moveTo(-10, -20);
		graphics.lineTo(10, -20);
		graphics.lineTo(10, -10);
		graphics.lineTo(15, -10);
		graphics.lineTo(15, -5);
		graphics.lineTo(10, -5);
		graphics.lineTo(10, 13);
		graphics.lineTo(15, 13);
		graphics.lineTo(15, 18);
		graphics.lineTo(10, 18);
		graphics.lineTo(10, 20);
		graphics.lineTo(-10, 20);
		graphics.lineTo(-10, 18);
		graphics.lineTo(-15, 18);
		graphics.lineTo(-15, 13);
		graphics.lineTo(-10, 13);
		graphics.lineTo(-10, -5);
		graphics.lineTo(-15, -5);
		graphics.lineTo(-15, -10);
		graphics.lineTo(-10, -10);
		graphics.lineTo(-10, -20);
		graphics.endFill();
	}
	
}

class wall extends Shape {
	
	private var wallHei:Number;
	private var wallWid:Number;
	
	private var wColor:Number;
	
	public function wall(x:Number, w:Number, h:Number, c:uint) {
		this.x = x;
		wallWid = w;
		wallHei = h;
		wColor = c;
		
		makeWall();
	}
	
	private function makeWall():void {
		graphics.lineStyle(1, wColor, 1);
		graphics.beginFill(wColor);
		graphics.lineTo(wallWid, 0);
		graphics.lineTo(wallWid, wallHei);
		graphics.lineTo(0, wallHei);
		graphics.lineTo(0, 0);
		graphics.endFill();
	}
}

//中央白線Class
class whiteLine extends Shape {
	
	private var ay:Number;
	
	private var lineW:Number;
	private var lineH:Number;
	
	private var lineEnd:Number;
	
	private var lColor:uint = 0xFFFFFF;
	
	public function whiteLine(x:Number, w:Number, h:Number, ay:Number, le:Number) {
		this.x = x
		this.ay = ay;
		this.lineW = w;
		this.lineH = h;
		this.lineEnd = le;
		
		makeLine();
		
	}
	
	private function makeLine():void {
		graphics.lineStyle(1, lColor, 1);
		graphics.beginFill(lColor);
		graphics.moveTo((lineW/2)*-1, 0);
		graphics.lineTo((lineW/2)*-1, lineH * -1);
		graphics.lineTo((lineW/2), lineH * -1);
		graphics.lineTo((lineW/2), 0);
		graphics.lineTo((lineW/2)*-1, 0);
		graphics.endFill();
	}
	
	public function flow():void {
		y += ay;
		
		nextFlow();
	}
	
	private function nextFlow():void {
		if (y - lineH > lineEnd) {
			y = 0;
		}
		
	}
}