/**
 * Copyright Test_Dept ( http://wonderfl.net/user/Test_Dept )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3ZBM
 */

package {

	import flash.display.Sprite;
	import flash.events.Event;
	import flash.text.TextFormat;
	
	/**
	 * CUITest
	 * @author Test Dept
	 */
	[SWF(backgroundColor="#ffffff", width="465", height="465")]
	public class CUITest extends Sprite {

		private var _console : ConsoleField;
		
		private var _prompt : String;
		
		public function CUITest() {

			_prompt = "# ";

			_console = new ConsoleField();
			_console.defaultTextFormat = new TextFormat("courier", 12);
//			_console.hideTextInput = true;
			addChild(_console);
			
			_console.addEventListener(ConsoleEvent.CONSOLE_INPUT,
				_console_consoleInputHandler);

			addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
		}
		
		private function addedToStageHandler(event : Event) : void {
			_console.width = stage.stageWidth;
			_console.height = stage.stageHeight;
			showPrompt();
		}

		private function _console_consoleInputHandler(event : ConsoleEvent) : void {

			var lines : Array = _console.readLines();
			_console.println("lines:");
			for (var i : int = 0; i < lines.length; i++) {
				_console.println(i + ":[" + lines[i] + "]");
			}

			showPrompt();
		}

		private function showPrompt() : void {
			_console.print(_prompt);
		}
	}
}

import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.events.Event;
import flash.events.KeyboardEvent;
import flash.events.TextEvent;
import flash.ui.Keyboard;

class ConsoleField extends TextField {
	
	private static const EOL : String = "\n";
	
	private var _inputBuffer : String;
	private var _callLater : Array;
	private var _hideTextInput : Boolean;
	
	public function ConsoleField() {

		_inputBuffer = "";
		_callLater = new Array();
		_hideTextInput = false;

		multiline = true;
		type = TextFieldType.INPUT;
		autoSize = TextFieldAutoSize.NONE;
		text = "";
		
		addEventListener(TextEvent.TEXT_INPUT, textInputHandler);
		addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	
	private function textInputHandler(event : TextEvent) : void {

		_inputBuffer += event.text;

		if (_hideTextInput) {
			event.preventDefault();
		}
	}

	private function keyDownHandler(event : KeyboardEvent) : void {
		if (event.keyCode == Keyboard.ENTER) {
			callLater(function() : void {
				dispatchEvent(new ConsoleEvent(ConsoleEvent.CONSOLE_INPUT) );
			} );
		}
	}

	private function callLater(func : Function) : void {
		_callLater.push(func);
	}
	
	private function enterFrameHandler(event : Event) : void {
		while (_callLater.length > 0) {
			_callLater.shift()();
		}
	}
	
	public function get hideTextInput() : Boolean {
		return _hideTextInput;
	}
	
	public function set hideTextInput(value : Boolean) : void {
		_hideTextInput = value;
	}

	public function print(text : String) : void {
		appendText(text);
		setSelection(
			this.text.length,
			this.text.length);
	}

	public function println(text : String = "") : void {
		print(text);
		print(EOL);
	}
	
	public function readLines(maxLines : int = 0x7fffffff) : Array {

		var lines : Array = new Array();

		var index : int;

		while (maxLines > 0 && (index = _inputBuffer.indexOf(EOL) ) != -1) {
			lines.push(_inputBuffer.substring(0, index) );
		    _inputBuffer = _inputBuffer.substring(index + 1);
		    maxLines--;
		}

		return lines;
	}
}

class ConsoleEvent extends Event {

	public static const CONSOLE_INPUT : String = "consoleInput";

	public function ConsoleEvent(type : String) {
		super(type);
	}
	
	override public function clone():Event {
		return new ConsoleEvent(type);
	}
}
