/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Ytk
 */

package {
    import flash.display.Sprite;
    import flash.text.*;
    import flash.events.*;
    import flash.system.*;
    
    
    [SWF(backgroundColor ="0xffffff")]
    public class FlashTest extends Sprite {
        
        private var btn1:Btn = new Btn();
        private var btn2:Btn = new Btn();
        private var kb:KeyBoardBtn = new KeyBoardBtn(); 
        private var logo:LogoGenerator = new LogoGenerator();
        
        public function FlashTest() {
            
            logo.text = "wonderfl";
            logo.y = 100;
            logo.x = 100;
            addChild(logo);

            
            kb.text = logo.text;
            
            addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
            addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown2);
            
            kb.x =10;
            kb.y = 10;
            kb.scaleX = 1.2;
            kb.scaleY = 1.2;
            addChild(kb);

  

            var i:int;
            var keyName:String;
            
        }
 

        

        
        private function onKeyDown(e:MouseEvent):void{
            logo.text = kb.text;
            
            
        }
        private function onKeyDown2(e:KeyboardEvent):void{
            logo.text = kb.text;
            
        }



    }
}




// LogoGenerator クラス

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class LogoGenerator extends Sprite {
        // インスタンス変数の宣言
        public var scale:int=0;
        private var _text:String = new String();
        private var reflection:Bitmap;     // 反射効果の表示
        private var preview:Sprite;        // プレビュー表示
        private var previewText:TextField; // プレビュー文字
        private var hilight:Sprite;        // ハイライト
        

        // コンストラクタ
        public function LogoGenerator():void {
           
            // 各コンポーネントを初期化する
            initComponents();

            // 初回の描画を行う
            update();
   
        }
        
        public function get text():String{
            return _text;
        }
        public function set text(str:String):void{
            _text = str;
            update();
        }



        // 表示オブジェクトの初期化
        private function initComponents():void {

            

            // 反射を表示するビットマップを作成
            reflection = new Bitmap();

            // プレビュー用表示の Sprite を作成
            preview = new Sprite();
            preview.y = reflection.y;

            // 出力用のテキストフィールドを作成
            previewText = new TextField();
            var tf:TextFormat = new TextFormat();  // TextFormat オブジェクトを作成
            tf.size = 48+scale;                          // 文字サイズを 48px に変更
            tf.color = 0x000000;                   // テキストのカラー
            previewText.defaultTextFormat = tf;    // TextFormat を指定
            previewText.autoSize = "left";

            // ハイライトを作成
            hilight = new Sprite();
            hilight.graphics.beginFill(0xffffff, 0.3);
            hilight.graphics.drawRect(0, 0, 10, 10);
            hilight.graphics.drawEllipse(0, 3, 10, 10);
            hilight.graphics.endFill();
            hilight.x = 2; // TextField の周りにできる2pxのマージンの分、ずらしておく

            addChild(reflection);
            addChild(preview);
            preview.addChild(previewText);
            preview.addChild(hilight);

        }

        // 表示を更新する
        private function update():void {
            // 文字列の更新
            previewText.text = _text;

            // 最後の１文字の色を変更する
            var tf:TextFormat = new TextFormat();
            tf.color = 0x00be00;
            //tf.color = Math.random()*0x1000000;
            previewText.setTextFormat(tf, _text.length - 1);

            // ハイライトのサイズを変更する
            hilight.width = previewText.textWidth;
            hilight.height = previewText.textHeight * 1.3;
            
            updateReflection();
        }

        // 反射を更新する
        private function updateReflection():void {
            // プレビューを BitmapData に描画
            var bmd:BitmapData = new BitmapData(preview.width, previewText.height * 2);
            bmd.fillRect(bmd.rect, 0xffffffff);
            bmd.draw(preview);

            // ロゴ全体の高さを取得
            var textHeight:int = bmd.getColorBoundsRect(0xffffffff, 0xffffffff, false).bottom;

            // 映り込みを描画していく
            for(var i:int = 0; i < textHeight; i++) {
                var multiply:uint = Math.max(1, i/ textHeight * 64);
                bmd.merge(bmd, new Rectangle(0, i, preview.width, 1), 
                    new Point(0, textHeight * 2 - i + 2), multiply, multiply, multiply, 256);
            }

            // 反射以外を削除
            //bmd.fillRect(new Rectangle(0, 0, preview.width, textHeight), 0xffffffff);

            // 表示
            if(reflection.bitmapData) {
                reflection.bitmapData.dispose();
            }
            reflection.bitmapData = bmd;
        }
}




/////////////////////////////////////////////////////////
//    キーボード表示
/////////////////////////////////////////////////////////
import flash.system.*;
import flash.events.*;
class KeyBoardBtn extends Sprite{
    private var btn:Btn;
    
    private var caps:Boolean = false;
    private var alt:Boolean = false;
    private var ctrl:Boolean = false;
    private var shift:Boolean = false;
    
    private var _text:String = new String();
    public function KeyBoardBtn():void{
        var keyName:String;
        var i:int;
        
        // 半角/全角
        //btn.name = "key";
        btn = new Btn();
        btn.name = "229";
        btn.init({type:1,width:20});
        btn.x = 5;
        btn.y = 200; 
        btn.text = String.fromCharCode(0x0400);
        addChild(btn);
        
        // BackSpace
        btn = new Btn();
        btn.name = "8";
        btn.init({type:1,width:20});
        btn.x = 355;
        btn.y = 200;
        btn.text = "BS"; 
        addChild(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text = _text.substr(0,_text.length-1);
        });
       
        // Tab
        btn = new Btn();
        btn.name = "9";
        btn.init({type:1,width:30});
        btn.x = 10;
        btn.y = 225;
        btn.text = "Tab"; 
        addChild(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text += "\t";
        });
        
        // Enter
        btn = new Btn();
        btn.name = "13";
        btn.init({type:1,width:35});
        btn.x = 347;
        btn.y = 225;
        btn.text = "Enter"; 
        addChild(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text += "\r";
        });

        // Caps Lock
        btn = new Btn();
        btn.name = "229";
        btn.init({type:1,width:40});
        btn.x = 15;
        btn.y = 250;
        btn.text = "Caps"; 
        addChild(btn);
        
        // Delete    
        btn = new Btn();
        btn.init({type:1,width:25});
        btn.x = 351;
        btn.y = 250;
        btn.text = "";
        addChild(btn);
        
        
        // Shift (左)    
        btn = new Btn();
        btn.init({type:1,width:54});
        btn.x = 23;
        btn.y = 275;
        btn.text = "Shift"; 
        addChild(btn);
        
        // Shift (右)
        btn = new Btn();
        btn.init({type:1,width:34});
        btn.x = 347;
        btn.y = 275; 
        btn.text = "Shift"; 
        addChild(btn);
        
        // Ctrl (左)
        btn = new Btn();
        btn.init({type:1,width:30});
        btn.x =10;
        btn.y =300;
        btn.text = "Ctrl";
        addChild(btn);
        
        // Ctrl (右)
        btn = new Btn();
        btn.init({type:1,width:30});
        btn.x =350;
        btn.y =300;
        btn.text = "Ctrl";
        addChild(btn);
        
        /*
        // Alt (左)
        btn = new Btn();
        btn.init({type:1,width:30});
        btn.x =45;
        btn.y =300;
        btn.text = "Alt";
        addChild(btn);
        
        // Alt (右)
        btn = new Btn();
        btn.init({type:1,width:30});
        btn.x =315;
        btn.y =300;
        btn.text = "Alt";
        addChild(btn);
        */
        
        // space
        btn = new Btn();
        btn.init({type:1,width:100});
        btn.x =170;
        btn.y =300;
        addChild(btn);
        btn.addEventListener(MouseEvent.MOUSE_DOWN,function():void{
            _text += " ";
        });
        

        
        keyName = "1234567890-^\\"
            
        for(i=0;i<13;i++){
            btn = new Btn();
            btn.init({type:1,width:20});
            btn.x = i*25+30;
            btn.y = 200;
            btn.text = keyName.charAt(i); 
            addChild(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        keyName = "qwertyuiop@["
            
        for(i=0;i<12;i++){
            btn = new Btn();
            btn.init({type:1,width:20});
            btn.x = i*25+40;
            btn.y = 225;
            btn.text = keyName.charAt(i); 
            addChild(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        keyName = "asdfghjkl;:]"
            
        for(i=0;i<12;i++){
            btn = new Btn();
            btn.init({type:1,width:20});
            btn.x = i*25+50;
            btn.y = 250;
            btn.text = keyName.charAt(i); 
            addChild(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        keyName = "zxcvbnm,./\\"
            
        for(i=0;i<11;i++){
            btn = new Btn();
            btn.init({type:1,width:20});
            btn.x = i*25+65;
            btn.y = 275;
            btn.text = keyName.charAt(i); 
            addChild(btn);
            btn.addEventListener(MouseEvent.MOUSE_DOWN,onKeyDown);
        }
        
        addEventListener(KeyboardEvent.KEY_DOWN,onKey);
        

    }
    
    private function onKey(e:KeyboardEvent):void{
        shift = e.shiftKey;
        alt = e.altKey;
        ctrl = e.ctrlKey;
        text = "keycode:"+String(e.keyCode);
        if(shift == true)text+=" +Shift";
        if(alt == true)text+=" +alt";
        if(ctrl == true)text+=" +Ctrl";
        

    }

    
    private function onKeyDown(e:MouseEvent):void{
            _text += e.currentTarget.text;
    }
    
    public function get text():String{
        return _text;
    }
    public function set text(str:String):void{
        _text = str;
    }


        
    

    
}



//////////////////////////////////////////////////
// Btnクラス
//////////////////////////////////////////////////


import flash.display.*;
import flash.text.*;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;

class Btn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var txt:TextField;
    private var label:String = "";
    //private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var gColor:uint = 0x00ff00;
    private var blueGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function Btn() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        draw();
    }
    private function draw():void {
        
        switch (type) {//カラーパターン
        case 1 ://　White
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :// Black
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        
        blueGlow = new GlowFilter(gColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(txt);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, gColor);
        light.filters = [blueGlow];
        createBase(base, _width, _height, corner, bColor);
        txt.x = -_width*0.5;
        txt.y = -_height*0.5;
        txt.width = _width;
        txt.height = _height - 1;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        //tf.font = fontType;
        tf.size = 12;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.text = label;
        enabled = true;
        mouseChildren = false;
    }
    
    
    public function get text():String{
        return txt.text;
    }
    public function set text(str:String):void{
        txt.text = str;
    }


    
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    public function _up():void {
        txt.y = -_height*0.5;
        txt.textColor = upColor;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        txt.y = -_height*0.5;
        txt.textColor = overColor;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    public function _down():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = overColor;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        txt.y = -_height*0.5 + 1;
        txt.textColor = offColor;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        enabled = !_clicked;
        if (_clicked) {
            _down();
        } else {
            _up();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}
