/**
 * Copyright www0z0k ( http://wonderfl.net/user/www0z0k )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Ys8
 */

// forked from yonatan's swfassist test
// Dynamic SWF generation -  Click and drag! 

package
{
    import flash.net.FileReference;
    import flash.ui.Keyboard;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.events.MouseEvent;
    import flash.events.KeyboardEvent;
    import flash.utils.ByteArray;
    
    import org.libspark.swfassist.io.ByteArrayOutputStream;
    import org.libspark.swfassist.swf.io.SWFWriter;
    import org.libspark.swfassist.swf.io.WritingContext;
    import org.libspark.swfassist.swf.structures.FillStyle;
    import org.libspark.swfassist.swf.structures.FillStyleTypeConstants;
    import org.libspark.swfassist.swf.structures.LineStyle;
    import org.libspark.swfassist.swf.structures.SWF;
    import org.libspark.swfassist.swf.structures.ShapeWithStyle;
    import org.libspark.swfassist.swf.structures.StraightEdgeRecord;
    import org.libspark.swfassist.swf.structures.StyleChangeRecord;
    import org.libspark.swfassist.swf.tags.DefineShape2;
    import org.libspark.swfassist.swf.tags.PlaceObject;
    import org.libspark.swfassist.swf.tags.PlaceObject2;
    import org.libspark.swfassist.swf.tags.ShowFrame;

    public class SwfassistDemo extends Sprite
    {
        public function SwfassistDemo()
        {
            Wonderfl.capture_delay( 20 );
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
        
        private var _swf:SWF;
        
        private function mouseDownHandler(e:MouseEvent):void
        {
            graphics.clear();
            graphics.lineStyle(1, 0x000000);
            graphics.moveTo(mouseX, mouseY);
            
            _swf = new SWF();
            _swf.header.version = 9;
            _swf.header.frameSize.xMax = 640;
            _swf.header.frameSize.yMax = 480;
            _swf.header.frameRate = 24;
            _swf.header.numFrames = 1;
            
            var defineShape:DefineShape2 = new DefineShape2();
            defineShape.shapeId = 1;
            defineShape.shapeBounds.xMax = 20;
            defineShape.shapeBounds.yMax = 20;
            var lineStyle:LineStyle = new LineStyle();
            lineStyle.color.fromUint(0);
            lineStyle.width = 1;
            var fillStyle:FillStyle = new FillStyle();
            fillStyle.fillStyleType = FillStyleTypeConstants.SOLID_FILL;
            fillStyle.color.fromUint(Math.random()*0xffffff);
            var shape:ShapeWithStyle = defineShape.shapes;
            shape.lineStyles.lineStyles.push(lineStyle);
            shape.fillStyles.fillStyles.push(fillStyle);
            var r1:StyleChangeRecord = new StyleChangeRecord();
            r1.fillStyle0 = 1;
            r1.lineStyle = 1;
            r1.moveDeltaX = 0;
            r1.moveDeltaY = 0;
            r1.stateFillStyle0 = true;
            r1.stateLineStyle = true;
            r1.stateMoveTo = true;
            var r2:StraightEdgeRecord = new StraightEdgeRecord();
            r2.verticalLine = true;
            r2.deltaY = 20;
            var r3:StraightEdgeRecord = new StraightEdgeRecord();
            r3.horizontalLine = true;
            r3.deltaX = 20;
            var r4:StraightEdgeRecord = new StraightEdgeRecord();
            r4.verticalLine = true;
            r4.deltaY = -20;
            var r5:StraightEdgeRecord = new StraightEdgeRecord();
            r5.horizontalLine = true;
            r5.deltaX = -20;
            shape.shapeRecords.push(r1, r2, r3, r4, r5);
            
            _swf.tags.addTag(defineShape);
            
            var placeObject:PlaceObject2 = new PlaceObject2();
            placeObject.characterId = 1;
            placeObject.depth = 1;
            placeObject.matrix.translateX = mouseX;
            placeObject.matrix.translateY = mouseY;
            placeObject.hasCharacter = true;
            placeObject.hasMatrix = true;
            
            _swf.tags.addTag(placeObject);
            _swf.tags.addTag(new ShowFrame());
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
        }
        
        private function mouseMoveHandler(e:MouseEvent):void
        {
            graphics.lineTo(mouseX, mouseY);
            
            var placeObject:PlaceObject2 = new PlaceObject2();
            placeObject.depth = 1;
            placeObject.isMove = true;
            placeObject.matrix.translateX = mouseX;
            placeObject.matrix.translateY = mouseY;
            placeObject.hasMatrix = true;
            
            _swf.tags.addTag(placeObject);
            _swf.tags.addTag(new ShowFrame());
            
            ++_swf.header.numFrames;
        }
        
        private function mouseUpHandler(e:MouseEvent):void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoveHandler);
            stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            trace('ready');
            var bytes:ByteArray = new ByteArray();
            
            new SWFWriter().writeSWF(new ByteArrayOutputStream(bytes), new WritingContext(), _swf);
            
            var ldr:Loader = new Loader();
            addChild(ldr);
            ldr.loadBytes(bytes);
        }
        
        private function onKeyDown(e:KeyboardEvent):void{
            trace('onKeyDown');
            switch(e.charCode){
                case Keyboard.ENTER:
                trace('onKeyDown : Keyboard.ENTER');
                var bytes:ByteArray = new ByteArray();            
                new SWFWriter().writeSWF(new ByteArrayOutputStream(bytes), new WritingContext(), _swf);
                var fr:FileReference = new FileReference();
                fr.save(bytes, 'test.swf');
                break;
            }

        }

    }
}
