/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Ymq
 */

// forked from jidolstar's Auto Object Pool Test
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.utils.*;

    [SWF(backgroundColor="#ffffff", frameRate="60", width="400", height="400")]
    /**
     * Object Pool 테스트 호스트 코드 
     * @author jidolstar(http://blog.jidolstar.com)
     */
    public class ObjectPoolTest extends Sprite {
        private var pool:RandomShapeAutoPool=new RandomShapeAutoPool;
        private var poolFlag:Boolean = false;
        private var textPoolFlag:TextField;
        private var shapeCanvas:Sprite;

        public function ObjectPoolTest() {
            addEventListener(Event.ADDED_TO_STAGE, ADDED_TO_STAGE);
        }

        private function ADDED_TO_STAGE($e:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, ADDED_TO_STAGE);
            stage.scaleMode=StageScaleMode.NO_SCALE;
            stage.align=StageAlign.TOP_LEFT;
            //rf)http://blog.jidolstar.com/656
            if (stage.stageWidth === 0 && stage.stageHeight === 0) {
                stage.addEventListener(Event.ENTER_FRAME, function($e:Event):void {
                        if (stage.stageWidth > 0 || stage.stageHeight > 0) {
                            stage.removeEventListener($e.type, arguments.callee);
                            init();
                        }
                    });
            } else {
                init();
            }
        }

        private function init():void {
            //shape의 부모객체 
            shapeCanvas = new Sprite;
            addChild( shapeCanvas );
            //PoolFlag 상태표시
            textPoolFlag = new TextField();
            textPoolFlag.text = "poolFlag=" + poolFlag;
            addChild(textPoolFlag);
            //마우스 클릭 영역 
            graphics.beginFill(0x000000,0);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            graphics.endFill();
            addEventListener(MouseEvent.CLICK, MOUSE_CLICK);
            //반복동작     
            addEventListener(Event.ENTER_FRAME, ENTER_FRAME);
        }

        private function MOUSE_CLICK($e:MouseEvent):void {
            //마우스 클릭때마다 poolFlag 상태를 전환 
            poolFlag = !poolFlag;
            textPoolFlag.text = "poolFlag=" + poolFlag;
        }
        
        private function ENTER_FRAME($e:Event):void {
            var shape:RandomShape, i:int, numChildren:int;
            //poolFlag에 따라서 new연산자 또는 Object Pool에서 객체 참조
            shape = poolFlag ? pool.getShape() : new RandomShape;
            shape.draw();
            shape.x = Math.random() * stage.stageWidth;
            shape.y = 0;
            shapeCanvas.addChild( shape );
            //계속 아래로 떨어뜨림. 화면에서 벗어나면 removeChild시킴 
            numChildren = shapeCanvas.numChildren;
            for( i=0; i<numChildren;i++) {
                shape = shapeCanvas.getChildAt(i) as RandomShape;
                shape.y += 5;
                if( shape.y > stage.stageHeight ) {
                    shapeCanvas.removeChild( shape );
                    i--;
                    numChildren--;
                }
            }
        }
    }
}

import flash.display.*;

/**
 * Shape용 자동 객체 Pool
 * @see http://www.diebuster.com/?p=1000
 */
class RandomShapeAutoPool {
    private var _pool:Vector.<RandomShape>;
    public function RandomShapeAutoPool() {
        //적당히 수로 초기화한다.
        _pool=new Vector.<RandomShape>();
    }

    public function getShape():RandomShape {
        var key:*, result:RandomShape;
        //먼저 기존의 pool에서 찾아본다.
        for (key in _pool) {
            //만약 해당 객체가 null이라면 new를 통해 생성한다.
            if (_pool[key] === null) { 
                _pool[key]=new RandomShape;
                result=_pool[key];
                break;
            //null이 아니라면 parent를 조사하여 사용가능한지 판단한다.
            } else if (_pool[key].parent === null) { 
                result=_pool[key];
                break;
            }
        }
        //기존의 pool안에서 쓸만한 걸 찾지 못했다면
        if (result === null) {
            result=new RandomShape;
            _pool[_pool.length]=result;
        }
        //인스턴스를 반환한다.
        return result;
    }
}
/**
 * 화면에 출력할 Shape
 */
class RandomShape extends Shape {
    static private var colorPool:Array = [0xff0000,0x00ffff,0x0000ff,0x00ff00,0x0f0f0f,0xf0f0f0,0xffff00,0xf00cf0,0x00fcaa,0xff0c9a];
    public function RandomShape():void {
    }
    public function draw():void {
        var radius:Number = Math.random() * 40;
        var color:uint = colorPool[ Math.floor(Math.random()*9) ];
        graphics.clear();
        graphics.beginFill(color,1.0);
        graphics.drawRect( 20, 20, 20,20 );
        graphics.endFill();
    }
}