/**
 * Copyright Mick.Surdenik ( http://wonderfl.net/user/Mick.Surdenik )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3YiNv
 */

// forked from makc3d's ff: glowing arcs (test)
// forked from makc3d's glowing arcs + mp3
package {
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import flash.net.*;
    import flash.system.*;
    import flash.utils.ByteArray;

    /**
     * A test for github-based music player.
     */
    [SWF(backgroundColor=0)]
    public class Swirling extends Sprite {
        public var lt:Sprite, rt:Sprite, player:*;
        public function Swirling () {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function (e:Event):void {
                loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, arguments.callee);
                player = loader.contentLoaderInfo.content;
                player.loadFromURL("http://198.101.15.90:8166/live");
                stage.addEventListener (Event.ENTER_FRAME, loop);
            });
            loader.load(
                new URLRequest("http://198.101.15.90:8166/live"),
                new LoaderContext(true, ApplicationDomain.currentDomain)
            );
            
            addChild (lt = new Sprite).x = 232; lt.y = 232;
            addChild (rt = new Sprite).x = 232; rt.y = 232;

            graphics.beginFill (0); graphics.drawRect (0, 0, 465, 465);
        }
        public var ba:ByteArray = new ByteArray;
        public function loop (e:Event):void {
            player.magic.computeSpectrum (ba, true);
            var n:int = 3, r:int = 2, a:Number, da:Number, v:Number;
            var i_lt:int = 0;
            var i_rt:int = 0;
            lt.graphics.clear ();
            rt.graphics.clear ();
            while ((i_lt < 128) || (i_rt < 128)) {
                a = n; da = 2 * Math.PI / n;
                for (var j:int = 0; j < n; j++) {
                    a += da;
                    if ((r % 2 > 0) && (i_lt < 128)) {
                        ba.position = 4 * i_lt;
                        v = ba.readFloat ();
                        drawArc (lt, a - 0.4 * da, a + 0.4 * da, 20 * r - 5, 20 * r + 5, hsl2rgb (r * 30, v)); i_lt++;
                    } else if (i_rt < 128) {
                        ba.position = 4 * (i_rt + 256);
                        v = ba.readFloat ();
                        drawArc (rt, a - 0.4 * da, a + 0.4 * da, 20 * r - 5, 20 * r + 5, hsl2rgb (r * 30, v)); i_rt++;
                    }
                }
                r++; n += r;
            }
            lt.rotation++;
            rt.rotation--;
        }
        public function drawArc (s:Sprite, a1:Number, a2:Number, r1:Number, r2:Number, c:uint = 0xFFFFFF, al:Number = 1):void {
            var n:int = Math.max (2, (a2 - a1) / 0.1);
            s.graphics.beginFill (c, al);
            for (var i:int = 0; i <= n; i++) {
                var ai:Number = a1 + i * (a2 - a1) / n;
                var xi:Number = r1 * Math.cos (ai);
                var yi:Number = r1 * Math.sin (ai);
                if (i == 0)
                    s.graphics.moveTo (xi, yi);
                else
                    s.graphics.lineTo (xi, yi);
            }
            for (i = 0; i <= n; i++) {
                ai = a2 + i * (a1 - a2) / n;
                xi = r2 * Math.cos (ai);
                yi = r2 * Math.sin (ai);
                s.graphics.lineTo (xi, yi);
            }
            s.graphics.endFill ();
        }
        /**
         * There's some bug with L ~ 1 :(
         * @see http://wonderfl.net/c/iIDv
         */
        private function hsl2rgb(h:Number, l:Number, s:Number=1):uint {

            if (h == 360){ h = 0;}

            //
            // based on C code from http://astronomy.swin.edu.au/~pbourke/colour/hsl/
            //

            while (h < 0){ h += 360; }
            while (h > 360){ h -= 360; }
            var r :Number, g :Number, b :Number;
            if (h < 120){
                r = (120 - h) / 60;
                g = h / 60;
                b = 0;
            }else if (h < 240){
                r = 0;
                g = (240 - h) / 60;
                b = (h - 120) / 60;
            }else{
                r = (h - 240) / 60;
                g = 0;
                b = (360 - h) / 60;
            }

            r = Math.min(r, 1);
            g = Math.min(g, 1);
            b = Math.min(b, 1);

            r = 2 * s * r + (1 - s);
            g = 2 * s * g + (1 - s);
            b = 2 * s * b + (1 - s);

            if (l < 0.5){
                r = l * r;
                g = l * g;
                b = l * b;
            }else{
                r = (1 - l) * r + 2 * l - 1;
                g = (1 - l) * g + 2 * l - 1;
                b = (1 - l) * b + 2 * l - 1;
            }

            return int (r * 255) * 65536 + int (g * 255) * 256 + int (b * 255);
        }
    }
}

