/**
 * Copyright vijay7003 ( http://wonderfl.net/user/vijay7003 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Yfi
 */

// forked from ProjectNya's WaveEffect (2)
////////////////////////////////////////////////////////////////////////////////
// WaveEffect (2)
//
// 置き換えマップ効果 (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=480
// BitmapDataでノイズ生成 (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=481
// [AS3.0] PerlinNoiseクラスに挑戦！
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1114
//
// 動作を軽くするための方法 (東京てらこ7 @trick7)
// Bitmap.filters を使わず、BitmapData.applyFilter() を用いる
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.text.TextFieldAutoSize;
    import flash.text.AntiAliasType;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var wave:WaveEffect;
        private var txt:TextField;
        private var matrix:Matrix;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            var rect:Rectangle = new Rectangle(0, 0, 465, 232);
            wave = new WaveEffect(rect);
            addChild(wave);
            txt = new TextField();
            txt.y = 292;
            addChild(txt);
            txt.width = 465;
            txt.height = 100;
            txt.autoSize = TextFieldAutoSize.CENTER;
            txt.type = TextFieldType.INPUT;
            txt.selectable = true;
            //txt.embedFonts = true;
            //txt.antiAliasType = AntiAliasType.ADVANCED;
            var tf:TextFormat = new TextFormat();
            tf.font = "_ゴシック";
            tf.size = 60;
            tf.align = TextFormatAlign.CENTER;
            txt.defaultTextFormat = tf;
            txt.textColor = 0x000000;
            txt.text = "WaveEffect";
            txt.maxChars = 10;
            txt.addEventListener(Event.CHANGE, change, false, 0, true);
            matrix = new Matrix();
            matrix.translate(0, 60);
            wave.setup(txt, matrix);
            wave.start();
        }
        private function change(evt:Event):void {
            wave.setup(txt, matrix);
        }

    }

}


//////////////////////////////////////////////////
// WaveEffectクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.DisplayObject;
import flash.events.Event;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.events.Event;
import flash.filters.DisplacementMapFilter;
import flash.display.BitmapDataChannel;
import flash.filters.DisplacementMapFilterMode;

class WaveEffect extends Sprite {
    private var rect:Rectangle;
    private var noise:PerlinNoise;
    private static var octaves:uint = 2;
    private static var channel:uint = BitmapDataChannel.RED;
    private var speeds:Array;
    private var map:DisplacementMapFilter;
    private var scale:Number = 10;
    private var target:DisplayObject;
    private var container:Bitmap;
    private var bitmapData:BitmapData;
    public static const COMPLETE:String = Event.COMPLETE;

    public function WaveEffect(r:Rectangle) {
        rect = r;
        init();
    }

    // メソッド
    private function init():void {
        noise = new PerlinNoise(rect, 32, 32, octaves, false, channel);
        speeds = new Array();
        for (var n:uint = 0; n < octaves; n++) {
            var sx:Number = (Math.random() - 0.5)*3;
            var sy:Number = (Math.random() - 0.5)*3 + 2.5;
            speeds.push(new Point(sx, sy));
        }
        map = new DisplacementMapFilter(noise, new Point(), channel, channel, scale, scale, DisplacementMapFilterMode.CLAMP);
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        container = new Bitmap(bitmapData);
        addChild(container);
    }
    public function setup(t:DisplayObject, matrix:Matrix = null):void {
        target = t;
        bitmapData.fillRect(rect, 0x00000000);
        bitmapData.draw(target, matrix, null, null, null, true);
        container.bitmapData = bitmapData.clone();
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function update(evt:Event):void {
        noise.update(speeds);
        container.bitmapData.lock();
        container.bitmapData.applyFilter(bitmapData, bitmapData.rect, new Point(), map);
        container.bitmapData.unlock();
    }

}


//////////////////////////////////////////////////
// PerlinNoiseクラス
//////////////////////////////////////////////////

import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;

class PerlinNoise extends BitmapData {
    private var bx:uint;
    private var by:uint;
    private var octaves:uint;
    private var seed:uint;
    private var stitch:Boolean = true;
    private var fractalNoise:Boolean = true;
    private var channel:uint = 0;
    private var grayScale:Boolean = true;
    private var offsets:Array = new Array();

    public function PerlinNoise(rect:Rectangle, x:uint, y:uint, o:uint = 1, g:Boolean = true, c:uint = 0, s:uint = 1, st:Boolean = false, f:Boolean = true) {
        super(rect.width, rect.height, false, 0xFF000000);
        bx = x;
        by = y;
        octaves = o;
        grayScale = g;
        channel = c;
        if (grayScale) channel = 0;
        for (var n:uint = 0; n < octaves; n++) {
            var point:Point = new Point();
            offsets.push(point);
        }
        stitch = st;
        fractalNoise = f;
        create(s, offsets);
    }

    private function create(s:uint, o:Array = null):void {
        seed = s;
        offsets = o;
        if (offsets == null) offsets = [new Point()];
        lock();
        perlinNoise(bx, by, octaves, seed, stitch, fractalNoise, channel, grayScale, offsets);
        draw(this);
        unlock();
    }
    public function update(speeds:Array):void {
        for (var n:uint = 0; n < octaves; n++) {
            var offset:Point = offsets[n];
            var speed:Point = speeds[n];
            offset.x += speed.x;
            offset.y += speed.y;
        }
        lock();
        perlinNoise(bx, by, octaves, seed, stitch, fractalNoise, channel, grayScale, offsets);
        draw(this);
        unlock();
    }

}
