/**
 * Copyright otherone ( http://wonderfl.net/user/otherone )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Xp7
 */

package
{
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    /**
     * ...
     * @author moriya
     */
    public class Main extends Sprite
    {
        private const STW:uint = stage.stageWidth,STH:uint = stage.stageHeight;
        private var bitmapRender:BitmapRender;
        private var _imgLoader:Loader;
        private var _imgLoaderInfo:LoaderInfo;

        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point

            var url:String = "http://assets.wonderfl.net/images/related_images/a/af/af90/af90356c6bcf822829d5f2787430a0c15332e42a";
            var urlReq:URLRequest = new URLRequest(url);
            var context:LoaderContext = new LoaderContext();
            context.checkPolicyFile = true;
            _imgLoader = new Loader();
            _imgLoaderInfo = _imgLoader.contentLoaderInfo;
            _imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageloaded);
            _imgLoader.load(urlReq, context);
            
            graphics.beginFill(0x000000, 1);
            graphics.drawRect(0, 0, STW, STH);
            graphics.endFill();
            
        }

        private function onImageloaded(e:Event):void
        {
            //var img:Bitmap = new nekoClass() as Bitmap;
            var img:BitmapData = new BitmapData(_imgLoader.width,_imgLoader.height);
            img.draw(_imgLoader);

            bitmapRender = new BitmapRender(img);
            addChild(bitmapRender);
            
            bitmapRender.x = (STW - bitmapRender.width) * 0.5;
            bitmapRender.y = (STH - bitmapRender.height) * 0.5;

            var btn0:ButtonSet = new ButtonSet(this, 0, 0, 'clear', null, null, fnClick10);
            var btn1:ButtonSet = new ButtonSet(this, 100, 20, 'gray', null, null, fnClick1);
            var btn2:ButtonSet = new ButtonSet(this, 100, 10, 'sepia', null, null, fnClick2);
            var btn3:ButtonSet = new ButtonSet(this, 100, 10, 'negative', null, null, fnClick3);
            var btn4:ButtonSet = new ButtonSet(this, 100, 10, 'mozaiku', null, null, fnClick4);
            
            btn0.x = (STW-btn0.width)*0.5;
            btn0.y = STH-btn0.height;
            btn1.x = 0;
            btn2.x = 110;
            btn3.x = 220;
            btn4.x = 330;

        }
        
        private function fnClick10():void 
        {
            bitmapRender._clear();
        }

        private function fnClick1():void
        {
            bitmapRender.grayScale();
        }

        private function fnClick2():void
        {
            bitmapRender.sepiaTone();
        }

        private function fnClick3():void
        {
            bitmapRender.negative();
        }

        private function fnClick4():void
        {
            bitmapRender.mozaiku();
            //bitmapRender.mozaiku(15,new Rectangle(100,50,200,200));
        }

    }

}

//********************************************************************************

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.geom.Rectangle;
import frocessing.color.ColorRGB;
import org.libspark.betweenas3.BetweenAS3;

class BitmapRender extends Sprite
{
    private var orginBD:BitmapData;
    private var bd:BitmapData;
    private var dest:BitmapData;
    private var bm:Bitmap;
    private var underBM:Bitmap;
    private var color:ColorRGB = new ColorRGB;

    public function BitmapRender(_bd:BitmapData)
    {
        orginBD = _bd;//オリジナルのビットマップ
        bd = orginBD.clone();//一時表示用（消える）
        dest = orginBD.clone();//表示用

        bm= new Bitmap(bd);
        underBM = new Bitmap(dest);
        this.addChild(underBM);
        this.addChild(bm);
    }
    
    public function _clear():void
    {
        bm.alpha = 1;
        bd = dest=underBM.bitmapData = orginBD.clone();
    }
    
    public function negative():void
    {
        //以前表示のビットマップデータを複製して上に表示、下表示に効果を反映してから、徐々に見せる
        //前回までの画像　上表示
        bd = dest.clone();
        bm.bitmapData=bd;
        bm.alpha = 1;

        //加工したビットマップ　下表示
        dest = orginBD.clone();
        for (var y:int = 0; y < orginBD.height; y++)
        {
            for (var x:int = 0; x < orginBD.width; x++)
            {
                color.value = orginBD.getPixel(x, y);
                color.r = 255 - color.r;
                color.g = 255 - color.g;
                color.b = 255 - color.b;
                dest.setPixel(x, y, color.value);
            }
        }
        underBM.bitmapData = dest;
        BetweenAS3.tween(bm, { alpha:0 }, null, 2).play();
    }

    public function grayScale():void
    {
        //以前表示のビットマップデータを複製して上に表示、下表示に効果を反映してから、徐々に見せる

        //前回までの画像　上表示
        bd = dest.clone();
        bm.bitmapData=bd;
        bm.alpha = 1;

        //加工したビットマップ　下表示
        dest = orginBD.clone();
        //dest = BitmapControll.gray(dest)

        for (var y:int = 0; y < orginBD.height; y++)
        {
            for (var x:int = 0; x < orginBD.width; x++)
            {
                color.value = dest.getPixel(x, y);
                var gray:int = (color.r + color.g + color.b) / 3;
                color.r = color.g = color.b = gray;

                dest.setPixel(x, y, color.value);
            }
        }

        underBM.bitmapData = dest;

        BetweenAS3.tween(bm, { alpha:0 }, null, 2).play();
    }

    public function sepiaTone():void//:BitmapData
    {
        bd = dest.clone();
        bm.bitmapData=bd;
        bm.alpha = 1;

        dest = orginBD.clone();

        for (var y:int = 0; y < orginBD.height; y++)
        {
            for (var x:int = 0; x < orginBD.width; x++)
            {
                color.value = orginBD.getPixel(x, y);
                var gray:int = color.r * 0.298912 + color.g * 0.586611 + color.b * 0.114478;
                color.r = color.g = color.b = gray;

                color.r *= 0.9;
                color.g *= 0.7;
                color.b *= 0.4;

                dest.setPixel(x, y, color.value);
            }
        }
        //dest = BitmapControll.sepia(dest);

        underBM.bitmapData = dest;

        BetweenAS3.tween(bm, { alpha:0 }, null, 2).play();
    }

    public function mozaiku(size:int=10,rect:Rectangle=null):void
    {
        //var size:int = 20;
        //var rect:Rectangle = new Rectangle(100, 100, 200, 200);
        bd = dest.clone();
        bm.bitmapData=bd;
        bm.alpha = 1;

        dest = bd.clone();

        for (var y:int = 0; y < orginBD.height; y += size)
        {
            for (var x:int = 0; x < orginBD.width; x += size)
            {
                var count:int = 0;
                var r:int = 0;
                var g:int = 0;
                var b:int = 0;
                for (var yy:int = 0; yy < size; yy++)
                {
                    for (var xx:int = 0; xx < size; xx++)
                    {
                        if (x + xx < 0 || orginBD.width <= x + xx ||
                        y + yy < 0 || orginBD.height <= y + yy) continue;
                        color.value = orginBD.getPixel(x + xx, y + yy);
                        r += color.r;
                        g += color.g;
                        b += color.b;
                        count++;
                    }
                }
                color.r = r / count;
                color.g = g / count;
                color.b = b / count;

                for (yy = 0; yy < size; yy++)
                {
                    for (xx = 0; xx < size; xx++)
                    {
                        if (x + xx < 0 || bd.width <= x + xx ||
                        y + yy < 0 || bd.height <= y + yy) continue;

                        dest.setPixel(x + xx, y + yy, color.value);
                    }
                }
            }
        }

        //dest=BitmapControll.mozaiku(dest,size,rect);
        underBM.bitmapData = dest;
        BetweenAS3.tween(bm, { alpha:0 }, null, 2).play();

    }

}

//********************************************************************************
import flash.display.Bitmap;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
class ButtonSet extends Sprite
{
    private var btnOut:*;
    private var btnOver:*;
    private var _function:Function;
    private var w:int;
    private var h:int;
    private var overImg:Bitmap;
    private var outImg:Bitmap;

    public function ButtonSet(_trgt:Object,_width:int=100,_height:int=20,_name:String='',_overImg:Bitmap=null,_outImg:Bitmap=null,_fnc:Function=null):void
    {
        w = _width;
        h = _height;
        var txt:TextField = new TextField();
        txt.textColor = 0xFFFFFF;
        txt.autoSize = TextFieldAutoSize.CENTER;
        overImg = _overImg;
        outImg = _outImg;

        //イメージ画像が無い場合は、デフォルトを設定する
        if (_overImg == null || _outImg == null)
        {
            btnOut = new Shape();
            btnOver = new Shape();
            fnDraw();
            txt.text = _name;
            txt.selectable = false;
        }else
        {
            //イメージ画像が有りの場合
            btnOut = new Sprite();
            btnOver = new Sprite();
            btnOut.addChild(_outImg);
            btnOver.addChild(_overImg);
        }

        this.addChild(btnOut);
        this.addChild(btnOver);
        this.addChild(txt);

        btnOver.alpha = 0;
        this.buttonMode = true;
        this.addEventListener(MouseEvent.CLICK, fnClick);
        this.addEventListener(MouseEvent.ROLL_OVER, fnOver);
        this.addEventListener(MouseEvent.ROLL_OUT, fnOut);

        _function = _fnc;
        _trgt.addChild(this);

    }

    private function fnDraw():void
    {
        if (w <= 100) w = 100;
        if (h <= 20) h = 20;
        btnOut.graphics.clear();
        btnOut.graphics.beginFill(0x666666, 1);
        btnOut.graphics.drawRect(0, 0, w, h);

        btnOver.graphics.clear();
        btnOver.graphics.beginFill(0x444444, 1);
        btnOver.graphics.drawRect(0, 0, w, h);
    }

    public function set _width(value:int):void{
        w = value;
        if (overImg == null || outImg == null)fnDraw();
    }

    public function set _height(value:int):void{
        h = value;
        if (overImg == null || outImg == null)fnDraw();
    }

    private function fnOver(e:MouseEvent):void
    {
        btnOver.alpha = 1;
    }

    private function fnOut(e:MouseEvent):void
    {
        btnOver.alpha = 0;
    }

    private function fnClick(e:MouseEvent):void
    {
        (_function!=null)?(_function()):(0);
    }

}

