/**
 * Copyright Wataru.Miyazaki ( http://wonderfl.net/user/Wataru.Miyazaki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3XKP
 */

// forked from Wataru.Miyazaki's 新新BaseBox ver1.0(0)
// forked from Hiroki.Nigorinuma's forked from: forked from: Label機能
// forked from Wataru.Miyazaki's forked from: Label機能
// forked from Hiroki.Nigorinuma's Label機能
// forked from oshige's TextField_INPUT
package {
    import flash.ui.Mouse;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.text.*;
    import flash.events.KeyboardEvent;
    import com.actionscriptbible.Example;
    public class CreateBaseBox extends Example {
        
        private var baseSprite:Sprite;
        private var baseTextField:TextField;
        private var baseMarker:Array;
        private var mouseMove:Boolean;
        private var sizing:Boolean;
        private var baseRect:Rectangle;
        
        public function CreateBaseBox(){
              
            baseRect = new Rectangle(100,100,300,24);  
              
            // フラグ
            mouseMove = false;
            sizing    = false;
            
            // ベースのオブジェクト
            baseSprite = new Sprite();
            //rect.graphics.beginFill(0xCCCCCC);
            baseSprite.graphics.drawRect(baseRect.x,baseRect.y,baseRect.width,baseRect.height);
            baseSprite.buttonMode = true;
            addChild(baseSprite);
            
            // テキストの書式
            var textFormat:TextFormat = new TextFormat();
            textFormat.font = "_typewriter";
            textFormat.size = 18;
            
            //テキスト入力フィールドの作成
            baseTextField = new TextField();
            //baseTextField.type = TextFieldType.INPUT;
            baseTextField.defaultTextFormat = textFormat;
            baseTextField.x = baseRect.x;
            baseTextField.y = baseRect.y;
            baseTextField.width = baseRect.width;
            baseTextField.height = baseRect.height;
            baseTextField.border = true;
            baseSprite.addChild(baseTextField);
            
            // イベント実装
            baseSprite.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            baseSprite.addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
            baseSprite.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            baseSprite.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);

            // 拡大縮小のボタン（BaseMarker）の作成
            baseMarker= new Array();
            for(var i:int=0;i<8;i++){
                baseMarker[i] = new BaseMarker()
                
                switch(i){
                    case 0:
                    baseMarker[i].markerType = "TOP_LEFT";
                    baseMarker[i].x = baseRect.x;
                    baseMarker[i].y = baseRect.y;
                    break;
                    case 1:
                    baseMarker[i].markerType = "TOP";
                                       baseMarker[i].x = baseRect.x+baseRect.width/2;
                    baseMarker[i].y = baseRect.y;
                    break;
                    case 2:
                    baseMarker[i].markerType = "TOP_RIGHT";
                    baseMarker[i].x = baseRect.x+baseRect.width;
                    baseMarker[i].y = baseRect.y;
                    break;
                    case 3:
                    baseMarker[i].markerType = "LEFT";
                    baseMarker[i].x = baseRect.x;
                    baseMarker[i].y = baseRect.y+baseRect.height/2;
                    break;
                    case 4:
                    baseMarker[i].markerType = "RIGHT";
                    baseMarker[i].x = baseRect.x+baseRect.width;
                    baseMarker[i].y = baseRect.y+baseRect.height/2;
                    break;
                    case 5:
                    baseMarker[i].markerType = "BOTTOM_LEFT";
                    baseMarker[i].x = baseRect.x;
                    baseMarker[i].y = baseRect.y+baseRect.height;
                    break;
                    case 6:
                    baseMarker[i].markerType = "BOTTOM";
                    baseMarker[i].x = baseRect.x+baseRect.width/2;
                    baseMarker[i].y = baseRect.y+baseRect.height;
                    break;
                    case 7:
                    baseMarker[i].markerType = "BOTTOM_RIGHT";
                    baseMarker[i].x = baseRect.x+baseRect.width;
                    baseMarker[i].y = baseRect.y+baseRect.height;
                    break;
                    
                    default:
                    break;
                }
                
                baseSprite.addChild(baseMarker[i]);
                
                baseMarker[i].addEventListener(MouseEvent.MOUSE_DOWN, onMouseDownButton);
                baseMarker[i].addEventListener(MouseEvent.MOUSE_UP, onMouseUpButton);
                baseMarker[i].addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            }        
        }
//=============================================================================
// ドラッグ移動 baseSpriteのマウスイベント        
        private function onMouseDown(e:MouseEvent):void{
            trace("onMouseDown");
            if (!sizing) {
                e.currentTarget.startDrag();
            }
        }
        private function onMouseUp(e:MouseEvent):void{
            //trace("onMouseUp");
            trace(e.currentTarget.x,e.currentTarget.y);
            if (!sizing) {
                e.currentTarget.stopDrag();
            }
        }
//=============================================================================
// 選択時に色づけ baseSpriteのマウスイベント                        
        private function onMouseOver(e:MouseEvent):void{
            //trace("onMouseOver");
            baseTextField.borderColor = 0xFF0000;
        }
        private function onMouseOut(e:MouseEvent):void{
            //trace("onMouseOut",baseSprite.x);
            baseTextField.borderColor = 0x000000;
        }
//=============================================================================
// 拡大縮小の種類を判別 baseMarkerのマウスイベント                
        private function onMouseDownButton(e:MouseEvent):void{
            trace("onMouseDownButton");
            mouseMove = true;
            sizing = true;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            e.currentTarget.startDrag();
        }
        private function onMouseUpButton(e:MouseEvent):void{
            trace("onMouseUpButton");
            mouseMove = false;
            sizing = false;
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            e.currentTarget.stopDrag();
        }
        private function onMouseMove(e:MouseEvent):void{
            //trace("onMouseMove",e.stageX,e.currentTarget.x,fld.x);
            if(mouseMove){
                if(e.currentTarget.markerType.indexOf("RIGHT")!=-1){
                    stretchRight(e.stageX-baseTextField.x-baseSprite.x);     
                }
                if(e.currentTarget.markerType.indexOf("BOTTOM")!=-1){
                    stretchDown(e.stageY-baseTextField.y-baseSprite.y);
                }
                if(e.currentTarget.markerType.indexOf("TOP")!=-1){
                    //trace("e.stageY",e.stageY,"baseFiedlY",baseTextField.y,"baseTextField.height",baseTextField.height,"baserect",baseRect.y);
                    stretchUp(e.stageY);
                }
                if(e.currentTarget.markerType.indexOf("LEFT")!=-1){
                    stretchLeft(e.stageX);
                    
                }
            }
        }        
//=============================================================================
// 拡大縮小 baseMarkerのマウスイベント          
        private function stretchRight(width:Number):void{
            baseTextField.width = width;
            baseMarker[1].x = baseTextField.x+width/2;
            baseMarker[2].x = baseTextField.x+width;
            baseMarker[4].x = baseTextField.x+width;
            baseMarker[6].x = baseTextField.x+width/2;
            baseMarker[7].x = baseTextField.x+width;
        }
        private function stretchLeft(x:Number):void{
            trace("basetf",x);
            baseTextField.x = x-baseSprite.x;
            baseTextField.width = baseMarker[7].x-x+baseSprite.x;
            
            baseMarker[0].x = x-baseSprite.x;
            baseMarker[3].x = x-baseSprite.x;
            baseMarker[5].x = x-baseSprite.x;
            baseMarker[1].x = x+baseTextField.width/2-baseSprite.x;
            baseMarker[6].x = x+baseTextField.width/2-baseSprite.x;
        }
        private function stretchDown(height:Number):void{
            baseTextField.height = height;
            baseMarker[3].y = baseTextField.y+height/2;
            baseMarker[4].y = baseTextField.y+height/2;
            baseMarker[5].y = baseTextField.y+height;
            baseMarker[6].y = baseTextField.y+height;
            baseMarker[7].y = baseTextField.y+height;
            
        }
        private function stretchUp(y:Number):void{
            baseTextField.y = y-baseSprite.y;
            baseTextField.height = baseMarker[7].y-y+baseSprite.y;
            
            baseMarker[0].y = y-baseSprite.y;
            baseMarker[1].y = y-baseSprite.y;
            baseMarker[2].y = y-baseSprite.y;
            baseMarker[3].y = y+baseTextField.height/2-baseSprite.y;
            baseMarker[4].y = y+baseTextField.height/2-baseSprite.y;
        }
    }
}
//=============================================================================
// 拡大縮小ボタン
import flash.display.Sprite;

class BaseMarker extends Sprite{
    
    public var markerType:String;
    
    public function BaseMarker(){
        graphics.lineStyle(1, 0x999999);
        graphics.beginFill(0xFFFFFF);
        graphics.drawCircle(0, 0, 6);
    }
}