/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3XGS
 */

package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const N:uint = 100;
    static private const W:uint = 100;
    
    private function _init():void
    {
        _debug(
            "各テスト " + N + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        _measure("floodFill+histogram", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
	        		var bmd : BitmapData = new BitmapData(W, W, false, 0x000000);
                bmd.floodFill(0, 0, 0x000001);
                var num : uint = bmd.histogram()[2][1];
                bmd.dispose();
            }
            _debug(num.toString());
        });
        
        _measure("array", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
            		var a : Array = new Array(W * W);
            		for(var j : uint = 0;j < a.length;j++)a[j] = 0;
            		
            		var q : Array = [0];
            		a[0] = 1;
            		var ct : uint = 1;
            		while(q.length > 0){
            			var ind : uint = q.pop();
            			for each(var d : int in [-1, 1, -W, W]){
            				var nind : int = ind + d;
            				if(nind < 0 || nind > a.length)continue;
            				if(a[nind] == 0){
            					a[nind] = 1;
            					q.push(nind);
            					ct++;
            				}
            			}
            		}
            		var num : uint = ct;
            }
            _debug(num.toString());
        });
        
        _debug("\n連結性チェックはfloodFillでやろう");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
