/**
 * Copyright MMMMMonchi ( http://wonderfl.net/user/MMMMMonchi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Wvi
 */

// forked from Murai's #2 Loop forked from: #1 LikeATimeLine WonderflBook Interactive2
// forked from Murai's #1 LikeATimeLine WonderflBook Interactive2
package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.GlowFilter;

    /*
       @author Takashi Murai(KAYAC)
     */

    [SWF(width="465",height="465",backgroundColor="0x000000",frameRate="30")]
    public class WonderflBook extends Sprite {

        private var ball:Sprite;
        private var startX:Number=0;//xのスタート位置
        private var endX:Number=stage.stageWidth;//xのエンド位置
        private var frameCount:uint=0;//再生ヘッド（フレーム数カウント用の変数）
        private var frameCountLimit:uint=28;//コマ数（最終フレームの位置）
        private var animationFrames:Array;//フレーム格納用の配列

        public function WonderflBook(){
            init();
        }

        public function init():void{//初期化メソッド
            animationFrames=generateAnimationFrames();//アニメーションフレームの生成

            ball=new Sprite();//このコードで唯一のグラフィックオブジェクト。画面に表示されるballです。
            ball.graphics.lineStyle(1,0x00FFFF);
            ball.graphics.beginFill(0x00FFFF,0.2);
            ball.graphics.drawCircle(0,stage.stageHeight/2,5);
            ball.graphics.endFill();
            //ball.blendMode=BlendMode.ADD;
            ball.filters=[new GlowFilter(0x00FFFF,1,16,16,2,2)];
            addChild(ball);//ballをDisplayTreeへ登録
            
            start();//レンダリング開始
        }

        private function generateAnimationFrames():Array{//アニメーションフレームを生成するメソッド
            var tmp:Array=new Array();//出力用の一時的な配列
            var easeRatio:Number=0.2;//イージングの比率
            var tmpX:Number=startX;
            for(var i:uint=0;i<frameCountLimit;i++){
                tmpX+=(endX-tmpX)*easeRatio
                tmp.push(tmpX);//各コマのx座標をコマ数だけ計算して配列に追加
            }
            return tmp;
        }

        /*
              書籍での行番号合わせのため、インデントが入っています。
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
              
        */
        private function render(e:Event):void{//レンダリング用のメソッド
            　//現在のフレーム数がframeCountLimit以内なら
            if(frameCount < frameCountLimit){
                ball.x=animationFrames[frameCount];//ballのxに今のコマ数のx座標を代入
            }else{
                //stop();//アニメーション終了
                frameCount=0;         
            }
            frameCount++;//再生ヘッドを進める
        }

        public function start():void{addEventListener(Event.ENTER_FRAME,render);};//スタート用のメソッド。renderがENTER_FRAMEのタイミングで実行されるように設定
        public function stop():void{removeEventListener(Event.ENTER_FRAME,render);};//ストップ用のメソッド。renderがENTER_FRAMEのタイミングで実行されるように設定されているのを解除
    }
}

