/**
 * Copyright knd ( http://wonderfl.net/user/knd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3Vyr
 */

package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.net.*;
	import flash.utils.*;
	import flash.system.*;
	import com.flashdynamix.utils.*;

	/**
	 * 平行法で見ると飛び出す花火･･･のつもりだったんですが
	 * 目が疲れるだけで､あまりうまくいってません｡
	 */
	[SWF(width="465", height="465", backgroundColor=0x000000, frameRate=60)]
	public class Sponsor extends Sprite {
	 
		private var _particles:Vector.<Object>;
		private var _pVectors: Array = [];
		private var _gradientMap:BitmapData; 
		private var _timer:Timer; 
   
		private const PARTICLES_LENGTH:int = 500;

		private function setup():void{
			_gradientMap= new BitmapData(200,10, true, 0);
			// addChild( new Bitmap( _gradientMap) ); // for debug
			updateGradientFill();
				
			shotFirework();
			shotFirework();
		   
			_timer = new Timer( 4000, 0 );
			_timer.addEventListener( TimerEvent.TIMER, timerHadler );
			_timer.start();
			
			_loader = new Loader();
			_loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onLoadComplete );
			_loader.load( new URLRequest("http://level0.kayac.com/space.jpg"), new LoaderContext(true) );
			
		}
		private var _loader:Loader;
		private function onLoadComplete(e:Event):void {
			var bg:BitmapData = new BitmapData(_loader.width, _loader.height);
			bg.draw(_loader);
			bg.copyPixels(bg, new Rectangle(0, 0, bg.width >> 1, bg.height), new Point(bg.width >> 1, 0));
			addChildAt( new Bitmap(bg), 0 ); 
		}
		
		private function shotFirework():void {
			_particles = new Vector.<Object>();
			var radius:Number = Math.random()* 5 + 2;
			var radian:Number = Math.PI*2;
			const offsetX:int = 100 * Math.random() - 50, offsetY:int = - 45;
			for ( var i :int = 0; i < PARTICLES_LENGTH; i++ ) {
				var direction_t:Number = Math.random() * Math.PI;
				var cos_t:Number = Math.cos(direction_t);
				var direction_p:Number = Math.random()*radian;
				var tx:Number = cos_t * Math.sin(direction_p);
				var ty:Number = cos_t * Math.cos(direction_p);
				var tz:Number = Math.sin(direction_t);
				
				var sl:Number = radius * ( 0.9 + 0.2 * Math.random());
				var vl:Number = sl;// Math.random() * radius;
				
				
				var particle :Object= {
					x: _center.x + tx*sl + offsetX,
					y: _center.y + ty * sl + offsetY,
					z: _center.z + ty * sl,
					vx: tx*vl,
					vy: ty * vl,
					vz: tz * vl,
					life: Math.random()* 30 + 170
				};
				_particles.push(particle);
			}
			_pVectors.push(_particles);
			_particles = null;
		}
		
		private const FRICTION:Number = 0.95;
		private const GRAVITY:Number = 0.02;
		private const WIND:Vector3D = new Vector3D(0.001,0,0.001 );
		
		private function updateCalcuration():void {
			for each (_particles in _pVectors ) {
				for each( var p:Object in _particles ) {
					p.vx =  p.vx * FRICTION + WIND.x + Math.random()*0.01-.005;
					p.vy =  p.vy * FRICTION + WIND.y + GRAVITY + Math.random()*0.01-.005;
					p.vz =  p.vz * FRICTION + WIND.z + Math.random()*0.01-.005;
					p.x = p.x + p.vx;
					p.y = p.y + p.vy;
					p.z = p.z + p.vz;
					p.life--;
				}				
			}
			_particles = null;
		}
		
		private function updateDrawing():void{
			_canvasL.colorTransform( _canvasL.rect, CTF );
			_canvasR.colorTransform( _canvasR.rect, CTF );
			_canvasL.lock();
			_canvasR.lock();
			for each (_particles in _pVectors ) {
				for each( var p:Object in _particles ) {
					if ( p.life <= 0 ) continue;
					var cz:Number = _center.z;
					var _x :Number
					var _z :Number
					var _a: Number = p.z > cz ? cz / p.z: 1 ;
					_x = _cosLR * (p.x - 200) + _sinLR * p.z;
					_z = -_sinLR * (p.x - 200) + _cosLR * p.z;
					_canvasL.setPixel32( cz * _x / _z, cz * p.y / _z, getColor(p.life, _a));
					_x = _cosLR * (p.x + 200) + -_sinLR * p.z;
					_z = _sinLR * (p.x + 200) + _cosLR * p.z;
					_canvasR.setPixel32( cz * _x / _z, cz * p.y / _z, getColor(p.life, _a));
				}
			}
			_canvasL.unlock();
			_canvasR.unlock();
		}
		 
		private function timerHadler (e:Event):void{
		   updateGradientFill();
		   _pVectors.shift();
			shotFirework();
		}
		 
		private function getColor(position:int, alpha:Number = 1.0):uint {
			return _gradientMap.getPixel( position, 0 ) | (alpha > 1? 0xff000000: alpha < 0? 0 : (0xffffffff * alpha) & 0xff000000);
		}
		
		private const CTF:ColorTransform = new ColorTransform( 0.94, 0.94, 0.94, 0.96 );
		private const COLORS:Array = [ 0xFFCCFF, 0xFF9999, 0xFFFF99, 0x99CCFF, 0xCCFF99 ];
		private function updateGradientFill():void {
			var sp:Shape= new Shape();
			var color:uint = COLORS[ Math.random()*COLORS.length>>0];
			var mtx:Matrix = new Matrix();
			mtx.createGradientBox(200, 0, 0, 0, 0);
			sp.graphics.beginGradientFill( GradientType.LINEAR,
				[ 0x333333, color, color, color*0.9>>0, 0x000000 ],
				[ 1, 1, 1, 1, 1 ],
				[ 8, 64, 102, 204, 255],
				mtx,
				InterpolationMethod.RGB
			);
			sp.graphics.drawRect( 0, 0, 200, 10 );
			sp.graphics.endFill();
			_gradientMap.draw(sp);
			sp = null;	
		}
		
		
		
		private var _canvasL:BitmapData;
		private var _canvasR:BitmapData;
		private var _center:Vector3D;
		
		private var _cosLR:Number;
		private var _sinLR:Number;
		private function init():void {
			_cosLR = Math.cos(0.2);
			_sinLR = Math.sin(0.2);
			
			_center= new Vector3D();
			_center.x = stage.stageWidth >>2;
			_center.y = stage.stageHeight >> 1;
			_center.z = Math.max(stage.stageWidth, stage.stageHeight)*2 >> 0;
			
			_canvasL  = new BitmapData( stage.stageWidth >>> 1, stage.stageHeight, true, 0 );
			_canvasR  = new BitmapData( stage.stageWidth >>> 1, stage.stageHeight, true, 0 );
			var bmpL:Bitmap = new Bitmap(_canvasL);
			bmpL.x = 0;
			var bmpR:Bitmap = new Bitmap(_canvasR);
			bmpR.x = bmpL.width + 1;

			addChild( bmpL );
			addChild( bmpR );
			
			setup();
			addEventListener( Event.ENTER_FRAME, enterFrame);
			
			SWFProfiler.init( this );
		}
		private function enterFrame( e:Event ):void {
			updateCalcuration();
			updateDrawing();
		}
		
		
		
		
		public function Sponsor() {
			addEventListener( Event.ADDED_TO_STAGE, addToStage );
		}
		private function addToStage (e:Event):void {
			init();
		}
	}
}
	