/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/3VcB
 */

// forked from AsaToBan's particle test
package {
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import net.hires.debug.Stats;
    //import flash.filters.ColorTransform;
    
    [SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]
    public class Main extends Sprite{
        private var vVec:Vector.<Particle>;
        private var bitmapData:BitmapData;
         
        public function Main(){
            bitmapData = new BitmapData(stage.stageWidth,stage.stageHeight,false,0x000000);
            var bmp:Bitmap = new Bitmap(bitmapData);
            addChild(bmp);
            
            addChild(new Stats());
            vVec = new Vector.<Particle>();
            stage.addEventListener(MouseEvent.MOUSE_MOVE,onMouseMove);
            stage.addEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
        
        private function onMouseMove(e:MouseEvent):void{
            var pir:Particle = new Particle(stage.mouseX,stage.mouseY);
            this.addChild(pir);
            vVec.push(pir);
        }
        
        private function onEnterFrame(e:Event):void{
            var i:int = vVec.length;
            while(i)
            {
                i--;
                var pir:Particle = vVec[i] as Particle;
                pir.y += pir.iRam;
            }
        }
    }
}

////////////////////////////////////
// particle class
///////////////////////////////////
import flash.display.Sprite;
import flash.filters.GlowFilter;
import flash.filters.BlurFilter;
class Particle extends Sprite {
    private var px:Number;
    private var py:Number;
    public var iRam:int;
    public var gloww:GlowFilter = new GlowFilter(0xFFFFFF, 1, 16,16, 2,2,false);
    public var blurr:BlurFilter = new BlurFilter( 10,10,3 );
    public function Particle(_x:Number,_y:Number){
        iRam = Math.floor(Math.random()*-10);
//      this.graphics.beginFill(0x00CCFF);
        this.graphics.beginFill(0xFFFFFF * Math.random());
        this.filters = [gloww, blurr];
        this.blendMode = "add";
        this.graphics.drawRect(_x,_y,23,23);
        this.graphics.endFill();
 
    }
}

